<?php
include_once 'config.php';
include_once 'telegram.php';
include_once 'class.php';
include_once 'jdf.php';
$telegram = new telegram(TOKEN,HOST,USERNAME,PASSWORD,DBNAME);
$telegram->db->exec("set names utf8mb4");
$class = new \netparadis\telegram(TOKEN);

$telegram_ip_ranges = [['lower' => '149.154.160.0','upper' => '149.154.175.255'],['lower' => '91.108.4.0','upper' => '91.108.7.255']];
$ip_dec = (float) sprintf("%u", ip2long($_SERVER['REMOTE_ADDR']));
$ok = true;
foreach($telegram_ip_ranges as $telegram_ip_range){
    if($ok){
        $lower_dec = (float) sprintf("%u", ip2long($telegram_ip_range['lower']));
        $upper_dec = (float) sprintf("%u", ip2long($telegram_ip_range['upper']));
        if($ip_dec >= $lower_dec and $ip_dec <= $upper_dec){
            $ok = false;
        }
    }
}
if($ok){
    //die('These fake updates are outdated');
    die('this is not allowed');
}

$time = time();

// user
$result = $telegram->getTxt();
$text = '';
if(isset($result->message)){
	$userid = $result->message->from->id;
	$text = $result->message->text;
	$fname = $result->message->from->first_name;
	$lname = $result->message->from->last_name;
	$username = $result->message->from->username;
	$msgid = $result->message->message_id;
	if(isset($result->message->reply_to_message)){
		$fwuid = $result->message->reply_to_message->forward_sender_name;
		$fwuid2 = $result->message->reply_to_message->forward_from->id;
		$fwtext = $result->message->reply_to_message->text;
	}
	if(isset($result->message->contact)) $contact = $result->message->contact->phone_number;
}


// callback
$cdata = null;
if(isset($result->callback_query)){
	$cid = $result->callback_query->id;
	$cdata = $result->callback_query->data;
	$cmsgid = $result->callback_query->message->message_id;
	$chatid = $result->callback_query->message->chat->id;
	$chatype = $result->callback_query->message->chat->type; // channel,private
	$chatus = $result->callback_query->message->chat->username; // channelusername , normaluser-username
	$cuserid = $result->callback_query->from->id;
	$cfname = $result->callback_query->from->first_name;
	$userid = $cuserid;
}


// inline
if(isset($result->callback_query)){
	$query = $result->inline_query->query;
	$queryid = $result->inline_query->id;
	$inlineUserId = $result->inline_query->from->id;
	$inlinename = $result->inline_query->from->first_name;
	$inlineusername = $result->inline_query->from->username;
}

$cancelop=array(array('❌ انصراف'));
function get_type($id){
    $url = "https://api.telegram.org/bot".TOKEN."/getFile?file_id=$id";
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    $res = curl_exec($ch);
    if(curl_error($ch)){
        var_dump(curl_error($ch));
    }else{
        return json_decode($res);
    }
}

// upload file
if (isset($result->message->document->file_id)) {
    $fileid = $result->message->document->file_id;
} elseif (isset($result->message->audio->file_id)) {
    $fileid = $result->message->audio->file_id;
} elseif (isset($result->message->photo[0]->file_id)) {
    $fileid = $result->message->photo->file_id;
    if (isset($result->message->photo[2]->file_id)) {
        $fileid = $result->message->photo[2]->file_id;
    } elseif (isset($result->message->photo[1]->file_id)) {
        $fileid = $result->message->photo[1]->file_id;
    } else {
        $fileid = $result->message->photo[0]->file_id;
    }
} elseif (isset($result->message->voice->file_id)) {
    $voiceid = $result->message->voice->file_id;
} elseif (isset($result->message->audio->file_id)) {
    $fileid = $result->message->audio->file_id;
}
if(isset($result->message->caption)) $caption = $result->message->caption;
//$telegram->sendMessage($userid,$fileid);
$startmsg = 'سلام .
به ربات Tehransshخوش آمدید.';


$userstate = 'state/' . $userid . '.txt';
if (!file_exists($userstate)) {
    $userfile = fopen('state/' . $userid . '.txt', "w");
    fclose($userfile);
    $userfile = fopen('state/' . $userid . '-free.txt', "w");
    fclose($userfile);
}
$state = file_get_contents('state/' . $userid . '.txt');

$finalop = array(
    array('🔥 تست رایگان','🛍 خرید سرویس'),
    array( '🔎استعلام','➕ثبت لینک'),
    array('🧑‍💻سرویس های من','💰کیف پول'),
    array('🆔 آیدی من','📥 لینک دعوت'),
    array('💎دریافت نرم افزار یا اپلیکیشن'),
    array('💡راهنمای اتصال', '👤ارتباط با ما'),
);
$cancelop = array(array('❌ انصراف'));
$imgop = array(array('رد کردن این مرحله'),array('❌ انصراف'));

if ($userid == ADMIN or isAdmin()) {
    $finalop[] = ['⚙️ مدیریت'];
    $adminop = array(
        array('➕ثبت پلن','مدیریت پلن ها'),
        array('افزودن دسته بندی','مدیریت دسته بندی ها'),
        array('افزودن سرور','مدیریت سرورها'),
		array('📨 فوروارد همگانی', '🗒 پیام همگانی'),
        array('موجودی کاربران','🔐ادمین ها'),
		array('👤 پیگیری افراد', 'کد تخفیف'),
		array('پلن حجمی', 'پلن زمانی'),
		array('📈آمار','📮 پیام به کاربر'),
		array('🤖درگاه و امکانات‌','⚙️ تنظیمات'),
		array('همکارها','افزودن همکار جدید'),
		array('🏠 منوی اصلی',"🔎جستجو سفارش"),
    );
}
$productop = [
    ['مدیریت پلن ها','افزودن پلن جدید'],
    ['🏠 منوی اصلی']
];
$catop = [
    ['مدیریت دسته بندی ها','افزودن دسته بندی جدید'],
    ['🏠 منوی اصلی']
];

$phonekeys = array(
    array(
        array('text'=>'📲 ارسال شماره تلفن','request_contact'=>true)
    )
);

$ban = $telegram->db->query("select * from fl_user where userid='$userid'");
if($ban){
    $ban = $ban->fetch(2);
    if($ban) {
        if($ban['status']=='0' and !($userid == ADMIN) ){$telegram->sendMessage($userid,'حساب کاربری شما از سمت مدیریت بن شده است');exit;}
    }
}
$botstatus = file_get_contents('botstatus');
if($botstatus=='close' and !($userid == ADMIN or isAdmin()) ){
	$telegram->sendMessage($userid,'در حال حاضر ربات غیرفعال است');exit;
}
$gateways = $telegram->db->query("select * from gateway where id=1")->fetch(2);
$channel = CHANNEL;
$status = bot('getChatMember', [
    'chat_id' => "$channel",
    'user_id' => $userid
])->result->status;


if(preg_match('/sendpm/',$cdata)){
    
    $sid = str_replace('sendpm#','',$cdata);
    
    if($sid == 'all'){
        $dbresult = $telegram->db->query("select userid from fl_user")->fetchAll(2);
    }elseif($sid == 'customers'){
        $dbresult = $telegram->db->query("SELECT userid FROM `fl_order` where status=1 and amount > 2 GROUP BY userid")->fetchAll(2);
    }else{
        $dbresult = $telegram->db->query("SELECT userid FROM `fl_order` where status=1 and amount > 2 and server_id=$sid GROUP BY userid")->fetchAll(2);
    }
    
    $spm = $state;
    file_put_contents('state/' . $userid . '.txt', '');
	
    $telegram->sendMessageCURL($userid, '👍🏻✅ پیام شما با موفقیت برای کاربران ارسال شد ', $adminop);
    if($fileid !== null) {
		foreach ($dbresult as $user) {
			if ($user['userid'] != ADMIN) {
				$res = get_type($fileid);
				$gftype = $res->result->file_path;
				//$telegram->sendMessage(ADMIN, json_encode($user['userid']));
				if(preg_match('/music/',$gftype)){
					bot('sendaudio',[
						'chat_id' => $user['userid'],
						'audio' => $fileid,
						'caption' => $result->message->caption
					]);
				}elseif (preg_match('/video/',$gftype)){
					bot('sendvideo',[
						'chat_id' => $user['userid'],
						'video' => $fileid,
						'caption' => $result->message->caption
					]);
				}elseif (preg_match('/document/',$gftype)){
					bot('senddocument',[
						'chat_id' => $user['userid'],
						'document' => $fileid,
						'caption' => $result->message->caption
					]);
				}elseif (preg_match('/photo/',$gftype)) {
					bot('sendphoto', [
						'chat_id' => $user['userid'],
						'photo' => $fileid,
						'caption' => $result->message->caption
					]);
				}elseif($result->message->location){
					$latitude = $result->message->location->latitude;
					$longitude = $result->message->location->longitude;
					bot('sendLocation', [
						'chat_id' => $user['userid'],
						'latitude' => $latitude,
						'longitude' => $longitude
					]);
				}else {
					bot('senddocument',[
						'chat_id' => $user['userid'],
						'document' => $fileid,
						'caption' => $result->message->caption
					]);
				}
			}
		}
	}else{
		foreach ($dbresult as $user) {
			if ($user['userid'] != ADMIN) {
				$telegram->sendMessage($user['userid'], $spm);
			}
		}
	}
}
if( ($fwuid or $fwuid2) and ($userid == ADMIN or isAdmin())){
	$replymsg = $text;
    //$telegram->sendMessage($userid, $fwuid);
    if($fwuid2) $fuid = $fwuid2; else $fuid = $telegram->db->query("SELECT * FROM fl_user WHERE name='$fwuid'")->fetch(2)['userid'];
    //$telegram->sendMessage($userid, $fwuid);$telegram->sendMessage($userid, "SELECT * FROM fl_user WHERE name='$fwuid'");
    $text = " پیام شما : $fwtext

پاسخ مدیریت : $replymsg
.";
	$telegram->sendMessage($fuid,$text);
	$res = get_type($fileid);
	$gftype = $res->result->file_path;
	if(preg_match('/music/',$gftype)){
		bot('sendaudio',[
			'chat_id' => $fuid,
			'audio' => $fileid,
			'caption' => $caption
		]);
	}elseif (preg_match('/video/',$gftype)){
		bot('sendvideo',[
			'chat_id' => $fuid,
			'video' => $fileid,
			'caption' => $caption
		]);
	}elseif (preg_match('/document/',$gftype)){
		bot('senddocument',[
			'chat_id' => $fuid,
			'document' => $fileid,
			'caption' => $caption
		]);
	}elseif (preg_match('/photo/',$gftype)) {
		bot('sendphoto', [
			'chat_id' => $fuid,
			'photo' => $fileid,
			'caption' => $caption
		]);
	}elseif($result->message->location){
		$latitude = $result->message->location->latitude;
		$longitude = $result->message->location->longitude;
		bot('sendLocation', [
			'chat_id' => $fuid,
			'latitude' => $latitude,
			'longitude' => $longitude
		]);
	};
	$telegram->sendMessage($userid,'ریپلای با موفقیت برای کاربر ارسال شد');
	// update button
    bot('editMessageReplyMarkup',[
		'chat_id' => $userid,
		'message_id' => $cmsgid,
		'reply_markup' => json_encode([
            'inline_keyboard' => [[['text' => '✅پاسخ داده شد', 'callback_data' => "dontsendanymore"]]],
        ])
    ]);
	
	$admins = file_get_contents('admins.php');
    $list = explode(PHP_EOL,$admins);
    foreach($list as $admid){
        if(strlen($admid) > 3 and $admid != $userid){
           $telegram->sendMessage($admid,"پیام زیر توسط یکی از همکاران پاسخ داده شد. لطفا از ارسال پاسخ جدید خودداری کنید:

متن پیام : $fwtext
پاسخ مدیریت‌ : $admtext");
        }
    }
    if(ADMIN != $userid) $telegram->sendMessage(ADMIN,"پیام زیر توسط یکی از همکاران پاسخ داده شد. لطفا از ارسال پاسخ جدید خودداری کنید:

متن پیام : $fwtext
پاسخ مدیریت‌ : $admtext");
}

if(!empty($contact)){
    if(strpos($contact, $valid_country_code) === false){
        $telegram->sendMessage($userid,"⚠️فقط پیش شماره های ($valid_country_code) مجاز است");
        exit;
    }
    $telegram->db->query("update fl_user set tel='$contact' where userid='$userid'");
    $msg = '✅شماره تلفن شما با موفقیت ثبت شد و می توانید از ربات استفاده کنید';
    $telegram->sendMessageCURL($userid,$msg,$finalop);
    $state = file_put_contents('state/'.$userid.'.txt','');
    exit;
} 

if (preg_match('/^\/([Ss]tart)/', $text) or $text == '🏠 منوی اصلی' or $text == '🔙بازگشت به منوی اصلی' or $cdata == 'chnnlmmber') {
    file_put_contents('state/' . $userid . '.txt', '');
    $count = $telegram->db->query("select * from fl_user where userid='$userid'")->rowCount();
    if ($count == 0) {
		$fname = preg_replace('/\/|<|\\|>/','',$fname);
		$fname = str_replace(["\\",'/','+','-','^',"'"],'',$fname);
        $refcode = time();
        $sql = "INSERT INTO `fl_user` VALUES (NULL,'$userid','$fname','$username','','$refcode', 0,$time, 1)";
        $telegram->db->query($sql);
    }
	if($cdata == 'chnnlmmber' && ($status == "kicked" || $status == "left")){
		bot('answercallbackquery', [
			'callback_query_id' => $cid,
			'text' => "هنوز عضو کانال نشدید",
			'show_alert' => false
		]);exit;
	}
    if (preg_match('/start/', $text)) {
        $refrence_code = str_replace('/start ','',$text);
        $res = $telegram->db->query("select * from fl_user where refcode='$refrence_code' and userid != $userid");
         
        if( $res->rowCount() ){
            $res = $res->fetch(2);
            $toplevel_userid = $res['userid'];
            
            $subresCount = $telegram->db->query("select * from fl_subuser where userid = $userid")->rowCount();
           
            if($subresCount == 0){
                $telegram->db->query("INSERT INTO `fl_subuser` VALUES (NULL,'$userid','$fname','$refrence_code','$toplevel_userid')");
            }
            
        }
    } // start
    
	$user_detail = $telegram->db->query("select * from fl_user where userid=$userid")->fetch(2);
    if($user_detail['tel'] == '' and $valid_country_code != ''){
        $telegram->sendMessageCURL($userid, 'شماره موبایل خود را با دکمه زیر به اشتراک بگذارید تا ثبت نام شما تایید شود و بتوانید از ربات استفاده کنید', $phonekeys);
        exit;
    }
    $telegram->sendMessageCURL($userid, $startmsg, $finalop);exit;
}

if ($status == "kicked" || $status == "left"){
    $keyboard = [
		[['text' => "عضویت در کانال", 'url' => "https://t.me/".str_replace('@','',$channel)]],
		[['text' => "✅عضو شدم", 'callback_data' => "chnnlmmber"]]
	];
    
    bot('sendmessage',[
        'chat_id' => $userid,
        'text' => "🔑 قبل از ادامه باید به کانال بپیوندید:",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
	exit;
}
if ($text == '🔎استعلام'){
    $msg = '🔻 لطفا لینک کانفیگ را وارد کنید '; 
    $telegram->sendMessageCURL($userid,$msg,[[ '🔙بازگشت به منوی اصلی' ]]);
    file_put_contents('state/' . $userid . '.txt', 'inquirySln');
}

if($text != '🔙بازگشت به منوی اصلی' and $state == 'inquirySln'){
    
	$result = $telegram->db->query("select * from fl_order where remark LIKE '%$text%' and status=1 and userid='$userid'")->fetch(2);
    if(!empty($result)){
        $text = $result['link'];
    }
	
    preg_match('/(vless|vmess|trojan|ss):\/\/.+/', $text, $matches);

    $text = $matches[0];
	
    if(!preg_match("/^(vless|vmess|trojan|ss):\/\/\w+/",$text)){
        $telegram->sendMessage($userid, "⚠️لطفا یک لینک کانفیگ صحیح ارسال کنید");
        exit;
    }
    if(preg_match('/^vmess:\/\//',$text)){
        $link_info = json_decode(base64_decode(str_replace('vmess://','',$text)));
        $uuid = $link_info->id;
        $panel_url = $link_info->add;
        $port = $link_info->port;
        $remark = $link_info->ps;
        $protocol = 'vmess';
        $netType = $link_info->net;
    }elseif(preg_match('/^ss:\/\//',$text)){
	    $link_info = str_replace("ss://",'',$text);
	    
	    $link_info = explode("#",$link_info);
	    $remark = $link_info[1];
	    $link_info = base64_decode($link_info[0]); 
	    $link_info = explode('@',$link_info);
	    
	    $uuid = explode(':',$link_info[0])[1];
	    $link_info = $link_info[1];
	    $link_info = explode(':',$link_info);
	    $panel_url =$link_info[0];
		$port = $link_info[1];
		$netType = '';
		$protocol = 'shadowsocks';
	}else{
        $link = urldecode($text);
        $link_info = parse_url($link);
        $panel_ip = $link_info['host'];
        $uuid = $link_info['user'];
        $remark = $link_info['fragment'];
        $protocol = $link_info['scheme'];
        $port = $link_info['port'];
        $netType = explode('type=',$link_info['query'])[1];
        $netType = explode('&',$netType)[0];

    }
    
    if(is_null($uuid)){
        $telegram->sendMessage($userid, "🚫لینک کانفیگ صحیح نیست");
        exit;
    }
    $wmsg = $telegram->sendMessage($userid, "🔎در حال بررسی کانفیگ موردنظر در سرورهای ما...");
    $wmsgid = $wmsg['result']['message_id'];
    
    $order = $telegram->db->query("select * from fl_order where remark LIKE '%$remark%' or link LIKE '%$uuid%'")->fetch(2);
    $srv = $telegram->db->query("select * from server_info where panel_url LIKE '%$panel_url%' or ip LIKE '%$panel_url%' ")->fetch(2);
    if($order){
        $srvid = $order['server_id'];
        $pwhere = "WHERE id = '$srvid'";
    }elseif($srv){
        $srvid = $srv['id'];
        $pwhere = "WHERE id = '$srvid'";
    }else{
        $pwhere = '';
    } 
    $servers = $telegram->db->query("select * from server_info $pwhere")->fetchAll(2);
    foreach($servers as $server){
        $row = get_detail($uuid, $server['panel_url'], $server['cookie'] );
        if($row) break;
    }   
    bot('deleteMessage', ['chat_id' => $userid,'message_id' => $wmsgid]);
    if(is_null($row) or $row === false) {
        $telegram->sendMessage($userid, "⛔️کانفیگ $remark در سرورهای ربات یافت نشد");
        exit;
    }
    $response_type = $row['type'];
    $row = $row['data'];  
    $total = is_null($row->total) ? $row->totalGB : $row->total;
    $up = $row->up;
    $down = $row->down; 
    $remark = ($row->remark) ? $row->remark : $row->email;
    $used = format_volume($up + $down, 2);
    $enable = (is_null($row->enable) ? true : $row->enable);
    $enable = $enable ? "✅فعال" : "☑غیرفعال";
    $expire = substr_replace($row->expiryTime, "", -3);
    $leftgb = format_volume($total - $up - $down, 2);
    $leftgb = str_replace('G',' گیگ ',$leftgb);
    $leftgb = str_replace('M',' مگابایت ',$leftgb);
    if( ($total - $up - $down) < 0 ){$leftgb = 'صفر';}
    if($total == '0') $leftgb = 'نامحدود';

    $inputSeconds = $expire - time();
    $time = secondsToTime($inputSeconds);
    $d = $time['d'];
    $h = $time['h'];
    $date = date("$d روز و $h ساعت مانده",$expire);
    if($d == 0) $date = date("$h ساعت مانده",$expire);
    if($expire < time() and $expire != 0) $date = 'به اتمام رسیده';
    if($expire == '0' or $row->expiryTime == '0') $date = 'نامحدود';
    $total = format_volume($total, 2);
    $up = format_volume($up, 2);
    $down = format_volume($down, 2);
    $jdate = ($date =='نامحدود') ? 'نامحدود':jdate('Y-m-d', $expire);
    
    $msg = "
********* مشخصات اکانت *********

🆔نام اکانت: $remark
🌟وضعیت: $enable
📡پورت: $port
🔋حجم کل اکانت: $total
⬆میزان آپلود: $up
⬇میزان دانلود: $down
⏺مجموع استفاده: $used
🪫حجم باقی مانده: $leftgb
📅روز باقیمانده: $date
🗓تاریخ انقضا: $jdate
".PHP_EOL;

    $telegram->sendMessage($userid,$msg);
    
}

if ($text == '➕ثبت لینک'){
    $msg = '🔻لطفا لینک کانفیگ را وارد کنید: ';
    $telegram->sendMessageCURL($userid,$msg,[[ '🔙بازگشت به منوی اصلی' ]]);
    file_put_contents('state/' . $userid . '.txt', 'inquiryln');
}

if($text != '🔙بازگشت به منوی اصلی' and $state == 'inquiryln'){

	preg_match('/(vless|vmess|trojan):\/\/.+/', $text, $matches);

    $text = $matches[0];
	
    if(!preg_match("/^(vless|vmess|trojan|ss):\/\/\w+/",$text)){
        $telegram->sendMessage($userid, "⚠️لطفا یک لینک کانفیگ صحیح ارسال کنید");
        exit;
    }
    //$telegram->sendMessage($userid,"22 $text");
    if(preg_match('/^vmess:\/\//',$text)){
        $link_info = json_decode(base64_decode(str_replace('vmess://','',$text)));
        $uuid = $link_info->id;
        $panel_url = $link_info->add;
        $port = $link_info->port;
        $remark = $link_info->ps;
        $protocol = 'vmess';
        $netType = $link_info->net;
    }elseif(preg_match('/^ss:\/\//',$text)){
	    $link_info = str_replace("ss://",'',$text);
	    
	    $link_info = explode("#",$link_info);
	    $remark = $link_info[1];
	    $link_info = base64_decode($link_info[0]); 
	    $link_info = explode('@',$link_info);
	    
	    $uuid = explode(':',$link_info[0])[1];
	    $link_info = $link_info[1];
	    $link_info = explode(':',$link_info);
	    $panel_url =$link_info[0];
		$port = $link_info[1];
		$netType = '';
		$protocol = 'shadowsocks';
	}else{
        $link = urldecode($text);
        $link_info = parse_url($link);
        $panel_ip = $link_info['host'];
        $uuid = $link_info['user'];
        $remark = $link_info['fragment'];
        $protocol = $link_info['scheme'];
        $port = $link_info['port'];
        $netType = explode('type=',$link_info['query'])[1];
        $netType = explode('&',$netType)[0];

    }
    $telegram->sendMessage($userid, "🔎در حال بررسی لینک موردنظر در سرورهای ما...");
    $servers = $telegram->db->query("select * from server_info")->fetchAll(2);
    foreach($servers as $server){
        $row = get_detail($uuid, $server['panel_url'], $server['cookie'] ); //$telegram->sendMessage($userid,json_encode($server));
        if($row) break;
    }  // $telegram->sendMessage($userid,json_encode($row));
    if(is_null($row) or $row == false) {
        $telegram->sendMessage($userid, "⛔️لینک ارسالی در سرورهای ربات یافت نشد");
        exit;
    }
    $response_type = $row['type'];
    $row = $row['data']; 
    $total = is_null($row->total) ? $row->totalGB : $row->total;
    $remark = ($row->email) ? $row->email : $row->remark;
	//if(isset($row->clientStats[0]->email)) $remark = $row->clientStats[0]->email;
    $leftgb = $total / 1073741824;
    $expire_date = $row->expiryTime == 0 ? $row->expiryTime : substr_replace($row->expiryTime, "", -3);
    $inbound_id = is_null($row->inboundId) ? 0 : $row->inboundId;
	//if(isset($row->clientStats[0]->inboundId)) $inbound_id = $row->clientStats[0]->inboundId;
    $server_id = $server['id'];
    $file_detail = $telegram->db->query("select * from fl_file WHERE server_id=$server_id and inbound_id = $inbound_id ORDER BY id DESC")->fetch(2);
    if($file_detail) $fid = $file_detail['id']; else $fid = 0;
    $telegram->sendMessageCURL($userid, "✅کانفیگ شما با موفقیت ثبت شد و میتوانید از بخش سرویس های من اطلاعات آن مثل تاریخ انقضا, حجم باقی مانده را ببینید",$finalop);
    file_put_contents('state/' . $userid . '.txt', '');
    $telegram->db->query("INSERT INTO `fl_order` VALUES (NULL,  $userid, 'inquiry', $fid, $server_id, $inbound_id, '$remark', '$protocol', $expire_date, '$text',2,1, '$time', 0);");
	exit;
}
if ($text == '🛍 خرید کانفیگ' or $cdata=='servers' or $text == '🛍 خرید سرویس' or $text =='/buy'){
	if($gateways['buy'] == '0'){
        $telegram->sendMessage($userid, 'در حال حاضر امکان خرید نیست و بزودی فعال میکنیم');
        exit;
    }
    $respd = $telegram->db->query("select * from fl_server WHERE active=1 and ucount > 0 ORDER BY id ASC")->fetchAll(2);
    if(empty($respd)){
        $telegram->sendMessage($userid, 'در حال حاضر هیچ سرور فعالی وجود ندارد');
        exit;
    }
    $keyboard = [];
    foreach($respd as $cat){
        $id = $cat['id'];
        $name = $cat['title'];
        $flag = $cat['flag'];
        $keyboard[] = ['text' => "$flag $name", 'callback_data' => "topcat#$id"];
    }
    $keyboard = array_chunk($keyboard,1);
    if(!is_null($cdata) and $cdata=='servers') {
        bot('editMessageText', [
            'chat_id' => $cuserid,
            'message_id' => $cmsgid,
            'text'=> ' 📍 لطفا یکی از سرورها را انتخاب کنید👇',
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }else {
        bot('sendmessage',[
            'chat_id' => $userid,
            'text'=> ' 📍 لطفا یکی از سرورها را انتخاب کنید👇',
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }

}

if(preg_match('/topcat/',$cdata) ) {
    $input = explode('#', $cdata);
    $sid = $input[1];

    $respd = $telegram->db->query("select * from fl_cat WHERE parent=0 and active=1 order by id asc")->fetchAll(2);
    if(empty($respd)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "هیچ دسته بندی برای این سرور وجود ندارد",
            'show_alert' => false
        ]);
    }else{
        
        $keyboard = [];
        foreach($respd as $file){
            $id = $file['id'];
            $name = $file['title'];
            $rowcount = $telegram->db->query("select * from fl_file WHERE server_id='$sid' and price > 0 and catid=$id and (inbound_id > 0 and acount > 0 or inbound_id = 0) and active=1")->rowCount();
            if($rowcount) $keyboard[] = ['text' => "$name", 'callback_data' => "list#$id#$sid"];
        }
        if(empty($keyboard)){
            bot('answercallbackquery', [
                'callback_query_id' => $cid,
                'text' => "پلن های سرور تکمیل ظرفیت شد",
                'show_alert' => false
            ]);exit;
        }
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "📍در حال دریافت دسته بندی ها",
            'show_alert' => false
        ]);
        $keyboard[] = ['text' => '🔙 بازگشت', 'callback_data' => "servers"];
        $keyboard = array_chunk($keyboard,1);
        bot('editMessageText', [
            'chat_id' => $cuserid,
            'message_id' => $cmsgid,
            'text' => "🔰 یکی از موارد زیر را انتخاب کنید تا لیست سرویس ها نمایش داده شود👈",
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }

}

if (preg_match('/list/', $cdata)) {
    $input = explode('#', $cdata);
    $catid = $input[1];
    $sid = $input[2];
    $respd = $telegram->db->query("select * from fl_file WHERE server_id='$sid' and catid='$catid' and (inbound_id > 0 and acount > 0 or inbound_id = 0) and price > 0  and active=1 order by id asc")->fetchAll(2);
    if (empty($respd)) {
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "💡پلنی در این دسته بندی وجود ندارد یا ظرفیت آن پر شده است ",
            'show_alert' => false
        ]);
    } else {
        $seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
        if(!empty($seller)){
            file_put_contents('state/' . $userid . '.txt', "setrmrk#$catid#$sid");
            $count = $telegram->db->query("select * from fl_remark where userid='$userid'")->rowCount();
            if ($count == 0) $telegram->db->query("INSERT INTO `fl_remark` VALUES (NULL,'$userid','')");
            $telegram->sendMessageCURL($userid,'✅لطفا اسم انتخابی اشتراک خود را وارد کنید:

⚠️توجه کنید فقط اعداد لاتین یا حروف انگلیسی و بدون فاصله وارد کنید
.',$cancelop);
            exit;
        }else{
            bot('answercallbackquery', [
                'callback_query_id' => $cid,
                'text' => "📍در حال دریافت لیست پلن ها",
                'show_alert' => false
            ]);
            $keyboard = [];
            foreach($respd as $file){
                $id = $file['id'];
                $name = $file['title'];
                $price = $file['price'];
				$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
				if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
			
                $price = ($price == 0) ? 'رایگان' : number_format($price).' تومان ';
                $keyboard[] = ['text' => "$name - $price", 'callback_data' => "file#$id#$catid"];
            }
            $keyboard[] = ['text' => '🔙 بازگشت', 'callback_data' => "topcat#$sid"];
            $keyboard = array_chunk($keyboard,1);
            bot('editMessageText', [
                'chat_id' => $cuserid,
                'message_id' => $cmsgid,
                'text' => "🔰 حالا یکی از موارد زیر را انتخاب کنید تا جزییات پلن برای شما نمایش داده شود👈",
                'reply_markup' => json_encode([
                    'inline_keyboard' => $keyboard
                ])
            ]);
        }
        
        
       
    }
}
if (preg_match('/setrmrk/', $state) and $text != '❌ انصراف') {
    
    if(!preg_match('/^[\w]+$/', $text)){
        $telegram->sendMessage($userid,'لطفا فقط حروف انگلیسی و اعداد لاتین بفرستید');die;
    }
    file_put_contents('state/' . $userid . '.txt', '');
    $telegram->db->query("update fl_remark set remark='$text' where userid='$userid'");
    $telegram->sendMessageCURL($userid,"اسم انتخابی اشتراک با موفقیت ذخیره شد",$finalop);
    
    $input = explode('#', $state);
    $cid = $input[1];
    $sid = $input[2];
    $respd = $telegram->db->query("select * from fl_file WHERE server_id='$sid' and catid=$cid and (inbound_id > 0 and acount > 0 or inbound_id = 0) and price > 0 and active=1 order by id asc")->fetchAll(2);

    $keyboard = [];
    foreach ($respd as $file) {
        $id = $file['id'];
        $name = $file['title'];
        $price = $file['price'];
        
        $seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
        if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
        
        $price = ($price == 0) ? 'رایگان' : number_format($price) . ' تومان ';
        $keyboard[] = ['text' => "$name - $price", 'callback_data' => "file#$id#$cid"];
    }
    $keyboard = array_chunk($keyboard, 1);
    bot('sendMessage', [
        'chat_id' => $userid,
        'text' => "🔰 حالا یکی از موارد زیر را انتخاب کنید تا جزییات پلن برای شما نمایش داده شود👈",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}

if($text == '🔥 اکانت تست' or $text == '🔥 تست رایگان' or $cdata == 'freesrvcs' or $text == '/freetest') {
    $free = file_get_contents("state/{$userid}-free.txt");
	if($free == '1' and !($userid == ADMIN or isAdmin() )){
		$telegram->sendMessage($userid, '⚠️شما قبلا هدیه رایگان خود را دریافت کردید');
		exit;
	}
    $query = $telegram->db->query("select * from fl_file WHERE active=1 and price = 0");
    if($query){
        $respd = $query->fetchAll(2);
        if(empty($respd)){
            $telegram->sendMessage($userid,'در حال حاضر اکانت تست وجود ندارد');
        }else{
            $keyboard = [];
            foreach($respd as $file){
                $id = $file['id'];
                $name = $file['title'];
                $server_id = $file['server_id'];
                
                $sres = $telegram->db->query("select * from fl_server WHERE id='$server_id' ")->fetch(2);
                $stitle = $sres['title'];
                $flag = $sres['flag'];
                
                $keyboard[] = ['text' => "$name - $stitle $flag", 'callback_data' => "file#$id"];
            }
            $keyboard = array_chunk($keyboard,1);
			$msg = "🔰 لطفا یکی از گزینه ها را انتخاب کنید:";
			if(!is_null($cdata) and $cdata=='freesrvcs') {
				bot('editMessageText', [
					'chat_id' => $cuserid,
					'message_id' => $cmsgid,
					'text'=> $msg,
					'reply_markup' => json_encode([
						'inline_keyboard' => $keyboard
					])
				]);
			}else {
				bot('sendMessage', [
					'chat_id' => $userid,
					'text' => $msg,
					'reply_markup' => json_encode([
						'inline_keyboard' => $keyboard
					])
				]);
			}
            
        }
    }
}
if(preg_match('/file/',$cdata)){
    $input = explode('#', $cdata);
    $id = $input[1];
	$cid = $input[2];
    /*$rcount = $telegram->db->query("select * from fl_accounts WHERE fid={$id} and active=1 and sold=0")->rowCount();
    if($rcount == 0) {
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "در حال حاضر برای این پلن اکانت قابل فروشی وجود ندارد",
            'show_alert' => true
        ]);
        exit;
    }*/
    bot('answercallbackquery', [
        'callback_query_id' => $cid,
        'text' => "♻️در حال دریافت جزییات ... ",
        'show_alert' => false
    ]);
    $respd = $telegram->db->query("select * from fl_file WHERE id='$id' and active=1")->fetch(2);
    $catname = $telegram->db->query("select * from fl_cat WHERE id=".$respd['catid'])->fetch(2)['title'];
    $name = $catname." ".$respd['title'];
    $price =  $respd['price'];
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
    if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
	
    $desc = $respd['descr'];
	$sid = $respd['server_id'];
	
	$sres = $telegram->db->query("select * from fl_server WHERE id='$sid'")->fetch(2);
	$stitle = $sres['title'];
	$flag = $sres['flag'];
	
    $fileImg = $respd['pic']."?".rand(0,999999999);
    $fileImg = "<a href='".baseURI."/$fileImg'>&#8194;</a>";
    if($price == 0 or ($userid == ADMIN or isAdmin() )){
        $keyboard = [
            [['text' => '📥 دریافت رایگان', 'callback_data' => "download#$id"]],

        ];
        if($userid == ADMIN or isAdmin() ){
            $keyboard = [
                [['text' => '📥 دریافت رایگان', 'callback_data' => "download#$id"]],
                [['text' => 'ساخت کانفیگ برای کاربر', 'callback_data' => "createForUs#$id"]]
            ];
        }
    }else{
        $token = base64_encode("{$cuserid}.{$id}");
		if($gateways['zibal']) $keyboard[] = [['text' => "پرداخت آنلاین - $price تومان", 'url' => baseURI."zibal.php?type=buy&action=pay&token=$token"]];
		if($gateways['novino']) $keyboard[] = [['text' => "پرداخت آنلاین - $price تومان", 'url' => baseURI."nvpayment.php?type=buy&action=pay&token=$token"]];
		if($gateways['payping']) $keyboard[] = [['text' => "پرداخت آنلاین2 - $price تومان", 'url' => baseURI."payping.php?type=buy&token=$token"]];
		if($gateways['bahamta']) $keyboard[] = [['text' => "پرداخت آنلاین - $price تومان", 'url' => baseURI."bahamta.php?type=buy&action=pay&token=$token"]];
 		if($gateways['zarin']) $keyboard[] = [['text' => "پرداخت زرین پال - $price تومان", 'url' => baseURI."pay.php?token=$token"]];
 		if($gateways['next']) $keyboard[] = [['text' => "پرداخت نکست پی - $price تومان", 'url' => baseURI."nextpay/pay.php?token=$token"]];
		if($gateways['card']) $keyboard[] = [['text' => "کارت به کارت - $price تومان",  'callback_data' => "offpay#$id"]];
        if($gateways['wallet']) $keyboard[] = [['text' => '🏅 پرداخت با کیف پول', 'callback_data' => "walpay#$id"]];
        
        $dcount = $telegram->db->query("select * from fl_discount WHERE active=1 and count > 0 ")->rowCount();
        if($dcount > 0 and empty($seller)){
            $keyboard[] = [['text' => '🔸کد تخفیف دارید؟ بزنید ', 'callback_data' => "submitdiscount#$id"]];
        }
    }
	$keyboard[] = [['text' => '🔙 بازگشت', 'callback_data' => $price == 0 ? "freesrvcs" : "list#$cid#$sid"]];
    $price = ($price == 0) ? 'رایگان' : number_format($price).' تومان ';
    bot('editMessageText', [
        'chat_id' => $cuserid,
        'message_id' => $cmsgid,
        'parse_mode' => "HTML",
        'text' => "
🔻$name
💰قیمت : $price
🌐 $stitle $flag
📃توضیحات :
$desc
$fileImg
",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}
if(preg_match('/submitdiscount|submitRNdiscount/',$cdata)) {
    file_put_contents("state/$userid.txt",$cdata);
    $telegram->sendMessageCURL($userid,"کد تخفیف را وارد کنید :",$cancelop);
    exit;
}
if(preg_match('/submitdiscount|submitRNdiscount/',$state) and $text != '❌ انصراف'){
    $text = strtolower($text);
    $dcount = $telegram->db->query("select * from fl_discount WHERE code='$text' and active=1 and count > 0 ");
	if(!$dcount){
        $telegram->sendMessage($userid,"کد وارد شده اشتباه است❌");
    }else{
	  if($dcount->rowCount() > 0){
        if(preg_match('/submitRNdiscount/',$state)){
            $oid = str_replace('submitRNdiscount#','', $state);
            $respd = $telegram->db->query("select * from fl_order WHERE id='$oid'")->fetch(2);
            $fid = $respd['fileid'];
        }else{
            $fid = str_replace('submitdiscount#','', $state);
        }

        $respd = $telegram->db->query("select * from fl_file WHERE id='$fid' and active=1")->fetch(2);
        $catname = $telegram->db->query("select * from fl_cat WHERE id=".$respd['catid'])->fetch(2)['title'];
        $name = $catname." ".$respd['title'];
        $price = $respd['price'];
		
		
		$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
		if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
			
        $desc = $respd['descr'];
        $fileImg = $respd['pic']."?".rand(0,999999999);
        $fileImg = "<a href='".baseURI."/$fileImg'>&#8194;</a>";

        // discount
		$dres = $dcount->fetch(2);
		$min = $dres['min'];
		$max = $dres['max'];
		$amount = $dres['amount'];
		$ownerid = $dres['userid'];
		$expire_date = $dres['expire_date'];
		$count = $dres['count'];

		if($ownerid != 0 && $ownerid != ''){
			if($ownerid != $userid){
				$telegram->sendMessage($userid,"شما امکان استفاده از این کد تخفیف را ندارید❌");
				exit;
			}
		}
		if($expire_date != '0' ){
			if($expire_date < $time or $count == '0'){
				$telegram->sendMessage($userid,"مدت زمان استفاده از این کد به پایان رسیده است❌");
				exit;
			}
		}

		if( ($price < $min and $min !=0) or ($price > $max and $max !=0) ){
			$telegram->sendMessage($userid,"کد تخفیف وارد شده برای این سفارش معتبر نمی باشد❌");
			exit;
		}

		if($amount <= 100) {
			$price = number_format( $price * (100-$amount)/100 );
			$amount = "$amount %";
		}else {
			$price = number_format( $price - $amount );
			$amount = number_format($amount)." تومان ";
		}
        $telegram->sendMessageCURL($userid,"کد تخفیف به مقدار $amount اعمال شد :",$finalop);
		file_put_contents("state/$userid.txt",'');
		
		if(preg_match('/submitRNdiscount/',$state)){
		    $token = base64_encode("$userid#$fid#$oid#$text");
			if($gateways['zibal']) $keyboard[] = [['text' => "پرداخت آنلاین - $price تومان", 'url' => baseURI."zibal.php?type=renew&action=pay&token=$token"]];
			if($gateways['novino']) $keyboard[] = [['text' => "پرداخت آنلاین - $price تومان", 'url' => baseURI."nvpayment.php?type=renew&action=pay&token=$token"]];
			if($gateways['payping']) $keyboard[] = [['text' => "پرداخت آنلاین2 - $price تومان", 'url' => baseURI."payping.php?type=renew&token=$token"]];
			if($gateways['bahamta']) $keyboard[] = [['text' => "پرداخت آنلاین - $price تومان", 'url' => baseURI."bahamta.php?type=renew&action=pay&token=$token"]];
            if($gateways['zarin']) $keyboard[] = [['text' => "پرداخت زرین پال - $price تومان", 'url' => baseURI."/renew/pay.php?token=$token"]];
            if($gateways['next']) $keyboard[] = [['text' => "پرداخت نکست پی - $price تومان", 'url' => baseURI."/renew/nextpay/pay.php?token=$token"]];
            if($gateways['card']) $keyboard[] = [['text' => "کارت به کارت - $price تومان",  'callback_data' => "offrnwpay#$fid#$oid#$text"]];
            if($gateways['wallet']) $keyboard[] = [['text' => '🏅 پرداخت با کیف پول', 'callback_data' => "walrnwpay#$fid#$oid#$text"]];
           $aa = bot('SendMessage', [
                'chat_id' => $userid,
                'parse_mode' => "HTML",
                'text' => "لطفا با یکی از روش های زیر اکانت خود را تمدید کنید :",
                'reply_markup' => json_encode([ 
                    'inline_keyboard' => $keyboard
                ]) 
            ]); 
		}else{
			if($price == 0 or ($userid == ADMIN or isAdmin() )){
				$keyboard = [[['text' => '📥 دریافت رایگان', 'callback_data' => "download#$fid#code"]]];
			}else{
				$token = base64_encode("{$userid}.{$fid}.{$text}");
				if($gateways['zibal']) $keyboard[] = [['text' => "پرداخت آنلاین - $price تومان", 'url' => baseURI."zibal.php?type=buy&action=pay&token=$token"]];
				if($gateways['novino']) $keyboard[] = [['text' => "پرداخت آنلاین - $price تومان", 'url' => baseURI."nvpayment.php?type=buy&action=pay&token=$token"]];
				if($gateways['payping']) $keyboard[] = [['text' => "پرداخت آنلاین2 - $price تومان", 'url' => baseURI."payping.php?type=buy&token=$token"]];
				if($gateways['bahamta']) $keyboard[] = [['text' => "پرداخت آنلاین - $price تومان", 'url' => baseURI."bahamta.php?type=buy&action=pay&token=$token"]];
				if($gateways['zarin']) $keyboard[] = [['text' => "پرداخت زرین پال - $price تومان", 'url' => baseURI."pay.php?token=$token"]];
				if($gateways['next']) $keyboard[] = [['text' => "پرداخت نکست پی - $price تومان", 'url' => baseURI."nextpay/pay.php?token=$token"]];
				if($gateways['card']) $keyboard[] = [['text' => "کارت به کارت - $price تومان",  'callback_data' => "offpay#$fid#$text"]];
				if($gateways['wallet']) $keyboard[] = [['text' => '🏅 پرداخت با کیف پول', 'callback_data' => "walpay#$fid#$text"]];
			}
			bot('SendMessage', [
            'chat_id' => $userid,
            'parse_mode' => "HTML",
			'text' => "🔻$name \n💰قیمت : $price تومان \n📃توضیحات : \n$desc \n$fileImg",
				'reply_markup' => json_encode([
					'inline_keyboard' => $keyboard
				])
			]);
		}
        

	   }else{
			$telegram->sendMessage($userid,"کد وارد شده اشتباه است❌");
	   }
	}
    
}
if(preg_match('/createForUs/',$cdata)) {
    file_put_contents("state/$userid.txt",$cdata);
    $telegram->sendHTML($userid,"لطفا آیدی عددی کاربر و تعداد اکانت را بصورت زیر وارد کنید:

1012656-1

مقدار اول ایدی عددی
مقدار دوم تعداد
",$cancelop);
    exit;
}

if(preg_match('/createForUs/',$state) and ($userid == ADMIN or isAdmin() ) and $text != '❌ انصراف'){
    $input = explode('-',$text);
    if(count($input) != 2){
        $telegram->sendMessage($userid,'لطفا فرمت صحیح و بصورت اعداد لاتین بفرستید');exit;
    }
    $uid = intval($input[0]);
    $ccount = intval($input[1]);
    $user = $telegram->db->query("select * from fl_user where userid=$uid")->fetch(2);
    if(!$user){
        $telegram->sendMessage($userid,'کاربر مورد نظر یافت نشد');
        exit;
    }
	if(!$ccount){
		$telegram->sendMessage($userid,'لطفا یک مقدار عددی صحیح و لاتین وارد کنید');
        exit;
	}
    file_put_contents("state/$userid.txt",'');
    $id = str_replace('createForUs#','',$state);
    $cdata = "down2load#$id#$uid#$ccount";
    $telegram->sendMessageCURL($userid,'✅کانفیگ با موفقیت برای کاربر ارسال شد', $finalop);
}
if(preg_match('/offpay/',$cdata) and !preg_match('/offpay/',$state)) {
    file_put_contents("state/$userid.txt",$cdata);
    $telegram->sendHTML($userid,"لطفا تصویر فیش واریزی یا شماره پیگیری -  ساعت پرداخت - نام پرداخت کننده را در یک پیام ارسال کنید
🔸$cardinfo",$cancelop);
    exit;
}
if(preg_match('/offpay/',$state) and $text != '❌ انصراف' and !$cdata){
	bot('deleteMessage', ['chat_id' => $userid,'message_id' => $msgid -1]);
	if(!isset($result->message->photo)){
	    $telegram->sendMessage($userid, "⚠️لطفا فیش واریزی را فقط بصورت عکس ارسال کنید");exit;
	}
    $input = explode('#',$state);
    $fid = $input[1];
	$dcode = $input[2];
    file_put_contents("state/$userid.txt",'');
    $res = $telegram->db->query("select * from fl_user where userid=$userid")->fetch(2);
    $uid = $res['userid'];
    $name = $res['name'];
    $tel = $res['tel'];
    $username = $res['username'];

    $res = $telegram->db->query("select * from fl_file where id=$fid")->fetch(2);
    $catname = $telegram->db->query("select * from fl_cat where id=".$res['catid'])->fetch(2)['title'];
    $filename = $catname." ".$res['title']; 
	$fileprice = $res['price'];
	$server_id = $res['server_id'];
	
	$sres = $telegram->db->query("select * from fl_server WHERE id='$server_id'")->fetch(2);
	$stitle = $sres['title'];
	$flag = $sres['flag'];
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
    if(!empty($seller)) $fileprice = $fileprice - (($fileprice) * ($seller['percent'] / 100));

	if($dcode){
        $dcount = $telegram->db->query("select * from fl_discount WHERE code='$dcode' and active=1 and count > 0 ");
        if($dcount->rowCount() > 0){
            $dres = $dcount->fetch(2);
            $amount = $dres['amount'];
            if($amount <= 100) {
                $fileprice = $fileprice * (100-$amount)/100;
            }else {
                $fileprice = $fileprice - $amount ;
            }
            if($dres['count'] != '') $telegram->db->query("update fl_discount set count= count - 1 WHERE code='$dcode'");
        }
    }

    $fileurl = $telegram->FileURL($fileid);
    $infoc = strlen($text) > 1 ? $text : "$caption (فیش واریزی در بالای این پیام هست)";
    $msg = "
✅✅درخواست شما با موفقیت ارسال شد
بعد از بررسی و تایید فیش, اطلاعات اکانت از طریق ربات برای شما ارسال می شود.
/start";
    $telegram->sendMessageCURL($userid,$msg,$finalop);
    // notify admin
    $msg = "
🏷سفارش جدید خرید $filename ($fileprice تومان)
🌐 $stitle $flag
✖کد کاربری : $userid
👤نام و نام خانوادگی : $name
📧یوزرنیم : @$username
☎️شماره موبایل : $tel
📝اطلاعات پرداخت کارت به کارت: $infoc
.";
    $keyboard = json_encode([
        'inline_keyboard' => [
            [
                ['text' => 'تایید پرداخت', 'callback_data' => $dcode ? "enable#$uid#$fid#$dcode" :  "enable#$uid#$fid" ],
                ['text' => 'عدم تایید', 'callback_data' => "disable#$uid"]
            ],
            [
                ['text' => 'ارسال دستی', 'callback_data' => $dcode ? "enmanuable#$uid#$fid#$dcode" :  "enmanuable#$uid#$fid" ],
            ]
        ]
    ]);
    $admins = file_get_contents('admins.php');
    $list = explode(PHP_EOL,$admins);
    foreach($list as $admid){
        if(strlen($admid) > 3){
			if($fileid) bot('sendphoto',['chat_id' => $admid, 'caption'=> $caption,'photo' => $fileid]);
            bot('sendmessage',[
                'chat_id' => $admid,
                'text'=> $msg,
                'parse_mode' => 'HTML',
                'reply_markup' => $keyboard
            ]);
        }
    }
	if($fileid) bot('sendphoto',['chat_id' => ADMIN, 'caption'=> '','photo' => $fileid]);
    bot('sendmessage',[
        'chat_id' => ADMIN,
        'text'=> $msg,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}
if(preg_match('/enmanuable/',$cdata)){
    file_put_contents("state/{$userid}.txt","$cdata#$cmsgid");
    $telegram->sendMessageCURL($userid,'لطفا لینک مورد نظر را بفرستید:',$cancelop);
}
if(preg_match('/enmanuable/',$state) and $text != '❌ انصراف'){
    file_put_contents("state/{$userid}.txt","");
    $input = explode('#',$state);
    $uid = $input[1];
    $fid = $input[2];
    
    if(isset($input[3])) $cmsgid = $input[3]; else $cmsgid = $input[2];
    
    
    preg_match('/(vless|vmess|trojan):\/\/.+/', $text, $matches);

    $text = $matches[0];
	
    if(!preg_match("/^(vless|vmess|trojan|ss):\/\/\w+/",$text)){
        $telegram->sendMessage($userid, "⚠️لطفا یک لینک کانفیگ صحیح ارسال کنید");
        exit;
    }
    //$telegram->sendMessage($userid,"22 $text");
    if(preg_match('/vmess:\/\//',$text)){
        $link_info = json_decode(base64_decode(str_replace('vmess://','',$text)));
        $uuid = $link_info->id;
        $panel_url = $link_info->add;
        $port = $link_info->port;
        $remark = $link_info->ps;
        $protocol = 'vmess';
        $netType = $link_info->net;
    }elseif(preg_match('/^ss:\/\//',$text)){
	    $link_info = str_replace("ss://",'',$text);
	    
	    $link_info = explode("#",$link_info);
	    $remark = $link_info[1];
	    $link_info = base64_decode($link_info[0]); 
	    $link_info = explode('@',$link_info);
	    
	    $uniqid = explode(':',$link_info[0])[1];
	    $link_info = $link_info[1];
	    $link_info = explode(':',$link_info);
	    $panel_url =$link_info[0];
		$port = $link_info[1];
		$netType = '';
		$protocol = 'shadowsocks';
	}else{
        $link = urldecode($text);
        $link_info = parse_url($link);
        $panel_ip = $link_info['host'];
        $uuid = $link_info['user'];
        $remark = $link_info['fragment'];
        $protocol = $link_info['scheme'];
        $port = $link_info['port'];
        $netType = explode('type=',$link_info['query'])[1];
        $netType = explode('&',$netType)[0];

    }
    $vray_link = $text;

    $file_detail = $telegram->db->query("select * from fl_file WHERE id=$fid")->fetch(2);
    $days = $file_detail['days'];
    $date = time();
    //$expire_microdate = intval(floor(microtime(true) * 1000) + (864000 * $days * 100));
	$expire_microdate = -abs(86400000 * $days);
    $expire_date = $date + (86400 * $days);
    $type = $file_detail['type'];
    $volume = $file_detail['volume'];
    $protocol = $file_detail['protocol'];
    $price = $file_detail['price'];
	
	if($dcode){
        $dcount = $telegram->db->query("select * from fl_discount WHERE code='$dcode' and active=1 and count > 0 ");
        if($dcount->rowCount() > 0){
            $dres = $dcount->fetch(2);
            $amount = $dres['amount'];
            if($amount <= 100) {
                $price = $price * (100-$amount)/100;
            }else {
                $price = $price - $amount ;
            }
			if($dres['count'] != '') $telegram->db->query("update fl_discount set count= count - 1 WHERE code='$dcode'");
        }
    }
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$uid")->fetch(2);
    if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
	
    $server_id = $file_detail['server_id'];
    $netType = $file_detail['type'];
    $acount = $file_detail['acount'];
    $inbound_id = $file_detail['inbound_id'];
    $limitip = intval($file_detail['limitip']);

    if($inbound_id == 0) {
        $server_info = $telegram->db->query("SELECT * FROM fl_server WHERE id=$server_id")->fetch(2);
        $telegram->db->query("UPDATE `fl_server` SET `ucount` = ucount - 1 WHERE id=$server_id");
    }else{
        if($acount != 0) $telegram->db->query("UPDATE `fl_file` SET `acount` = acount - 1 WHERE id=$fid");
    }

    $acc_text = "🔗 <code>$vray_link</code>" . " \n  برای کپی کردن لینک روی آن کلیک کنید \n";
    
    include 'phpqrcode/qrlib.php';
    $path = 'images/';
    $file = $path.$userid.rand(0,999999).time().".png"; //unlink($file);
    $ecc = 'L';
    $pixel_Size = 10;
    $frame_Size = 5;
    QRcode::png($vray_link, $file, $ecc, $pixel_Size, $frame_Size);
	
	$acc_text = "اطلاعات اکانت برای سفارش با کارت به کارت به شرح زیر است :
$acc_text";
	$telegram->sendPhoto($uid,$acc_text,$file);
    $telegram->sendMessageCURL($userid,'اطلاعات اکانت با موفقیت برای کاربر ارسال شد',$finalop);

    //$telegram->db->query("insert into fl_accounts values (null, $id, )");
	$order = $telegram->db->query("INSERT INTO `fl_order` VALUES (NULL,  {$uid}, 'card-manual', {$fid}, $server_id, $inbound_id, '$remark', '$protocol', '$expire_date', '$vray_link', $price,1, '$date', 0);");
    
    // update button
	bot('editMessageReplyMarkup',[
		'chat_id' => $userid,
		'message_id' => $cmsgid,
		'reply_markup' => json_encode([
			'inline_keyboard' => [[['text' => '✅دستی ارسال شد', 'callback_data' => "dontsendanymore"]]],
		])
	]);
    
    $filename = $file_detail['title'];
    $fileprice = $file_detail['price'];
	if($dcode){
        $dcount = $telegram->db->query("select * from fl_discount WHERE code='$dcode' and active=1 and count > 0 ");
        if($dcount->rowCount() > 0){
            $dres = $dcount->fetch(2);
            $amount = $dres['amount'];
            if($amount <= 100) {
                $fileprice = $fileprice * (100-$amount)/100;
            }else {
                $fileprice = $fileprice - $amount ;
            }
			if($dres['count'] != '') $telegram->db->query("update fl_discount set count= count - 1 WHERE code='$dcode'");
        }
    }
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$uid")->fetch(2);
    if(!empty($seller)) $fileprice = $fileprice - (($fileprice) * ($seller['percent'] / 100));
	
    $user_detail = $telegram->db->query("select * from fl_user WHERE userid=$uid")->fetch(2);
    $uname = $user_detail['name'];
    $user_name = $user_detail['username'];
    $tel = $user_detail['tel'];
    $admins = file_get_contents('admins.php');
    $list = explode(PHP_EOL,$admins);
    foreach($list as $admid){
        if(strlen($admid) > 3 and $admid != $userid){
           $telegram->sendMessage($admid,"✅سفارش کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$remark
🏷سفارش جدید خرید $filename ($fileprice تومان)
✖کد کاربری: $uid
👤نام و نام خانوادگی: $uname
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
");
        }
    }
    if(ADMIN != $userid) $telegram->sendMessage(ADMIN,"✅سفارش کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$remark
🏷سفارش جدید خرید $filename ($fileprice تومان)
✖کد کاربری: $uid
👤نام و نام خانوادگی: $uname
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
");

// pay referer
    $userReferer = $telegram->db->query("select * from fl_subuser where userid=$uid");
    if($userReferer->rowCount() ){
        $ures = $userReferer->fetch(2);
        $userToplevel = $ures['toplevel_userid'];
        $ufname = $ures['fname'];
        $amount = $pursant > 100 ? $pursant : ($fileprice) * ($pursant / 100);
        $telegram->db->query("update fl_user set wallet= wallet + $amount WHERE userid=$userToplevel");
		if($pursant > 100) $msg = "💟کاربر {$ufname} یک خرید به مبلغ  $price تومان انجام داد و $amount تومان به عنوان هدیه به کیف پول شما اضافه شد👍";
		else $msg = "💟کاربر {$ufname} یک خرید به مبلغ  $price تومان انجام داد و $pursant درصد آن یعنی $amount تومان به کیف پول شما اضافه شد👍";
        $telegram->sendMessage($userToplevel, $msg); 
    }
    
    
}
if(preg_match('/enable/',$cdata) and $text != '❌ انصراف'){
    file_put_contents("state/{$userid}.txt","");
    $input = explode('#',$cdata);
    $uid = $input[1];
    $fid = $input[2];
    $acctxt = '';
    
    
    $file_detail = $telegram->db->query("select * from fl_file WHERE id=$fid")->fetch(2);
    $days = $file_detail['days'];
    $date = time();
    //$expire_microdate = intval(floor(microtime(true) * 1000) + (864000 * $days * 100));
	$expire_microdate = -abs(86400000 * $days);
    $expire_date = $date + (86400 * $days);
    $type = $file_detail['type'];
    $volume = $file_detail['volume'];
    $protocol = $file_detail['protocol'];
    $price = $file_detail['price'];
	
	if($dcode){
        $dcount = $telegram->db->query("select * from fl_discount WHERE code='$dcode' and active=1 and count > 0 ");
        if($dcount->rowCount() > 0){
            $dres = $dcount->fetch(2);
            $amount = $dres['amount'];
            if($amount <= 100) {
                $price = $price * (100-$amount)/100;
            }else {
                $price = $price - $amount ;
            }
			if($dres['count'] != '') $telegram->db->query("update fl_discount set count= count - 1 WHERE code='$dcode'");
        }
    }
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$uid")->fetch(2);
    if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
	
    $server_id = $file_detail['server_id'];
    $netType = $file_detail['type'];
    $acount = $file_detail['acount'];
    $inbound_id = $file_detail['inbound_id'];
    $limitip = intval($file_detail['limitip']);


    
    if($acount == 0 and $inbound_id != 0){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => 'ظرفیت این کانکشن پر شده است',
            'show_alert' => false
        ]);
        exit;
    }
    if($inbound_id == 0) {
        $server_info = $telegram->db->query("SELECT * FROM fl_server WHERE id=$server_id")->fetch(2);
        if($server_info['ucount'] != 0) {
            $telegram->db->query("UPDATE `fl_server` SET `ucount` = ucount - 1 WHERE id=$server_id");
        } else {
            bot('answercallbackquery', [
                'callback_query_id' => $cid,
                'text' => 'ظرفیت این سرور پر شده است',
                'show_alert' => false
            ]);
            exit;
        }
    }else{
        if($acount != 0) 
            $telegram->db->query("UPDATE `fl_file` SET `acount` = acount - 1 WHERE id=$fid");
    }

    // V2ray Api
    require_once('vray.php');
    $uniqid = generateRandomString(42,$protocol); 

    $savedinfo = file_get_contents('savedinfo.txt');
    $savedinfo = explode('-',$savedinfo);
    $port = $savedinfo[0] + 1;
    $last_num = $savedinfo[1] + 1;

    $srv_remark = $telegram->db->query("select * from fl_server WHERE id=$server_id")->fetch(2)['remark'];
    $uremark = $telegram->db->query("select * from fl_remark where userid='$uid'")->fetch(2);
    if($uremark) $uremark = $uremark['remark']; else $uremark = $srv_remark;
    $remark = "{$uremark}-{$last_num}";

    file_put_contents('savedinfo.txt',$port.'-'.$last_num);
    //$telegram->sendMessage($cuserid,"$server_id, $uniqid, $inbound_id, $expire_microdate, $remark, $volume");exit;
    
    if($inbound_id == 0){    
        $response = add_inbound($server_id, $uniqid, $protocol, $port, $expire_microdate, $remark, $volume, $netType,'',$limitip); 
    }else {
        $response = add_inbount_client($server_id, $uniqid, $inbound_id, $expire_microdate, $remark, $volume, $limitip); 
    }
    
    if(is_null($response)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻اتصال به سرور برقرار نیست. لطفا به مدیریت اطلاع بدید',
            'show_alert' => true
        ]);
        exit;
    }
	if($response == "inbound not Found"){
		bot('answercallbackquery', [
			'callback_query_id' => $cid,
			'text' => "🔻سطر (inbound) با آیدی $inbound_id در این سرور یافت نشد یا کوکی منقضی شده. لطفا به مدیریت اطلاع بدید",
			'show_alert' => true
		]);
		exit;
	}
	if(!$response->success){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻خطا در ساخت کانفیگ. لطفا به مدیریت اطلاع بدید',
            'show_alert' => true
        ]);$telegram->sendMessage(ADMIN,"cardbuy = serverID: $server_id :".$response->msg);
        exit;
    }
	bot('answercallbackquery', [
        'callback_query_id' => $cid,
        'text' => '♻️در حال ارسال اکانت ...',
        'show_alert' => false
    ]);
    
    //$telegram->sendMessage($cuserid,json_encode($response));exit;
     
    $vray_link = genLink($server_id, $uniqid, $protocol, $remark, $port, $netType, $inbound_id);
    
    $addsub = "";
    if($gateways['sublink'] == 1){
    	$subid = getsubid($server_id, $inbound_id, $remark);
    	if($subid != '' and !is_null($subid) and $subid != '0'){
    		$server_detail = $telegram->db->query("SELECT * FROM server_info WHERE id=$server_id")->fetch(2);
    		$pnlurl = $server_detail['sublink'];
    		$sublink = $pnlurl."/sub/$subid";
    		$addsub = "\n\n (لینک سابسکریپشن با امکان نمایش حجم و تاریخ انقضا و بروز رسانی لینک ) \n $sublink \n";
    	}
    }
    $acc_text = "🔗 $remark \n <code>$vray_link</code> $addsub" . " \n  برای کپی کردن لینک روی آن کلیک کنید \n";
    
    include 'phpqrcode/qrlib.php';
    $path = 'images/';
    $file = $path.$userid.rand(0,999999).time().".png"; //unlink($file);
    $ecc = 'L';
    $pixel_Size = 10;
    $frame_Size = 5;
    QRcode::png($vray_link, $file, $ecc, $pixel_Size, $frame_Size);
	
	$acc_text = "اطلاعات اکانت برای سفارش با کارت به کارت به شرح زیر است :
$acc_text";
	$telegram->sendPhoto($uid,$acc_text,$file);
    $telegram->sendMessageCURL($userid,'اطلاعات اکانت با موفقیت برای کاربر ارسال شد',$finalop);

    //$telegram->db->query("insert into fl_accounts values (null, $id, )");
	$order = $telegram->db->query("INSERT INTO `fl_order` VALUES (NULL,  {$uid}, 'card', {$fid}, $server_id, $inbound_id, '$remark', '$protocol', $expire_date, '$vray_link', $price,1, '$date', 0);");
    
    // update button
    bot('editMessageReplyMarkup',[
		'chat_id' => $userid,
		'message_id' => $cmsgid,
		'reply_markup' => json_encode([
            'inline_keyboard' => [[['text' => '✅ارسال شد', 'callback_data' => "dontsendanymore"]]],
        ])
    ]);
    
    $filename = $file_detail['title'];
    $fileprice = $file_detail['price'];
	if($dcode){
        $dcount = $telegram->db->query("select * from fl_discount WHERE code='$dcode' and active=1 and count > 0 ");
        if($dcount->rowCount() > 0){
            $dres = $dcount->fetch(2);
            $amount = $dres['amount'];
            if($amount <= 100) {
                $fileprice = $fileprice * (100-$amount)/100;
            }else {
                $fileprice = $fileprice - $amount ;
            }
			if($dres['count'] != '') $telegram->db->query("update fl_discount set count= count - 1 WHERE code='$dcode'");
        }
    }
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$uid")->fetch(2);
    if(!empty($seller)) $fileprice = $fileprice - (($fileprice) * ($seller['percent'] / 100));
	
    $user_detail = $telegram->db->query("select * from fl_user WHERE userid=$uid")->fetch(2);
    $uname = $user_detail['name'];
    $user_name = $user_detail['username'];
    $tel = $user_detail['tel'];
    $admins = file_get_contents('admins.php');
    $list = explode(PHP_EOL,$admins);
    foreach($list as $admid){
        if(strlen($admid) > 3 and $admid != $userid){
           $telegram->sendMessage($admid,"✅سفارش کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$remark
🏷سفارش جدید خرید $filename ($fileprice تومان)
✖کد کاربری: $uid
👤نام و نام خانوادگی: $uname
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
");
        }
    }
    if(ADMIN != $userid) $telegram->sendMessage(ADMIN,"✅سفارش کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$remark
🏷سفارش جدید خرید $filename ($fileprice تومان)
✖کد کاربری: $uid
👤نام و نام خانوادگی: $uname
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
");

// pay referer
    $userReferer = $telegram->db->query("select * from fl_subuser where userid=$uid");
    if($userReferer->rowCount() ){
        $ures = $userReferer->fetch(2);
        $userToplevel = $ures['toplevel_userid'];
        $ufname = $ures['fname'];
        $amount = $pursant > 100 ? $pursant : ($fileprice) * ($pursant / 100);
        $telegram->db->query("update fl_user set wallet= wallet + $amount WHERE userid=$userToplevel");
		if($pursant > 100) $msg = "💟کاربر {$ufname} یک خرید به مبلغ  $fileprice تومان انجام داد و $amount تومان به عنوان هدیه به کیف پول شما اضافه شد👍";
		else $msg = "💟کاربر {$ufname} یک خرید به مبلغ  $fileprice تومان انجام داد و $pursant درصد آن یعنی $amount تومان به کیف پول شما اضافه شد👍";
        $telegram->sendMessage($userToplevel, $msg); 
    }
    
    
}
if(preg_match('/disable/',$cdata) and ($userid==ADMIN or isAdmin()) ){
    file_put_contents("state/{$userid}.txt","$cdata#$cmsgid");
    $telegram->sendMessageCURL($userid,'لطفا دلیل عدم تایید تراکنش را وارد کنید (این متن برای مشتری ارسال می شود) ',$cancelop);
}
if(preg_match('/disable/',$state) and $text != '❌ انصراف'){
    file_put_contents("state/{$userid}.txt","");
    $input = explode('#',$state);
    $uid = $input[1];
    $data = $input[2];
	if(isset($input[3])) $cmsgid = $input[3]; else $cmsgid = $input[2];
    // update button
	bot('editMessageReplyMarkup',[
		'chat_id' => $userid,
		'message_id' => $cmsgid,
		'reply_markup' => json_encode([
			'inline_keyboard' => [[['text' => '❌ رد شد', 'callback_data' => "dontsendanymore"]]],
		])
	]);
    $telegram->sendMessageCURL($userid,'متن پیام با موفقیت برای مشتری ارسال شد',$finalop);
    $telegram->sendMessage($uid,$text);
    
  if(preg_match("/wallet/",$data)){
    $amount = str_replace('wallet','',$data);
    $user_detail = $telegram->db->query("select * from fl_user WHERE userid=$uid")->fetch(2);
    $uname = $user_detail['name'];
    $user_name = $user_detail['username'];
    $tel = $user_detail['tel'];
    $admins = file_get_contents('admins.php');
    $list = explode(PHP_EOL,$admins);
    foreach($list as $admid){
        if(strlen($admid) > 3 and $admid != $userid){
           $telegram->sendMessage($admid,"❌ سفارش افزایش موجودی با کارت به کارت زیر توسط یکی از همکاران رد شد. لطفا از تایید یا رد آن خودداری کنید
#$$amount_$uid           
🏷افزایش موجودی کاربر $uname
✖کد کاربری: $uid
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
مبلغ درخواستی: $amount تومان
");
        }
    }
    if(ADMIN != $userid) $telegram->sendMessage(ADMIN,"❌ سفارش افزایش موجودی با کارت به کارت زیر توسط یکی از همکاران رد شد. لطفا از تایید یا رد آن خودداری کنید
#$amount_$uid 
🏷افزایش موجودی کاربر $uname
✖کد کاربری: $uid
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
مبلغ درخواستی: $amount تومان
");
  }else{
	  if(is_null($input[2])) {
        $filname = ''; $fileprice ='Null';
    }else{
        $file_detail = $telegram->db->query("select * from fl_file WHERE id=$data")->fetch(2);
		$filename = $file_detail['title'];
		$fileprice = number_format($file_detail['price']);
    }
    $user_detail = $telegram->db->query("select * from fl_user WHERE userid=$uid")->fetch(2);
    $uname = $user_detail['name'];
    $user_name = $user_detail['username'];
    $tel = $user_detail['tel'];
    $admins = file_get_contents('admins.php');
    $list = explode(PHP_EOL,$admins);
    foreach($list as $admid){
        if(strlen($admid) > 3 and $admid != $userid){
           $telegram->sendMessage($admid,"❌سفارش کارت به کارت زیر توسط یکی از همکاران رد شد. لطفا از تایید یا رد آن خودداری کنید
#$uid
🏷سفارش جدید خرید $filename ($fileprice تومان)
✖کد کاربری: $uid
👤نام و نام خانوادگی: $uname
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
");
        }
    }
    if(ADMIN != $userid) $telegram->sendMessage(ADMIN,"❌سفارش کارت به کارت زیر توسط یکی از همکاران رد شد. لطفا از تایید یا رد آن خودداری کنید
#$uid
🏷سفارش جدید خرید $filename ($fileprice تومان)
✖کد کاربری: $uid
👤نام و نام خانوادگی: $uname
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
");
    }
}
if(preg_match('/walpay/',$cdata)) {
    $input = explode('#', $cdata);
    $id = $input[1];
    $dcode = $input[2];
    $file_detail = $telegram->db->query("select * from fl_file WHERE id=$id")->fetch(2);
    $days = $file_detail['days'];
    $date = time();
    //$expire_microdate = intval(floor(microtime(true) * 1000) + (864000 * $days * 100));
	$expire_microdate = -abs(86400000 * $days);
    $expire_date = $date + (86400 * $days);
    $type = $file_detail['type'];
    $volume = $file_detail['volume'];
    $protocol = $file_detail['protocol'];
    $price = $file_detail['price'];
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
    if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
	
    $server_id = $file_detail['server_id'];
    $netType = $file_detail['type'];
    $acount = $file_detail['acount'];
    $inbound_id = $file_detail['inbound_id'];
    $limitip = intval($file_detail['limitip']);


    if($dcode){
        $dcount = $telegram->db->query("select * from fl_discount WHERE code='$dcode' and active=1 and count > 0 ");
        if($dcount->rowCount() > 0){
            $dres = $dcount->fetch(2);
            $amount = $dres['amount'];
            if($amount <= 100) {
                $price = $price * (100-$amount)/100;
            }else {
                $price = $price - $amount ;
            }
            if($dres['count'] != '') $telegram->db->query("update fl_discount set count= count - 1 WHERE code='$dcode'");
        }
    }
    
    $userwallet = $telegram->db->query("select wallet from fl_user WHERE userid='$userid'")->fetch(2)['wallet'];
    
    if($userwallet < $price) {
        $needamount = $price - $userwallet;
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "💡موجودی کیف پول (".number_format($userwallet)." تومان) کافی نیست لطفا به مقدار ".number_format($needamount)." تومان شارژ کنید ",
            'show_alert' => true
        ]);
        exit;
    }
    
    if($acount == 0 and $inbound_id != 0){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => 'ظرفیت این کانکشن پر شده است',
            'show_alert' => false
        ]);
        exit;
    }
    if($inbound_id == 0) {
        $server_info = $telegram->db->query("SELECT * FROM fl_server WHERE id=$server_id")->fetch(2);
        if($server_info['ucount'] != 0) {
            $telegram->db->query("UPDATE `fl_server` SET `ucount` = ucount - 1 WHERE id=$server_id");
        } else {
            bot('answercallbackquery', [
                'callback_query_id' => $cid,
                'text' => 'ظرفیت این سرور پر شده است',
                'show_alert' => false
            ]);
            exit;
        }
    }else{
        if($acount != 0) 
            $telegram->db->query("UPDATE `fl_file` SET `acount` = acount - 1 WHERE id=$id");
    }
    

    // V2ray Api
    require_once('vray.php');
    $uniqid = generateRandomString(42,$protocol); 

    $savedinfo = file_get_contents('savedinfo.txt');
    $savedinfo = explode('-',$savedinfo);
    $port = $savedinfo[0] + 1;
    $last_num = $savedinfo[1] + 1;

    $srv_remark = $telegram->db->query("select * from fl_server WHERE id=$server_id")->fetch(2)['remark'];
    $uremark = $telegram->db->query("select * from fl_remark where userid='$userid'")->fetch(2);
    if($uremark) $uremark = $uremark['remark']; else $uremark = $srv_remark;
    $remark = "{$uremark}-{$last_num}";

    file_put_contents('savedinfo.txt',$port.'-'.$last_num);
    //$telegram->sendMessage($cuserid,"$server_id, $uniqid, $inbound_id, $expire_microdate, $remark, $volume");exit;
    
    if($inbound_id == 0){    
        $response = add_inbound($server_id, $uniqid, $protocol, $port, $expire_microdate, $remark, $volume, $netType,'',$limitip); 
    }else {
        $response = add_inbount_client($server_id, $uniqid, $inbound_id, $expire_microdate, $remark, $volume, $limitip); 
    }
    if(is_null($response)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻اتصال به سرور برقرار نیست. لطفا به مدیریت اطلاع بدید',
            'show_alert' => true
        ]);
        exit;
    }
	if($response == "inbound not Found"){
		bot('answercallbackquery', [
			'callback_query_id' => $cid,
			'text' => "🔻سطر (inbound) با آیدی $inbound_id در این سرور یافت نشد یا کوکی منقضی شده. لطفا به مدیریت اطلاع بدید",
			'show_alert' => true
		]);
		exit;
	}
	if(!$response->success){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻خطا در ساخت کانفیگ. لطفا به مدیریت اطلاع بدید',
            'show_alert' => true
        ]);$telegram->sendMessage(ADMIN,"walletbuy = serverID: $server_id :".$response->msg);
        exit;
    }
	bot('answercallbackquery', [
        'callback_query_id' => $cid,
        'text' => '♻️در حال ارسال اکانت ...',
        'show_alert' => false
    ]);
    //$telegram->sendMessage($cuserid,json_encode($response));exit;
     
    $vray_link = genLink($server_id, $uniqid, $protocol, $remark, $port, $netType, $inbound_id);
    
    $addsub = "";
    if($gateways['sublink'] == 1){
    	$subid = getsubid($server_id, $inbound_id, $remark);
    	if($subid != '' and !is_null($subid) and $subid != '0'){
    		$server_detail = $telegram->db->query("SELECT * FROM server_info WHERE id=$server_id")->fetch(2);
    		$pnlurl = $server_detail['sublink'];
    		$sublink = $pnlurl."/sub/$subid";
    		$addsub = "\n\n (لینک سابسکریپشن با امکان نمایش حجم و تاریخ انقضا و بروز رسانی لینک ) \n $sublink \n";
    	}
    }
    $acc_text = "🔗 $remark \n <code>$vray_link</code> $addsub" . " \n  برای کپی کردن لینک روی آن کلیک کنید \n";

    include 'phpqrcode/qrlib.php';
    $path = 'images/';
    $file = $path.$userid.rand(0,999999).time().".png"; //unlink($file);
    $ecc = 'L';
    $pixel_Size = 10;
    $frame_Size = 5;
    QRcode::png($vray_link, $file, $ecc, $pixel_Size, $frame_Size);
	
    //$fileLink = "<a href='".baseURI.$file."'>&#8194;</a>";
	//$telegram->sendHTML($cuserid,$acc_text.$fileLink,$finalop);
	$telegram->sendPhoto($cuserid,$acc_text,$file);

    //$telegram->db->query("insert into fl_accounts values (null, $id, )");
	$order = $telegram->db->query("INSERT INTO `fl_order` VALUES (NULL,  {$userid}, 'wallet', {$id}, $server_id, $inbound_id, '$remark', '$protocol', $expire_date, '$vray_link', $price,1, '$date', 0);");
    $telegram->db->query("update fl_user set wallet = wallet - $price WHERE userid='$userid'");
    
    // pay referer
    $userReferer = $telegram->db->query("select * from fl_subuser where userid=$userid");
    if($userReferer->rowCount() ){
        $ures = $userReferer->fetch(2);
        $userToplevel = $ures['toplevel_userid'];
        $ufname = $ures['fname'];
        $amount = $pursant > 100 ? $pursant : ($price) * ($pursant / 100);
        $telegram->db->query("update fl_user set wallet= wallet + $amount WHERE userid=$userToplevel");
		if($pursant > 100) $msg = "💟کاربر {$ufname} یک خرید به مبلغ  $price تومان انجام داد و $amount تومان به عنوان هدیه به کیف پول شما اضافه شد👍";
		else $msg = "💟کاربر {$ufname} یک خرید به مبلغ  $price تومان انجام داد و $pursant درصد آن یعنی $amount تومان به کیف پول شما اضافه شد👍";
        $telegram->sendMessage($userToplevel, $msg); 
    }
    
    // update button
    bot('editMessageReplyMarkup',[
		'chat_id' => $userid,
		'message_id' => $cmsgid,
		'reply_markup' => json_encode([
            'inline_keyboard' => [[['text' => '✅ارسال شد', 'callback_data' => "dontsendanymore"]]],
        ])
    ]);
$sndmsg = "
خرید با کیف پول 
قیمت : $price
آیدی کاربر : $userid
آیدی سرور : $server_id
لینک دریافتی :

$vray_link
";
    $telegram->sendMessage($sendchnl,$sndmsg);
}
if(preg_match('/down2load/',$cdata)) {
    $input = explode('#', $cdata);
    $id = $input[1];
    $ccount = 1;
	$uid = $userid;
    
    if(count($input) == 4){
        $uid = $input[2];
        $ccount = $input[3];
    }
	include 'phpqrcode/qrlib.php';
	$path = 'images/';
    $file = $path.$uid.rand(0,9999999).".png"; //unlink($file);
    $ecc = 'L';
    $pixel_Size = 10;
    $frame_Size = 5;
    for($i=0;$i<$ccount; $i++){
        $file_detail = $telegram->db->query("select * from fl_file WHERE id=$id")->fetch(2);
        $days = $file_detail['days'];
        $date = time();
        //$expire_microdate = floor(microtime(true) * 1000) + (864000 * $days * 100);
		$expire_microdate = -abs(86400000 * $days);
        $expire_date = $date + (86400 * $days);
        $type = $file_detail['type'];
        $volume = $file_detail['volume'];
        $protocol = $file_detail['protocol'];
        $price = $file_detail['price'];
        $server_id = $file_detail['server_id'];
        $acount = $file_detail['acount'];
        $inbound_id = $file_detail['inbound_id'];
        $limitip = $file_detail['limitip'];
        $netType = $file_detail['type'];
        
        if($acount == 0 and $inbound_id != 0){
            bot('answercallbackquery', [
                'callback_query_id' => $cid,
                'text' => 'ظرفیت این کانکشن پر شده است',
                'show_alert' => false
            ]);
            exit;
        }
        if($inbound_id == 0) {
            $server_info = $telegram->db->query("SELECT * FROM fl_server WHERE id=$server_id")->fetch(2);
            if($server_info['ucount'] != 0) {
                $telegram->db->query("UPDATE `fl_server` SET `ucount` = ucount - 1 WHERE id=$server_id");
            } else {
                bot('answercallbackquery', [
                    'callback_query_id' => $cid,
                    'text' => 'ظرفیت این سرور پر شده است',
                    'show_alert' => false
                ]);
                exit;
            }
        }else{
            if($acount != 0) 
                $telegram->db->query("UPDATE `fl_file` SET `acount` = acount - 1 WHERE id=$id");
        }
        
        //$telegram->sendMessage($userid,$expire_microdate);exit;
        // V2ray Api
        require_once('vray.php');
        $uniqid = generateRandomString(42,$protocol); 
    
        $savedinfo = file_get_contents('savedinfo.txt');
        $savedinfo = explode('-',$savedinfo);
        $port = $savedinfo[0] + 1;
        $last_num = $savedinfo[1] + 1;
    
        $srv_remark = $telegram->db->query("select * from fl_server WHERE id=$server_id")->fetch(2)['remark'];
		$uremark = $telegram->db->query("select * from fl_remark where userid='$uid'")->fetch(2);
		if($uremark) $uremark = $uremark['remark']; else $uremark = $srv_remark;
		$remark = "{$uremark}-{$last_num}";
    
        file_put_contents('savedinfo.txt',$port.'-'.$last_num);
        //$telegram->sendMessage($cuserid,"$server_id, $uniqid, $inbound_id, $expire_microdate, $remark, $volume");exit;
        
        if($inbound_id == 0){    
            $response = add_inbound($server_id, $uniqid, $protocol, $port, $expire_microdate, $remark, $volume, $netType,'',$limitip); 
        }else {
            $response = add_inbount_client($server_id, $uniqid, $inbound_id, $expire_microdate, $remark, $volume, $limitip); 
        }
        if(is_null($response)){
            bot('answercallbackquery', [
                'callback_query_id' => $cid,
                'text' => '🔻اتصال به سرور برقرار نیست. لطفا به مدیریت اطلاع بدید',
                'show_alert' => true
            ]);
            exit;
        }
    	if(!$response->success){
            bot('answercallbackquery', [
                'callback_query_id' => $cid,
                'text' => '🔻خطا در ساخت کانفیگ. لطفا به مدیریت اطلاع بدید',
                'show_alert' => true
            ]);
            exit;
        }
    	bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '♻️در حال ارسال اکانت ...',
            'show_alert' => false
        ]);
        $vray_link = genLink($server_id, $uniqid, $protocol, $remark, $port, $netType, $inbound_id);
        
        $addsub = "";
		if($gateways['sublink'] == 1){
			$subid = getsubid($server_id, $inbound_id, $remark);
			if($subid != '' and !is_null($subid) and $subid != '0'){
				$server_detail = $telegram->db->query("SELECT * FROM server_info WHERE id=$server_id")->fetch(2);
				$pnlurl = $server_detail['sublink'];
				$sublink = $pnlurl."/sub/$subid";
				$addsub = "\n\n (لینک سابسکریپشن با امکان نمایش حجم و تاریخ انقضا و بروز رسانی لینک ) \n $sublink \n";
			}
		}
		$acc_text = "🔗 $remark \n <code>$vray_link</code> $addsub" . " \n  برای کپی کردن لینک روی آن کلیک کنید \n";
    
        QRcode::png($vray_link, $file, $ecc, $pixel_Size, $frame_Size);
		
		$telegram->sendPhoto($uid,$acc_text,$file);
    	
    
        //$telegram->db->query("insert into fl_accounts values (null, $id, )"); 
    	$order = $telegram->db->query("INSERT INTO `fl_order` VALUES (NULL,  {$uid}, 'free-create', {$id}, $server_id, $inbound_id, '$remark', '$protocol', $expire_date, '$vray_link', $price,1, '$date', 0);");
        
    	if(count($input) == 2) file_put_contents("state/{$uid}-free.txt","1");
    }
    
    
    // update button
    bot('editMessageReplyMarkup',[
		'chat_id' => $uid,
		'message_id' => $cmsgid,
		'reply_markup' => json_encode([
            'inline_keyboard' => [[['text' => '✅ارسال شد', 'callback_data' => "dontsendanymore"]]],
        ])
    ]);
}
if(preg_match('/download/',$cdata)) {
    $input = explode('#', $cdata);
    $id = $input[1];
    if(count($input) == 3) $code = $input[2];
	$ccount = 1;
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
	if(is_null($code)){
		$free = file_get_contents("state/{$userid}-free.txt");
		if($free == '1' and !($userid == ADMIN or isAdmin() ) and !$seller){
			bot('answercallbackquery', [
				'callback_query_id' => $cid,
				'text' => '⚠️شما قبلا هدیه رایگان خود را دریافت کردید',
				'show_alert' => false
			]); 
			exit;
		}
	}
	
	
    $file_detail = $telegram->db->query("select * from fl_file WHERE id=$id")->fetch(2);
    $days = $file_detail['days'];
    $date = time();
    //$expire_microdate = intval(floor(microtime(true) * 1000) + (864000 * $days * 100));
	$expire_microdate = -abs(86400000 * $days);
    $expire_date = $date + (86400 * $days);
    $type = $file_detail['type'];
    $volume = $file_detail['volume'];
    $protocol = $file_detail['protocol'];
    $price = $file_detail['price'];
    $server_id = $file_detail['server_id'];
    $acount = $file_detail['acount'];
    $inbound_id = $file_detail['inbound_id'];
    $limitip = intval($file_detail['limitip']);
    $netType = $file_detail['type'];
    
    if($acount == 0 and $inbound_id != 0){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => 'ظرفیت این کانکشن پر شده است',
            'show_alert' => false
        ]);
        exit;
    }
    if($inbound_id == 0) {
        $server_info = $telegram->db->query("SELECT * FROM fl_server WHERE id=$server_id")->fetch(2);
        if($server_info['ucount'] != 0) {
            $telegram->db->query("UPDATE `fl_server` SET `ucount` = ucount - 1 WHERE id=$server_id");
        } else {
            bot('answercallbackquery', [
                'callback_query_id' => $cid,
                'text' => 'ظرفیت این سرور پر شده است',
                'show_alert' => false
            ]);
            exit;
        }
    }else{
        if($acount != 0) 
            $telegram->db->query("UPDATE `fl_file` SET `acount` = acount - 1 WHERE id=$id");
    }

    // V2ray Api
    require_once('vray.php');
    $uniqid = generateRandomString(42,$protocol); 

    $savedinfo = file_get_contents('savedinfo.txt');
    $savedinfo = explode('-',$savedinfo);
    $port = $savedinfo[0] + 1;
    $last_num = $savedinfo[1] + 1;

    $srv_remark = $telegram->db->query("select * from fl_server WHERE id=$server_id")->fetch(2)['remark'];
    $uremark = $telegram->db->query("select * from fl_remark where userid='$userid'")->fetch(2);
    if($uremark) $uremark = $uremark['remark']; else $uremark = $srv_remark;
    $remark = "{$uremark}-{$last_num}";

    file_put_contents('savedinfo.txt',$port.'-'.$last_num);
    //$telegram->sendMessage($cuserid,"$server_id, $uniqid, $inbound_id, $expire_microdate, $remark, $volume");exit;
    
    if($inbound_id == 0){    
        $response = add_inbound($server_id, $uniqid, $protocol, $port, $expire_microdate, $remark, $volume, $netType,'',$limitip);  
    }else {
        $response = add_inbount_client($server_id, $uniqid, $inbound_id, $expire_microdate, $remark, $volume, $limitip);  
    }
    if(is_null($response)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻اتصال به سرور برقرار نیست. لطفا به مدیریت اطلاع بدید',
            'show_alert' => true
        ]);
        exit;
    }
	if($response == "inbound not Found"){
		bot('answercallbackquery', [
			'callback_query_id' => $cid,
			'text' => "🔻سطر (inbound) با آیدی $inbound_id در این سرور یافت نشد یا کوکی منقضی شده. لطفا به مدیریت اطلاع بدید",
			'show_alert' => true
		]);
		exit;
	}
	if(!$response->success){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻خطا در ساخت کانفیگ. لطفا به مدیریت اطلاع بدید',
            'show_alert' => true
        ]); $telegram->sendMessage(ADMIN,"free = serverID: $server_id :".$response->msg);
        exit;
    }
	bot('answercallbackquery', [
        'callback_query_id' => $cid,
        'text' => '♻️در حال ارسال اکانت ...',
        'show_alert' => false
    ]);
    $vray_link = genLink($server_id, $uniqid, $protocol, $remark, $port, $netType, $inbound_id);
    
    $addsub = "";
    if($gateways['sublink'] == 1){
    	$subid = getsubid($server_id, $inbound_id, $remark);
    	if($subid != '' and !is_null($subid) and $subid != '0'){
    		$server_detail = $telegram->db->query("SELECT * FROM server_info WHERE id=$server_id")->fetch(2);
    		$pnlurl = $server_detail['sublink'];
    		$sublink = $pnlurl."/sub/$subid";
    		$addsub = "\n\n (لینک سابسکریپشن با امکان نمایش حجم و تاریخ انقضا و بروز رسانی لینک ) \n $sublink \n";
    	}
    }
    $acc_text = "🔗 $remark \n <code>$vray_link</code> $addsub" . " \n  برای کپی کردن لینک روی آن کلیک کنید \n";
	
	include 'phpqrcode/qrlib.php';
    $path = 'images/';
    $file = $path.$userid.rand(0,999999).time().".png"; //unlink($file);
    $ecc = 'L';
    $pixel_Size = 10;
    $frame_Size = 5;
    QRcode::png($vray_link, $file, $ecc, $pixel_Size, $frame_Size);
	
    //$fileLink = "<a href='".baseURI.$file."'>&#8194;</a>";
	//$telegram->sendHTML($cuserid,$acc_text.$fileLink,$finalop);
	$telegram->sendPhoto($cuserid,$acc_text,$file);

    //$telegram->db->query("insert into fl_accounts values (null, $id, )"); 
	$order = $telegram->db->query("INSERT INTO `fl_order` VALUES (NULL,  {$userid}, 'free', {$id}, $server_id, $inbound_id, '$remark', '$protocol', $expire_date, '$vray_link', $price,1, '$date', 0);");
    
	file_put_contents("state/{$userid}-free.txt","1");
    
    // update button
    bot('editMessageReplyMarkup',[
		'chat_id' => $userid,
		'message_id' => $cmsgid,
		'reply_markup' => json_encode([
            'inline_keyboard' => [[['text' => '✅ارسال شد', 'callback_data' => "dontsendanymore"]]],
        ])
    ]);
}
if ($text == '➕ثبت پلن' and ($userid == ADMIN or isAdmin() )){
    $state = file_put_contents('state/'.$userid.'.txt','addproduct');
    $telegram->db->query("delete from fl_file WHERE active=0");
    $sql = "INSERT INTO `fl_file` VALUES (NULL, '', 0,0,0,0, 1, '', '', 0, 0, '', 0, '', '',0,1, '$time');";
    $telegram->db->query($sql);
    $msg = '◀️ لطفا عنوان پلن را وارد کنید';
    $telegram->sendMessageCURL($userid,$msg,$cancelop);
    exit;
}
// add product
if(preg_match('/addproduct/',$state) and $text!='❌ انصراف'){

    $catkey = [];
    $cats = $telegram->db->query("SELECT * FROM `fl_cat` WHERE parent =0 and active=1")->fetchAll(2);
    foreach ($cats as $cat){
        $id = $cat['id'];
        $name = $cat['title'];
        $catkey[] = ["$id - $name"];
    }
    $catkey[] = ['❌ انصراف'];
    
    $step = $telegram->checkStep('fl_file');
    if($step==1 and $text!='❌ انصراف'){
        $msg = '✅عنوان پلن با موفقیت ثبت شد
◀️ لطفا قیمت پلن را به تومان وارد کنید
* عدد 0 به معنای رایگان بودن است و در بخش تست رایگان قرار میگیرد و هر کاربر تلگرام فقط یکبار می تواند اکانت تست دریافت کند
';
        if(strlen($text)>1){
            $telegram->db->query("update fl_file set title='$text',step=2 where active=0 and step=1");
            $telegram->sendMessageCURL($userid,$msg,$cancelop);
        }
    } //step 1
    if($step==2 and $text!='❌ انصراف'){
        $msg = '✅قیمت پلن با موفقیت ثبت شد . 
◀️ لطفا دسته بندی پلن را انتخاب کنید
.';
        if(is_numeric($text)){
            $telegram->db->query("update fl_file set price='$text',step=3 where active=0");
            $telegram->sendMessageCURL($userid,$msg,$catkey);
        }else{
            $msg = '‼️ لطفا یک مقدار عددی وارد کنید';
            $telegram->sendMessageCURL($userid,$msg,$cancelop);
        }
    } //step 2
    if($step==3 and $text!='❌ انصراف'){
        
        $inarr = 0;
        foreach ($catkey as $op) {
            if (in_array($text, $op) and $text != '❌ انصراف') {
                $inarr = 1;
            }
        }
        if( $inarr==1 ){
            $input = explode(' - ',$text);
            $catid = $input[0];
            $telegram->db->query("update fl_file set catid='$catid',step=20 where active=0");
            $srvkey = [];
            $telegram->sendMessageCURL($userid,'✅دسته بندی پلن موفقیت ثبت شد. ',$cancelop);
            $srvs = $telegram->db->query("SELECT * FROM `fl_server` WHERE active=1")->fetchAll(2);
            foreach($srvs as $srv){
                $id = $srv['id'];
                $title = $srv['title'];
                $srvkey[] = ['text' => "$title", 'callback_data' => "slctsrv#$id"];
            }
            $srvkey = array_chunk($srvkey,2);
            bot('sendmessage', [
                'chat_id' => $userid,
                'parse_mode' => "HTML",
                'text' => "لطفا سرور را مشخص کنید :",
                'reply_markup' => json_encode([
                    'inline_keyboard' => $srvkey])
            ]);
        }else{
            $msg = '‼️ لطفا فقط یکی از گزینه های پیشنهادی زیر را انتخاب کنید';
            $telegram->sendMessageCURL($userid,$msg,$catkey);
        }
    } //step 3
    if($step==20 and $text!='❌ انصراف' and preg_match('/slctsrv/', $cdata)){
        $srvid = str_ireplace('slctsrv#','',$cdata);
        $msg = '✅سرور پلن موفقیت ثبت شد. 
◀️ لطفا مشخصات سرویس را به اینصورت وارد کنید :

اگر میخواهید کانکشن یا پورت اختصاصی برای هر مشتری ایجاد شود لطفا بصورت زیر وارد کنید◀️
<code>vmess-30-50-ws-1</code>

مقدار اول (vmess | vless | trojan | shadowsocks) پروتکل
مقدار دوم (30) تعداد روزهای اعتبار
مقدار سوم (50) حجم به گیگابایت
مقدار چهارم (ws | tcp) نوع
مقدار پنجم (1) چندکاربره (اگر 0 باشد نامحدود است)

هر پنج مقدار با - از هم جدا می شوند

=======================================
اگر سرور با قابلیت چند کلاینت روی پورت هست لطفا بصورت زیر وارد کنید◀️
<code>vmess-30-100-1-20-1</code>

مقدار اول (vmess | vless | trojan | shadowsocks) پروتکل
مقدار دوم (30) تعداد روزهای اعتبار
مقدار سوم (100) حجم به گیگابایت
مقدار چهارم (1) آیدی سطر کانکشن در پنل (inbound id)
مقدار پنجم (20) ظرفیت تعداد اکانت روی کانکشن یا همان پورت
مقدار ششم (1) چندکاربره (اگر 0 باشد نامحدود است)

نکته: برای حجم می توانید بصورت 0.5 بزنید یعنی 500 مگ
* برای دقیقه پسوند min و برای ساعت پسوند hr اضافه کنید. مثلا 45 دقیقه را 45min بزنید و 2ساعت را 2hr و برای روز هم که بدون پسوند بزنید مثلا 10روز را بزنید 10

.';
       $telegram->db->query("update fl_file set server_id=$srvid,step=21 where active=0");
        $telegram->sendHTML($userid,$msg,$cancelop);
    } //step 20
    if($step==21 and $text!='❌ انصراف'){
        $input = explode('-',$text);
        $protocol = $input[0];
		if(!in_array($protocol,['vmess','vless','trojan','shadowsocks'])){
			$telegram->sendMessage($userid,"مقدار وارد شده ($protocol) برای پروتکل صحیح نیست. لطفا پروتکل صحیح را وارد کنید"); exit;
		}
        if(preg_match('/tcp|ws|kcp|grpc|http/',$text)){
			if(count($input) != 5) {$telegram->sendMessage($userid,"لطفا متن بالا را با دقت بخونید و فرمت درست را بفرستید مثل \n vmess-30-30-tcp-1");exit; }
            $days = $input[1];
			if(preg_match('/hr/',$days)) $days = str_replace('hr','',$days) / 24; elseif(preg_match('/min/',$days)) $days = (str_replace('min','',$days) / 60) / 24;
            $volume = $input[2];
            $type = $input[3];
            $limitip = $input[4];
            $telegram->db->query("update fl_file set protocol='$protocol',days='$days',volume='$volume',limitip=$limitip,type='$type',step=4 where active=0");
        }else {
			if(count($input) != 6) {$telegram->sendMessage($userid,"لطفا متن بالا را با دقت بخونید و فرمت درست را بفرستید مثل \n vmess-30-100-1-20-1 \n یا\n vmess-30-50-tcp");exit; }
            $days = $input[1];
			if(preg_match('/hr/',$days)) $days = str_replace('hr','',$days) / 24; elseif(preg_match('/min/',$days)) $days = (str_replace('min','',$days) / 60) / 24;
            $volume = $input[2];
            $inbound_id = $input[3];
            $acount = $input[4];
            $limitip = $input[5];
            $telegram->db->query("update fl_file set protocol='$protocol',limitip=$limitip,inbound_id=$inbound_id,acount=$acount,days='$days',volume='$volume',step=4 where active=0");
        }

        $msg = '✅مشخصات سرویس با موفقیت ثبت شد . 
◀️ لطفا توضیحات را وارد کنید
.';
    $telegram->sendHTML($userid,$msg,$cancelop); 
    
    } //step 21
    if($step==4 and $text!='❌ انصراف'){
        $msg = '✅توضیحات با موفقیت ثبت شد . 
◀️ لطفا تصویر یا پیشنمایش را بصورت عکس ارسال کنید
.';
        if(strlen($text)>1 ){
            $telegram->db->query("update fl_file set descr='$text',step=5 where step=4");
            $telegram->sendMessageCURL($userid,$msg,$imgop);
        }

    } //step 4
    if($step==5 and $text!='❌ انصراف'){
        $imgtxt = '✅عملیات ثبت با موفقیت انجام شد ';
        //if($text != 'رد کردن این مرحله'){}
        $msg = $imgtxt.' 
◀ حالا️ اکانت های این پلن  را بصورت زیر ارسال کنید
دقت کنید که تمامی اطلاعات اکانت را با عبارت seprator از هم جدا کنید 

username: Test password: pwd...

seprator

username: Test
password: pwd
';
        if($text == 'رد کردن این مرحله'){
            $telegram->db->query("update fl_file set active=1,step=10 where step=5");
            $telegram->sendMessageCURL($userid,$imgtxt,$adminop);
			file_put_contents('state/'.$userid.'.txt','');
        }elseif($fileid){
            $photoURL = $telegram->FileURL($fileid);
            $photoext = pathinfo(basename($photoURL),PATHINFO_EXTENSION);
            $image = "images/".time().".$photoext";
            $somecontent = get_web_page($photoURL."?".rand(0,999999999));
            $handle = fopen($image,"x+");
            fwrite($handle,$somecontent);
            fclose($handle);

            $telegram->db->query("update fl_file set pic='$image',active=1,step=10 where step=5");
            $telegram->sendMessageCURL($userid,$imgtxt,$adminop);
			file_put_contents('state/'.$userid.'.txt','');
        }else{
            $msg = '‼️ لطفا تصویر را ارسال کنید';
            $telegram->sendMessageCURL($userid,$msg,$cancelop);
        }
    } //step 5
    if($step==6 and $text!='❌ انصراف'){
        if(preg_match('/seprator/',strtolower($text))){
            $telegram->db->query("update fl_file set fileid='$fileid',active=1,step=10 where step=6");
            $id = $telegram->db->query("select * from fl_file where active=1 order by id DESC limit 1")->fetch(2)['id'];

            $accs = explode('seprator',$text);
            foreach ($accs as $acc){
                if(strlen($acc) > 5)
                    $telegram->db->query("INSERT INTO `fl_accounts` (`id`, `fid`, `text`, `sold`, `active`) VALUES (NULL, $id, '$acc', '0', '1');");
            }
            $msg = "✅️ اکانت های این پلن  با موفقیت ثبت شد";
            $telegram->sendMessageCURL($userid,$msg,$finalop);
            file_put_contents('state/'.$userid.'.txt','');
        }else{
            $msg = '‼️ لطفا اکانت ها را با جداکننده معتبر ارسال کنید';
            $telegram->sendMessageCURL($userid,$msg,$cancelop);
        }
    } //step 6
}
// end add product
if($text=='مدیریت پلن ها' or $cdata == 'backplan' and ($userid==ADMIN or isAdmin() )){
    $res = $telegram->db->query("select * from fl_server where active=1")->fetchAll(2);
    if(empty($res)){
        $telegram->sendMessage($userid, 'لیست سرورها خالی است ');
        exit;
    }
    $keyboard = [];
    foreach($res as $cat){
        $id = $cat['id'];
        $title = $cat['title'];
        $keyboard[] = ['text' => "$title", 'callback_data' => "plalllan#$id"];
    }
    $keyboard = array_chunk($keyboard,2);
    
    $msg = ' 📍 برای دیدن لیست پلن ها روی سرور بزنید👇';
    
    if(!is_null($cdata) and $cdata=='backplan') {
        bot('editMessageText', [
            'chat_id' => $userid,
            'message_id' => $cmsgid,
            'text'=> $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }else { $telegram->sendAction($userid, 'typing');
        bot('sendmessage',[
            'chat_id' => $userid,
            'text'=> $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }
    
    
    exit;
}

if(preg_match('/plalllan/', $cdata)){
    $id = str_replace('plalllan#','', $cdata);
    $res = $telegram->db->query("SELECT * FROM `fl_file` WHERE server_id=$id order by id asc")->fetchAll(2);
    if(empty($res)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "هیچ پلنی برای این سرور وجود ندارد",
            'show_alert' => false
        ]);exit;
    }else {
        $keyboard = [];
        foreach($res as $cat){
            $id = $cat['id'];
            $title = $cat['title'];
            $keyboard[] = ['text' => "#$id $title", 'callback_data' => "pldetail#$id"];
        }
        $keyboard = array_chunk($keyboard,2);
        $keyboard[] = [['text' => "↪ برگشت", 'callback_data' => "backplan"],];
        $msg = ' 📍 یکی از پلن ها را انتخاب کنید تا جزییات آن را ببینید👇';
           $aa = bot('editmessageText', [
                'chat_id' => $userid,
                'message_id' => $cmsgid,
                'parse_mode' => "HTML",
                'text' => $msg,
                'reply_markup' => json_encode([
                    'inline_keyboard' => $keyboard
                ])
            ]);
        }
    
}
if(preg_match('/pldetail/', $cdata)){
    $id = str_replace('pldetail#','', $cdata);
    $pd = $telegram->db->query("SELECT * FROM `fl_file` WHERE id=$id")->fetch(2);
    if(empty($pd)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "موردی یافت نشد",
            'show_alert' => false
        ]);exit;
    }else {
        $id=$pd['id'];
        $name=$pd['title'];
        $price=$pd['price'];
        $acount =$pd['acount'];
        //$forder = $telegram->db->query("select * from fl_order where status=1 and fileid=$id")->fetch(2);
        $accnum = $telegram->db->query("select * from fl_order where status=1 and fileid=$id")->rowCount();
        $srvid= $pd['server_id'];
        //$srvname = $telegram->db->query("select * from fl_server where id=$srvid")->fetch(2)['title'];
        $msg = "
▪️#$id
📡srv $srvid 
🔻نام: $name /chpnm$id
💶قیمت: $price تومان /chpp$id
✴️ویرایش توضیحات: /desc$id
©️کپی:  /copypl$id
❌حذف: /delpd$id
تعداد اکانت های فروخته شده: $accnum
⚡دریافت لیست اکانت ها: /getlistpd$id
";
       if($pd['inbound_id'] != 0) $msg .= "⚡تغییر ظرفیت:$acount /chnglimitsrv$id";
       $keyboard = [[['text' => "↪ برگشت", 'callback_data' =>"plalllan#$srvid"],]];
       $aa = bot('editmessageText', [
            'chat_id' => $userid,
            'message_id' => $cmsgid,
            'parse_mode' => "HTML",
            'text' => $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
        }
    
}
if(preg_match('/copypl/',$text) and ($userid==ADMIN or isAdmin() )){
	$sid = str_replace('/copypl', '', $text);
    $srvs = $telegram->db->query("SELECT * FROM `server_info` WHERE id != $sid")->fetchAll(2);
    if(empty($srvs)) {
        $telegram->sendMessage($userid,'سرور دیگری برای کپی ندارید. لطفا ابتدا یک سرور بسازید و بعد پلن ها رو کپی کنید');
        exit;
    }
	
    file_put_contents("state/$userid.txt",$text);
    $srvkey = [];
    foreach($srvs as $srv){
        $id = $srv['id'];
        $panel_url = str_ireplace('http://','',str_ireplace('https://','',$srv['panel_url']));
        $srvkey[] = ['text' => $panel_url, 'callback_data' => "copypl#$id"];  
    } 
    $srvkey = array_chunk($srvkey,1);
    bot('sendmessage', [
        'chat_id' => $userid,
        'text' => "برای کپی پلن, سرور را انتخاب کنید :",
        'reply_markup' => json_encode(['inline_keyboard' => $srvkey])
    ]);
}
if(preg_match('/copypl/',$cdata) and preg_match('/copypl/',$state)){
    $fid = str_ireplace("/copypl",'', $state); 
    $sid=str_ireplace('copypl#','',$cdata);
    $file = $telegram->db->query("select * from fl_file where id=$fid")->fetch(2);
    $fileid = $file['fileid'];
    $catid = $file['catid'];
    $server_id = $file['server_id'];
    $inbound_id = $file['inbound_id'];
    $acount = $file['acount'];
    $limitip = $file['limitip'];
    $title = $file['title'];
    $protocol = $file['protocol'];
    $days = $file['days'];
    $volume = $file['volume'];
    $type = $file['type'];
    $price = $file['price'];
    $descr = $file['descr'];
    $pic = $file['pic'];
    $active = $file['active'];
    $step = $file['step'];
	$telegram->db->query('INSERT INTO `fl_file` VALUES (NULL, "", "'.$catid.'","'.$sid.'","'.$inbound_id.'","'.$acount.'", "'.$limitip.'", "'.$title.'", "'.$protocol.'", "'.$days.'", "'.$volume.'", "'.$type.'", "'.$price.'", "'.$descr.'", "'.$pic.'","'.$active.'","'.$step.'", "'.$time.'");');
	bot('editmessageText', [
        'chat_id' => $userid,
        'message_id' => $cmsgid,
        'text' => "✅پلن با سرور انتخابی ایجاد شد",
    ]);
    file_put_contents("state/$userid.txt",'');
}
if(preg_match('/getlistpd/',$text) and ($userid==ADMIN or isAdmin() )){
    $fid=str_ireplace('/getlistpd','',$text);
    $res = $telegram->db->query("select * from fl_order where status=1 and fileid=$fid order by id DESC limit 10")->fetchAll(2);
    if(empty($res)){
        $telegram->sendMessage($userid,'لیست خالی است');
        exit;
    }
    $txt = '';
    foreach ($res as $order){
		$suid = $order['userid'];
		$ures = $telegram->db->query("select * from fl_user where userid=$suid")->fetch(2);
        $date = $order['date'];
        $remark = $order['remark'];
        $date = jdate('Y-m-d H:i', $date);
        $uname = $ures['name'];
        $sold = "🔻".$uname. " ($date)";
        $accid = $order['id'];
        $txt = "$sold \n  $remark <code>".$order['link']."</code> \n  =========== \n";
        //$txt = $acc['text']." \n $sold | ❌ /delacc$accid \n =========== \n";
        bot('sendmessage', [
            'chat_id' => $userid,
            'parse_mode' => "HTML",
            'text' => $txt,
        ]); 
    }
    //$telegram->sendMessage($userid,$txt);
}
if(preg_match('/delacc/',$text) and ($userid==ADMIN or isAdmin() )){
    $aid=str_ireplace('/delacc','',$text);
    $telegram->db->query("delete from fl_accounts where id={$aid}");
    $telegram->sendMessage($userid,"اکانت موردنظر با موفقیت حذف شد");
}
if(preg_match('/addpd/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"اکانت ها  را بصورت زیر ارسال کنید
دقت کنید که تمامی اطلاعات اکانت را با عبارت seprator از هم جدا کنید 

username: Test password: pwd...

seprator

username: Test
password: pwd

",$cancelop);exit;
}
if(preg_match('/addpd/',$state)){
    $pid=str_ireplace('/addpd','',$state);
    if(preg_match('/seprator/',strtolower($text))){
        $accs = explode('seprator',$text);
        foreach ($accs as $acc){
            if(strlen($acc) > 5)
                $telegram->db->query("INSERT INTO `fl_accounts` (`id`, `fid`, `text`, `sold`, `active`) VALUES (NULL, $pid, '$acc', '0', '1');");
        }
        $telegram->sendMessageCURL($userid,"✅اکانت های جدید با موفقیت اضافه شد",$finalop);
        file_put_contents('state/'.$userid.'.txt','');
    }else{
        $msg = '‼️ لطفا اکانت ها را با جداکننده معتبر ارسال کنید';
        $telegram->sendMessageCURL($userid,$msg,$cancelop);
    }
}

if(preg_match('/delpd/',$text) and ($userid==ADMIN or isAdmin() )){
    $fid=str_ireplace('/delpd','',$text);
    $telegram->db->query("delete from fl_file where id={$fid}");
    $telegram->sendMessage($userid,"پلن موردنظر با موفقیت حذف شد");
}
if(preg_match('/chpnm/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"نام جدید پلن را وارد کنید:",$cancelop);exit;
}
if(preg_match('/chpnm/',$state) and $text != '❌ انصراف') {
    $pid=str_ireplace('/chpnm','',$state);
    $telegram->db->query("update fl_file set title='$text' where id={$pid}");
    $telegram->sendMessageCURL($userid,"✅عملیات با موفقیت انجام شد", $adminop);
    file_put_contents("state/$userid.txt",'');
}
if(preg_match('/chnglimitsrv/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"ظرفیت جدید پلن را بصورت عدد لاتین وارد کنید:",$cancelop);exit;
}
if(preg_match('/chnglimitsrv/',$state) and $text != '❌ انصراف') {
    $pid=str_ireplace('/chnglimitsrv','',$state);
	if(is_numeric($text)){
        $telegram->db->query("update fl_file set acount='$text' where id={$pid}");
		$telegram->sendMessageCURL($userid,"✅عملیات با موفقیت انجام شد", $adminop);
		file_put_contents("state/$userid.txt",'');
    }else{
        $telegram->sendMessage($userid,"یک مقدار عددی و صحیح وارد کنید");
    }
}
if(preg_match('/desc/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"توضیحات جدید را وارد کنید:",$cancelop);exit;
}
if(preg_match('/desc/',$state) and $text != '❌ انصراف') {
    $pid=str_ireplace('/desc','',$state);
    $telegram->db->query("update fl_file set descr='$text' where id={$pid}");
    $telegram->sendMessageCURL($userid,"✅عملیات با موفقیت انجام شد", $adminop);
    file_put_contents("state/$userid.txt",'');
}
if(preg_match('/chpp/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"قیمت جدید را وارد کنید:",$cancelop);exit;
}
if(preg_match('/chpp/',$state) and $text != '❌ انصراف') {
    $pid=str_ireplace('/chpp','',$state);
    if(is_numeric($text)){
        $telegram->db->query("update fl_file set price='$text' where id={$pid}");
        $telegram->sendMessageCURL($userid,"✅عملیات با موفقیت انجام شد", $adminop);
        file_put_contents("state/$userid.txt",'');
    }else{
        $telegram->sendMessage($userid,"یک مقدار عددی و صحیح وارد کنید");
    }
}
if($text=='🧑‍💻سرویس های من' or $cdata == 'backto' or preg_match('/ordpaginate/',$cdata) or $text =='/services'){
    $results_per_page = 50;  
    $number_of_result = $telegram->db->query("SELECT * FROM `fl_order` WHERE userid=$userid and status=1")->rowCount();  
    $number_of_page = ceil ($number_of_result / $results_per_page);
    $page = (preg_match('/ordpaginate/',$cdata)) ? str_replace('ordpaginate#','',$cdata) : 1;
    $page_first_result = ($page-1) * $results_per_page;  
    
    $orders = $telegram->db->query("SELECT * FROM `fl_order` WHERE userid=$userid and status=1 order by id DESC limit $page_first_result, $results_per_page")->fetchAll(2);
    if(empty($orders)){
        $telegram->sendMessage($userid, 'لیست سفارش ها خالی است. لطفا یک پلن جدید خریداری کنید.');
        exit;
    }
    $keyboard = [];
    foreach($orders as $cat){
        $id = $cat['id'];
        $remark = $cat['remark'];
        $keyboard[] = ['text' => "$remark", 'callback_data' => "ordetail#$id"];
    }
    $keyboard = array_chunk($keyboard,2);
    
    /* Setup page vars for display. */
    $prev = $page - 1;      //previous page is page - 1
    $next = $page + 1;      //next page is page + 1
    $lastpage = ceil($number_of_page/$results_per_page);      //lastpage is = total pages / items per page, rounded up.
    $lpm1 = $lastpage - 1;                      //last page minus 1
    //$telegram->sendMessage($userid,"prev $prev next $next lastpage $lastpage page_first_result $page_first_result page $page number_of_page $number_of_page number_of_result $number_of_result");
    
    $buttons = [];
    //previous button
    if ($prev > 0) $buttons[] = ['text' => "◀", 'callback_data' => "ordpaginate#$prev"];

    //next button
    if ($next > 0 and $page != $number_of_page) $buttons[] = ['text' => "➡", 'callback_data' => "ordpaginate#$next"];   
    $keyboard[] = $buttons;
    
	$keyboard[] = [['text' => "🔎جستجو", 'callback_data' => "srchusrrmrk"]];
    $msg = ' 📍 برای دیدن مشخصات سرویس روی آن بزنید👇';
    
    if(!is_null($cdata)) {
        bot('editMessageText', [
            'chat_id' => $userid,
            'message_id' => $cmsgid,
            'text'=> $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }else { $telegram->sendAction($userid, 'typing');
        bot('sendmessage',[
            'chat_id' => $userid,
            'text'=> $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }
    exit;
}
if($cdata == 'srchusrrmrk') {
    file_put_contents('state/' . $userid . '.txt', 'srchusrrmrk');
    $telegram->sendMessageCURL($userid, "⏪ ریمارک را ارسال کنید ",$cancelop);exit;
}
if($state == 'srchusrrmrk' and $text != '❌ انصراف'){
	$remark = $text;
    if(preg_match('/^vmess:\/\//',$text)){
        $link_info = json_decode(base64_decode(str_replace('vmess://','',$text)));
        $remark = $link_info->ps;
    }elseif(preg_match('/^ss:\/\//',$text)){
	    $link_info = str_replace("ss://",'',$text);
	    $link_info = explode("#",$link_info);
	    $remark = $link_info[1];
	}elseif(preg_match('/^vless:\/\//',$text)){
		$link = urldecode($text);
        $link_info = parse_url($link);
        $remark = $link_info['fragment'];
    }
    $result = $telegram->db->query("select * from fl_order where remark LIKE '%$remark%' and status=1 and userid='$userid'")->fetch();
    if(empty($result)){
        $telegram->sendMessage($userid,"موردی یافت نشد");exit;
    }else{
        $id = $result['id'];
        $remark = $result['remark'];
        $uid = $result['userid'];
        $telegram->sendMessageCURL($userid, "سفارش $remark یافت شد :",$finalop);
        $keyboard = [[['text' => "$remark", 'callback_data' => "ordetail#$id"]]];
        $msg = ' 📍 برای دیدن مشخصات سرویس روی آن بزنید👇';
        bot('sendmessage',[
            'chat_id' => $userid,
            'text'=> $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
        file_put_contents('state/' . $userid . '.txt', '');
        exit;
    }
}
if(preg_match('/switchserv/', $cdata)){
	if($gateways['change_location'] == 0){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻در حال حاضر تغییر لوکیشن غیرفعال است و بزودی فعال می کنیم',
            'show_alert' => true
        ]);
        exit;
    }
    $input = explode('#',$cdata);
    $order_id = $input[1];
    $server_id = $input[2];
    $leftgp = $input[3];
    $expire = $input[4]; 
    if( $leftgp <= 0) { // $expire < time() or
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "سرویس شما غیرفعال است.لطفا ابتدا آن را تمدید کنید",
            'show_alert' => true
        ]);exit;
    }
	
	$srvip = $telegram->db->query("select * from server_info WHERE id = $server_id")->fetch(2); 
    if($srvip['vip'] == '2'){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻امکان تغییر لوکیشن برای این سرور وجود ندارد',
            'show_alert' => true
        ]);
        exit;
    }
	
    $respd = $telegram->db->query("select * from fl_server WHERE active=1 and ucount > 0 and id != $server_id")->fetchAll(2);
    if(empty($respd)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => 'در حال حاضر هیچ سرور فعالی برای تغییر لوکیشن وجود ندارد',
            'show_alert' => true
        ]);exit;
    }
    $keyboard = [];
    foreach($respd as $cat){
        $sid = $cat['id'];
        $name = $cat['title'].$cat['flag'];
        $isvip = $telegram->db->query("select * from server_info where id = $sid")->fetch(2);
        if($srvip['vip'] == $isvip['vip'] or $isvip['vip'] == 0) $keyboard[] = ['text' => "$name", 'callback_data' => "chngsrrv#$sid#$order_id"];
    }
    $keyboard = array_chunk($keyboard,2);
    $keyboard[] = [['text' => '🔙 بازگشت', 'callback_data' => "ordetail#$order_id"]];
    bot('editMessageText', [
            'chat_id' => $cuserid,
            'message_id' => $cmsgid,
        'text'=> ' 📍 لطفا برای تغییر لوکیشن سرویس فعلی, یکی از سرورها را انتخاب کنید👇',
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);

}
if(preg_match('/chngsrrv/',$cdata)){
	/*bot('answercallbackquery', [
		'callback_query_id' => $cid,
		'text' => '🔻فعلا امکان تغییر لوکیشن نیست',
		'show_alert' => true
	]);
	exit;*/
    $input = explode('#',$cdata);
    $sid = $input[1];
    $oid = $input[2];
    $order = $telegram->db->query("select * from fl_order where id=$oid")->fetch(2);
    $inbound_id = $order['inbound_id'];
    $server_id = $order['server_id'];
    $fileid = $order['fileid'];
	
	$server_info = $telegram->db->query("SELECT * FROM fl_server WHERE id=$sid")->fetch(2);
	if($inbound_id == 0){
	    if($server_info['ucount'] == 0) {
    		bot('answercallbackquery', [
    			'callback_query_id' => $cid,
    			'text' => 'ظرفیت این سرور پر شده است',
    			'show_alert' => true
    		]);
    		exit;
    	}
	}/*elseif($inbound_id > 0){
	    $file_detail = $telegram->db->query("select SUM(acount) as acount from fl_file WHERE server_id=$sid and inbound_id = $inbound_id and active=1")->fetch(2);
	    if($file_detail){ //$telegram->sendMessage($userid, json_encode($file_detail['acount']));die;
	        if($file_detail['acount'] == 0) {
        		bot('answercallbackquery', [
        			'callback_query_id' => $cid,
        			'text' => 'ظرفیت کانکشن مورد نظر در این سرور پر شده است',
        			'show_alert' => true
        		]);
        		exit;
        	}
	    }
	}*/
	
    $remark = $order['remark'];
    $protocol = $order['protocol'];
	$link = $order['link'];
    if($protocol == 'vmess'){
		$link_info = json_decode(base64_decode(str_replace('vmess://','',$link)));
		$uniqid = $link_info->id;
		$panel_url = $link_info->add;
		$port = $link_info->port;
		$netType = $link_info->net;
	}elseif($protocol == 'shadowsocks'){
	    $link_info = str_replace("ss://",'',$link);
	    
	    $link_info = explode("#",$link_info);
	    $remark = $link_info[1];
	    $link_info = base64_decode($link_info[0]); 
	    $link_info = explode('@',$link_info);
	    
	    $uniqid = explode(':',$link_info[0])[1];
	    $link_info = $link_info[1];
	    $link_info = explode(':',$link_info);
	    $panel_url =$link_info[0];
		$port = $link_info[1];
		$netType = 'tcp';
		$protocol = "shadowsocks";
	}else{
		$link = urldecode($link);
		$link_info = parse_url($link);
		$panel_ip = $link_info['host'];
		$uniqid = $link_info['user'];
		$port = $link_info['port'];
		$netType = explode('type=',$link_info['query'])[1];
		$netType = explode('&',$netType)[0];
	}
    
    require_once('vray.php');
    if($inbound_id > 0) {
        $remove_response = remove_client($server_id, $inbound_id, $remark);
		if(is_null($remove_response)){
			bot('answercallbackquery', [
				'callback_query_id' => $cid,
				'text' => '🔻اتصال به سرور برقرار نیست. لطفا به مدیریت اطلاع بدید',
				'show_alert' => true
			]);
			exit;
		}
        if($remove_response){
            $total = $remove_response['total'];
            $up = $remove_response['up'];
            $down = $remove_response['down'];
			if(is_null($total) or is_null($remove_response['expiryTime'])){
                bot('answercallbackquery', [
    				'callback_query_id' => $cid,
    				'text' => '🔻امکان دریافت اطلاعات سرویس از سرور مبدا نیست. لطفا به مدیریت اطلاع بدید',
    				'show_alert' => true
    			]);
    			exit;
            }
			
			$savedinfo = file_get_contents('savedinfo.txt');
            $savedinfo = explode('-',$savedinfo);
            $port = $savedinfo[0] + 1;
            $last_num = $savedinfo[1] + 1;
        
            $srv_remark = $telegram->db->query("select * from fl_server WHERE id=$sid")->fetch(2)['remark'];
			$uremark = $telegram->db->query("select * from fl_remark where userid='$userid'")->fetch(2);
			if($uremark) $uremark = $uremark['remark']; else $uremark = $srv_remark;
			$oldrmrk = explode('-',$remark)[0];
			$new_remark = "{$oldrmrk}-{$last_num}";
			
			if($protocol == 'trojan' or  $protocol == 'shadowsocks'){
			    $id_label = 'password';
			}else{
			    $id_label = 'id';
			}
			$uniqid = is_null($uniqid) ? (is_null($remove_response['id']) ? generateRandomString(42,$protocol) : $remove_response['id'] ) : $uniqid; 
			if($uniqid == '' or $uniqid == null) $uniqid = generateRandomString(42,$protocol);
			
			$leftgb = $total - $up - $down;
			if($leftgb < 0 or $leftgb == 0) $leftgb = 0.001; 
			$newArr = [
				"$id_label" => $uniqid,
				"flow" => $remove_response['flow'],
				"email" => $new_remark,
				"limitIp" => intval($remove_response['limitIp']),
				"totalGB" => $leftgb,
				"expiryTime" => $remove_response['expiryTime'],
				"enable" => true, 
				"tgId" => "",  
				"subId" => rand(0,99999999999999999)
			];
            
			/*$response = getList($sid);
            if($inbound_id > 0 & !is_null($response)) { 
                foreach($response->obj as $row){ 
                    if($row->id == $inbound_id) {  
                        $des_procotol = $row->protocol;
                        $des_netType = json_decode($row->streamSettings)->network;
                        break;
                    }
                }
            }
            if(!is_null($des_procotol)) {
                if($des_procotol != $protocol || $des_netType != $netType){
                    bot('answercallbackquery', [
                        'callback_query_id' => $cid,
                        'text' => "🔻اینباند شماره $inbound_id در سرور مقصد پروتکل/نوع شبکه متفاوتی از سرور مبدا دارد. لطفا به مدیریت اطلاع بدید",
                        'show_alert' => true
                    ]);
                    exit;
                }
            }*/
			
            $response = add_inbount_client($sid, '', $inbound_id, 1, $new_remark, 0, 1, $newArr); 
            if(is_null($response)){
                bot('answercallbackquery', [
                    'callback_query_id' => $cid,
                    'text' => '🔻اتصال به سرور برقرار نیست. لطفا به مدیریت اطلاع بدید',
                    'show_alert' => true
                ]);
                exit;
            }
			if($response == "inbound not Found"){
                bot('answercallbackquery', [
                    'callback_query_id' => $cid,
                    'text' => "🔻سطر (inbound) با آیدی $inbound_id در این سرور یافت نشد و یا کوکی منقضی شده. لطفا به مدیریت اطلاع بدید",
                    'show_alert' => true
                ]);
                exit;
            }
			if(!$response->success){
				bot('answercallbackquery', [
					'callback_query_id' => $cid,
					'text' => '🔻خطا در ساخت کانفیگ. لطفا به مدیریت اطلاع بدید',
					'show_alert' => true
				]);$telegram->sendMessage(ADMIN,"changeLoc > 0 = serverID: $sid :".$response->msg);
				exit;
			}
			$vray_link = genLink($sid, $uniqid, $protocol, $new_remark, $port, $netType, $inbound_id);
			remove_client($server_id, $inbound_id, $remark, 1);
			$telegram->db->query("UPDATE fl_order set remark='$new_remark' where id=$oid");
			file_put_contents('savedinfo.txt',$port.'-'.$last_num);
			//$telegram->db->query("UPDATE `fl_file` SET `acount` = acount + 1 WHERE server_id=$server_id and inbound_id = $inbound_id ");
			//$telegram->db->query("UPDATE `fl_file` SET `acount` = acount - 1 WHERE server_id=$sid and inbound_id = $inbound_id ");
        }
    }else{
        $response = remove_inbound($server_id, $remark);
		if(is_null($response)){
			bot('answercallbackquery', [
				'callback_query_id' => $cid,
				'text' => '🔻اتصال به سرور برقرار نیست. لطفا به مدیریت اطلاع بدید',
				'show_alert' => true
			]);
			exit;
		}
        if($response){
			if(is_null($response['volume']) or is_null($response['expiryTime'])){
                bot('answercallbackquery', [
    				'callback_query_id' => $cid,
    				'text' => '🔻امکان دریافت اطلاعات سرویس از سرور مبدا نیست. لطفا به مدیریت اطلاع بدید',
    				'show_alert' => true
    			]);
    			exit;
            }
            $savedinfo = explode('-',file_get_contents('savedinfo.txt'));
            $port = $savedinfo[0] + 1;
            $last_num = $savedinfo[1] + 1;
			
			$srv_remark = $telegram->db->query("select * from fl_server WHERE id=$sid")->fetch(2)['remark'];
			$uremark = $telegram->db->query("select * from fl_remark where userid='$userid'")->fetch(2);
			if($uremark) $uremark = $uremark['remark']; else $uremark = $srv_remark;
			$oldrmrk = explode('-',$remark)[0];
			$new_remark = "{$oldrmrk}-{$last_num}";
            
			$uniqid = is_null($uniqid) ? (is_null($response['uniqid']) ? generateRandomString(42,$protocol) : $response['uniqid'] ) : $uniqid; 
			if($uniqid == '' or $uniqid == null) $uniqid = generateRandomString(42,$protocol);
			
            $add_response = add_inbound($sid, $uniqid, $protocol, $port, $response['expiryTime'], $new_remark, $response['volume'] / 1073741824, $response['netType'], $response['security']);
			
			if(is_null($add_response)){
                bot('answercallbackquery', [
                    'callback_query_id' => $cid,
                    'text' => '🔻اتصال به سرور برقرار نیست. لطفا به مدیریت اطلاع بدید',
                    'show_alert' => true
                ]);
                exit;
            }
			if(!$add_response->success){
				bot('answercallbackquery', [
					'callback_query_id' => $cid,
					'text' => '🔻خطا در ساخت کانفیگ در سرور مقصد. لطفا به مدیریت اطلاع بدید',
					'show_alert' => true
				]);
				$telegram->sendMessage(ADMIN,"changeLoc 0 = serverID: $sid :".$add_response->msg);
				exit;
			}
			if(is_null($response['uniqid'])) {
			    bot('answercallbackquery', [
					'callback_query_id' => $cid,
					'text' => '🔻خطا در تغییر لوکیشن. لطفا بعدا مجدد تلاش کنید',
					'show_alert' => true
				]);
				exit;
			}
			$vray_link = genLink($sid, $response['uniqid'], $response['protocol'], $new_remark, $port, $response['netType'], $inbound_id);
            remove_inbound($server_id, $remark, 1);
            file_put_contents('savedinfo.txt',$port.'-'.$last_num);
        }
    }
    $telegram->db->query("UPDATE fl_order set server_id=$sid,link='$vray_link', remark='$new_remark' where id=$oid");
	$telegram->db->query("UPDATE `fl_server` SET `ucount` = ucount + 1 WHERE id=$server_id");
	$telegram->db->query("UPDATE `fl_server` SET `ucount` = ucount - 1 WHERE id=$sid");
    
    $server_title = $telegram->db->query("select * from fl_server where id=$sid")->fetch(2)['title'];
	bot('answercallbackquery', [
        'callback_query_id' => $cid,
        'text' => "✅سرویس مورد نظر با موفقیت به لوکیشن $server_title انتقال یافت",
        'show_alert' => true
    ]);
    /*$orders = $telegram->db->query("SELECT * FROM `fl_order` WHERE userid=$userid and status=1 order by id DESC")->fetchAll(2);
    $keyboard = [];
    foreach($orders as $cat){
        $id = $cat['id'];
        $cremark = $cat['remark'];
        $keyboard[] = ['text' => "$cremark", 'callback_data' => "ordetail#$id"];
    }
    $keyboard = array_chunk($keyboard,2);
    
    $msg = " 📍لوکیشن سرویس $remark به $server_title تغییر یافت.\n لطفا برای مشاهده مشخصات, روی آن بزنید👇";
    
    bot('editMessageText', [
        'chat_id' => $userid,
        'message_id' => $cmsgid,
        'text'=> $msg,
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);*/
	
	$cdata = "ordetail#$oid";
}
if(preg_match('/unewlink/',$cdata)){
    $input = explode('#',$cdata);
    $oid = $input[1];
	
	bot('answercallbackquery', [
		'callback_query_id' => $cid,
		'text' => "لینک کانفیگ بروز شد",
		'show_alert' => false
	]);
	$order = $telegram->db->query("SELECT * FROM `fl_order` WHERE userid=$userid and id=$oid")->fetch(2);
	$remark = $order['remark'];
	$protocol = $order['protocol'];
	$server_id = $order['server_id'];
	$inbound_id = $order['inbound_id']; 
	$link = $order['link'];
	if($protocol == 'vmess'){
		$link_info = json_decode(base64_decode(str_replace('vmess://','',$link)));
		$uniqid = $link_info->id;
		$panel_url = $link_info->add;
		$port = $link_info->port;
		$netType = $link_info->net;
	}elseif($protocol == 'shadowsocks'){
	    $link_info = str_replace("ss://",'',$link);
	    
	    $link_info = explode("#",$link_info);
	    $remark = $link_info[1];
	    $link_info = base64_decode($link_info[0]); 
	    $link_info = explode('@',$link_info);
	    
	    $uniqid = explode(':',$link_info[0])[1];
	    $link_info = $link_info[1];
	    $link_info = explode(':',$link_info);
	    $panel_url =$link_info[0];
		$port = $link_info[1];
		$netType = 'tcp';
		$protocol = "shadowsocks";
	}else{
		$link = urldecode($link);
		$link_info = parse_url($link);
		$panel_ip = $link_info['host'];
		$uniqid = $link_info['user'];
		$port = $link_info['port'];
		$netType = explode('type=',$link_info['query'])[1];
		$netType = explode('&',$netType)[0];
	}
	include_once('vray.php');
	$vray_link = genLink($server_id, $uniqid, $protocol, $remark, $port, $netType, $inbound_id);
	$telegram->db->query("UPDATE fl_order set link='$vray_link' WHERE id='$oid'");

	$cdata = "ordetail#$oid";
}
if(preg_match('/chngnetType/', $cdata)){
	if($gateways['change_nettype'] != 1){
        bot('answercallbackquery', [
    		'callback_query_id' => $cid,
    		'text' => '🔻فعلا امکان تغییر نوع شبکه نیست',
    		'show_alert' => true
    	]);
    	exit;
    }
    $input = explode('#',$cdata);
    $fid = $input[1];
    $oid = $input[2];
    
	$respd = $telegram->db->query("select * from fl_file WHERE id='$fid' and active=1")->fetch(2); 
	if($respd){
		$cadres = $telegram->db->query("select * from fl_cat WHERE id=".$respd['catid'])->fetch(2);
		if($cadres) {
			$catname = $cadres['title'];
			$name = $catname." ".$respd['title'];
		}else $name = "#$id";
	}else $name = "#$id";

    $order = $telegram->db->query("SELECT * FROM `fl_order` WHERE id=$oid")->fetch(2);
    $date = jdate("Y-m-d H:i",$order['date']);
    $expire_date = jdate(" H:i d-m-Y",$order['expire_date']);
    $remark = $order['remark'];
    $acc_link = $order['link'];
    $protocol = $order['protocol'];
    $server_id = $order['server_id'];

    include_once('vray.php');
    $response = getList($server_id)->obj;
    foreach($response as $row){
        if($row->remark == $remark) {
            $total = $row->total;
            $up = $row->up;
            $down = $row->down;
            $port = $row->port;
            $uniqid = ($protocol == 'trojan') ? json_decode($row->settings)->clients[0]->password : json_decode($row->settings)->clients[0]->id;
			if($protocol == 'shadowsocks') $uniqid = json_decode($row->settings)->password;
            $netType = json_decode($row->streamSettings)->network; 
            $netType = ($netType == 'tcp') ? 'ws' : 'tcp';
            //$telegram->sendMessage($userid, "ne $netType");
        break;
        }
    }

    if($protocol == 'trojan') $netType = 'tcp';
    //$telegram->sendMessage($cuserid,"$protocol - $total - $port $uniqid $remark");
    $leftgb = round( ($total - $up - $down) / 1073741824, 2) . " GB";

    $update_response = update_inbound($server_id, $uniqid, $remark, $protocol, $netType); //$telegram->sendMessage($cuserid,$update_response->msg);
    $vray_link = genLink($server_id, $uniqid, $protocol, $remark, $port, $netType);
    // update order
    $telegram->db->query("UPDATE fl_order set protocol='$protocol',link='$vray_link' WHERE id='$oid'");
	$cdata = "ordetail#$oid";

}

if(preg_match('/chngprotocol/', $cdata)){
	if($gateways['change_protocol'] != 1){
        bot('answercallbackquery', [
    		'callback_query_id' => $cid,
    		'text' => '🔻فعلا امکان تغییر پروتکل نیست',
    		'show_alert' => true
    	]);
    	exit;
    }
    $input = explode('#',$cdata);
    $fid = $input[1];
    $oid = $input[2];
    $protocol = $input[3];
    
	$respd = $telegram->db->query("select * from fl_file WHERE id='$fid' and active=1")->fetch(2); 
	if($respd){
		$cadres = $telegram->db->query("select * from fl_cat WHERE id=".$respd['catid'])->fetch(2);
		if($cadres) {
			$catname = $cadres['title'];
			$name = $catname." ".$respd['title'];
		}else $name = "#$id";
	}else $name = "#$id";

    $order = $telegram->db->query("SELECT * FROM `fl_order` WHERE id=$oid")->fetch(2);
    $date = jdate("Y-m-d H:i",$order['date']);
    $expire_date = jdate(" H:i d-m-Y",$order['expire_date']);
    $remark = $order['remark'];
    $acc_link = $order['link'];
    $server_id = $order['server_id'];

    include_once('vray.php');
    $response = getList($server_id)->obj;
    foreach($response as $row){
        if($row->remark == $remark) {
            $total = $row->total;
            $up = $row->up;
            $down = $row->down;
            $port = $row->port;
            //$uniqid = ($protocol == 'trojan') ? json_decode($row->settings)->clients[0]->password : json_decode($row->settings)->clients[0]->id;
            $netType = json_decode($row->streamSettings)->network;
            break;
        }
    }
    if($protocol == 'trojan') $netType = 'tcp';
    $uniqid = generateRandomString(42,$protocol); 
    //$telegram->sendMessage($cuserid,"$protocol - $total - $port $uniqid $remark");
    $leftgb = round( ($total - $up - $down) / 1073741824, 2) . " GB";

    $update_response = update_inbound($server_id, $uniqid, $remark, $protocol, $netType, $security); //$telegram->sendMessage($cuserid,$update_response->msg);
    $vray_link = genLink($server_id, $uniqid, $protocol, $remark, $port, $netType);

    // update order
    $telegram->db->query("UPDATE fl_order set protocol='$protocol',link='$vray_link' WHERE id='$oid'");
	$cdata = "ordetail#$oid";

}
if(preg_match('/unrqewlink/', $cdata)){
    $id = str_replace('unrqewlink#','', $cdata);
    $keyboard = [[['text' => "☑انصراف", 'callback_data' => "ordetail#$id"],['text' => "✅تایید", 'callback_data' => "sunewuidlink#$id"]]];
            
    bot('editmessageText', [
        'chat_id' => $userid,
        'message_id' => $cmsgid,
        'parse_mode' => "HTML",
        'text' => '⚠️بعد از انتخاب گزینه تایید, لینک شما بطور کامل قطع و جایگزین لینک جدید می شود',
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]); 
}

if(preg_match('/sunewuidlink/',$cdata)){
    $input = explode('#',$cdata);
    $oid = $input[1];
	
	bot('answercallbackquery', [
		'callback_query_id' => $cid,
		'text' => "لینک کانفیگ تغییر کرد",
		'show_alert' => false
	]);
	
	$order = $telegram->db->query("SELECT * FROM `fl_order` WHERE id=$oid")->fetch(2);
    $remark = $order['remark'];
    $server_id = $order['server_id'];
    $inbound_id = $order['inbound_id'];
    $protocol = $order['protocol'];
    $link = $order['link'];
	if($protocol == 'vmess'){
		$link_info = json_decode(base64_decode(str_replace('vmess://','',$link)));
		$uniqid = $link_info->id;
		$panel_url = $link_info->add;
		$port = $link_info->port;
		$netType = $link_info->net;
	}elseif($protocol == 'shadowsocks'){
	    $link_info = str_replace("ss://",'',$link);
	    
	    $link_info = explode("#",$link_info);
	    $remark = $link_info[1];
	    $link_info = base64_decode($link_info[0]); 
	    $link_info = explode('@',$link_info);
	    
	    $uniqid = explode(':',$link_info[0])[1];
	    $link_info = $link_info[1];
	    $link_info = explode(':',$link_info);
	    $panel_url =$link_info[0];
		$port = $link_info[1];
		$netType = 'tcp';
		$protocol = "shadowsocks";
	}else{
		$link = urldecode($link);
		$link_info = parse_url($link);
		$panel_ip = $link_info['host'];
		$uniqid = $link_info['user'];
		$port = $link_info['port'];
		$netType = explode('type=',$link_info['query'])[1];
		$netType = explode('&',$netType)[0];
	}
	if($uniqid == '' or $uniqid == null) $uniqid = generateRandomString(42,$protocol);

    require_once('vray.php');
    $uniqid = generateRandomString(42,$protocol); 
    
    if($inbound_id > 0)
        $update_response = update_client_uuid($server_id, $inbound_id, $remark, $uniqid);
    else
        $update_response = update_inbound_uuid($server_id, $inbound_id, $remark, $uniqid);
        
    if(is_null($update_response)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻اتصال به سرور برقرار نیست. لطفا به مدیریت اطلاع بدید',
            'show_alert' => true
        ]);
        exit;
    }
	if(!$update_response->success){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻خطا در بروزرسانی کانفیگ. لطفا به مدیریت اطلاع بدید',
            'show_alert' => true
        ]);
        exit;
    }
    
    $vray_link = genLink($server_id, $uniqid, $protocol, $remark, $port, $netType, $inbound_id);
	$telegram->db->query("UPDATE fl_order set link='$vray_link' WHERE id='$oid'");

	$cdata = "ordetail#$oid";
}

if(preg_match('/ordetail/', $cdata)){
    $id = str_replace('ordetail#','', $cdata);
    $order = $telegram->db->query("SELECT * FROM `fl_order` WHERE userid=$userid and id=$id")->fetch(2);
    if(empty($order)){
        $telegram->sendMessage($userid,"موردی یافت نشد");exit;
    }else {
        $fid = $order['fileid']; 
    	$respd = $telegram->db->query("select * from fl_file WHERE id='$fid' and active=1")->fetch(2); 
    	if($respd){
			$orginal_days = $respd['days'];
    	    $cadres = $telegram->db->query("select * from fl_cat WHERE id=".$respd['catid'])->fetch(2);
    	    if($cadres) {
    	        $catname = $cadres['title'];
        	    $name = $catname." ".$respd['title'];
    	    }else $name = "#$id";
    	}else $name = "#$id";
    	
    	//$acc_id = $order['acc_id'];
    	//$acc_text = $telegram->db->query("select * from fl_accounts WHERE id=$acc_id")->fetch(2)['text'];
    	
        //$amount = number_format($order['amount'])." Toman";
        $date = jdate("Y-m-d H:i",$order['date']);
        $remark = $order['remark'];
        $acc_link = $order['link'];
        $protocol = $order['protocol'];
        $server_id = $order['server_id'];
        $inbound_id = $order['inbound_id'];
		
		$amount = $order['amount'];
		if($amount == 2) $name = "#$id";
		
    
        include_once('vray.php');
        $response = getList($server_id)->obj;
        if($inbound_id == 0) {
            foreach($response as $row){
                if($row->remark == $remark) {
                    $total = $row->total;
                    $up = $row->up;
                    $down = $row->down; 
                    $netType = json_decode($row->streamSettings)->network;
					$expire_date = $row->expiryTime > 0 ? substr_replace($row->expiryTime, "", -3) : $row->expiryTime;
					$clients = json_decode($row->settings)->clients;
                    if($clients){
                        $expire_date = $clients[0]->expiryTime > 0 ? substr_replace($clients[0]->expiryTime, "", -3) : $clients[0]->expiryTime;
                    }
                    break;
                }
            }
        }else {
            foreach($response as $row){
                if($row->id == $inbound_id) {
                    $netType = json_decode($row->streamSettings)->network;
                    $clients = is_null($row->clientStats) ? $row->clientInfo : $row->clientStats;
                    $settings = json_decode($row->settings, true);
                    foreach($clients as $client) {
                        if($client->email == $remark) { 
							$up = $client->up;
                            $down = $client->down; 
                            $expire_date = $client->expiryTime > 0 ? substr_replace($client->expiryTime, "", -3) : $client->expiryTime;
                            $clients = $settings['clients'];
                            foreach($clients as $key => $client) {
                                if($client['email'] == $remark) {
                                    $total = $settings['clients'][$key]['totalGB'];
                                }
                            }
                            if($total == 0 || is_null($total)) $total = $client->total;
                            break;
                        }
                    }
					if(is_null($total)){
                        $clients = $settings['clients'];
                            foreach($clients as $key => $client) {
                                if($client['email'] == $remark) {
                                    $total = $settings['clients'][$key]['totalGB'];
                                }
                            }
                    }
                    break;
                }
            }
        }
		
		if($expire_date < 0){
			$left_days = +abs($expire_date / 86400000);
            $expire_date = $left_days ." روز بعد از اولین اتصال";
			$link_status = "فعال";
			
        }else{
			if(!is_null($expire_date)) {
				if(strlen($expire_date) > 0) $telegram->db->query("update fl_order set expire_date='$expire_date' where id=$id"); 
			}else{
				$expire_date = $order['expire_date'];
			}
			
			if(intval($expire_date)){
				$inputSeconds = $expire_date - time();
				$time = secondsToTime($inputSeconds);
				$left_days = $time['d'];
			}
			if(is_null($orginal_days)) $orginal_days = 0;
			
			$link_status = (($expire_date < time() and $expire_date !=0)  or ($total - $up - $down < 0 and $total != 0) ) ? 'غیرفعال' : 'فعال';
			$expire_date = $expire_date == 0 ? 'نامحدود' : jdate(" H:i d-m-Y",$expire_date);
		}
		
		
        $leftgb = round( ($total - $up - $down) / 1073741824, 2) . " GB";
		
		if(is_null($total)){
            bot('answercallbackquery', [
                'callback_query_id' => $cid,
                'text' => "⚠️اطلاعات سرویس یافت نشد. احتمالا مشکل از ارتباط با سرور یا خطای مشابه است. لطفا تمدید, افزایش حجم و زمان, تغییر لوکیشن یا پروتکل را نزنید و به مدیریت اطلاع بدید تا وضعیت کانفیگ را در پنل چک کنند🙏",
                'show_alert' => true
            ]);
            $leftgb = $link_status = $netType = '⚠️';
        }
		
		if($gateways['sublink'] == 1){
        	$subid = getsubid($server_id, $inbound_id, $remark);
        	if($subid != '' and !is_null($subid) and $subid != '0'){
        		$server_detail = $telegram->db->query("SELECT * FROM server_info WHERE id=$server_id")->fetch(2);
        		$sublink = $server_detail['sublink']."/sub/$subid";
        	}
        }
		
		$sres = $telegram->db->query("select * from fl_server WHERE id=$server_id")->fetch(2);
        $stitle = $sres['title'];
        $flag = $sres['flag'];
        $msg = "✅ $name \n🌐 $stitle $flag \n📝 $date \n🌟 $link_status \n🔗 $remark \n <code>$acc_link</code>";
		if($sublink) {
            $msg .= "\n \n لینک سابسکریپشن : \n <code>$sublink</code>";
        }

if($inbound_id == 0){
    if($protocol == 'trojan') {
        $keyboard = [
			[['text' => "🔄 تغییر لینک و قطع دسترسی دیگران", 'callback_data' => "unrqewlink#$id"]],
			[
                ['text' => "🧩 کیو آر کد", 'callback_data' => "qrcode#$id"],
				['text' => "⚡️ بروزرسانی لینک", 'callback_data' => "unewlink#$id"],
            ],
            [
                ['text' =>  $total == 0 ? "حجم نامحدود" : " $leftgb حجم باقیمانده", 'callback_data' => "leftgb#$total#$up#$down"],
                ['text' => $netType. " نوع شبکه ", 'callback_data' => "trjntchange"],
            ],
            [
                ['text' => " انقضا ⏰ ". $expire_date, 'callback_data' => "n2othin43g"],
            ],
            [
                ['text' => "👇پروتکل📡", 'callback_data' => "not64hin3g"],
            ],
            [
                ['text' => $protocol == 'trojan' ? '✅trojan' : 'trojan', 'callback_data' => "chngprotocol#$fid#$id#trojan"],
                ['text' => $protocol == 'vmess' ? '✅vmess' : 'vmess', 'callback_data' => "chngprotocol#$fid#$id#vmess"],
                ['text' => $protocol == 'vless' ? '✅vless' : 'vless', 'callback_data' => "chngprotocol#$fid#$id#vless"],
            ],
            [
                ['text' => '♻ تمدید سرویس', 'callback_data' => "renewacc#$id" ],
                ['text' => '🔌تغییر لوکیشن', 'callback_data' => "switchserv#$id#$server_id#$leftgb#".$order['expire_date'] ],
            ],
            
        ];
    }else {
        $keyboard = [
			[['text' => "🔄 تغییر لینک و قطع دسترسی دیگران", 'callback_data' => "unrqewlink#$id"]],
			[
                ['text' => "🧩 کیو آر کد", 'callback_data' => "qrcode#$id"],
				['text' => "⚡️ بروزرسانی لینک", 'callback_data' => "unewlink#$id"],
            ],
            [
                
                ['text' =>  $total == 0 ? "حجم نامحدود" : " $leftgb حجم باقیمانده", 'callback_data' => "leftgb#$total#$up#$down"],
                ['text' => $netType. " نوع شبکه ", 'callback_data' => "chngnetType#$fid#$id"],
            ],
            [
                ['text' => " انقضا ⏰ ". $expire_date, 'callback_data' => "not567856hing"],
            ],
            [
                ['text' => " پروتکل📡", 'callback_data' => "not2312hing"],
            ],
            [
                ['text' => $protocol == 'trojan' ? '✅trojan' : 'trojan', 'callback_data' => "chngprotocol#$fid#$id#trojan"],
                ['text' => $protocol == 'vmess' ? '✅vmess' : 'vmess', 'callback_data' => "chngprotocol#$fid#$id#vmess"],
                ['text' => $protocol == 'vless' ? '✅vless' : 'vless', 'callback_data' => "chngprotocol#$fid#$id#vless"],
            ],
            [
                ['text' => '♻ تمدید سرویس', 'callback_data' => "renewacc#$id" ],
                ['text' => '🔌تغییر لوکیشن', 'callback_data' => "switchserv#$id#$server_id#$leftgb#".$order['expire_date'] ],
            ],
            
        ];
    }
}else{ // inbound
    $keyboard = [
		[['text' => "🔄 تغییر لینک و قطع دسترسی دیگران", 'callback_data' => "unrqewlink#$id"]],
		[
			['text' => "🧩 کیو آر کد", 'callback_data' => "qrcode#$id"],
			['text' => "⚡️ بروزرسانی لینک", 'callback_data' => "unewlink#$id"],
		],
        [
            
            ['text' =>  $total == 0 ? "حجم نامحدود" : " $leftgb حجم باقیمانده", 'callback_data' => "leftgb#$total#$up#$down"],
            ['text' => $netType. " نوع شبکه ", 'callback_data' => "4nothi5ng"],
        ],
        [
            ['text' => " انقضا ⏰ ". $expire_date, 'callback_data' => "n4oth4ing"],
        ],
        [
            ['text' => " $protocol پروتکل📡", 'callback_data' => "nroth6ing"],
        ],
		[
			['text' => '♻ تمدید سرویس', 'callback_data' => "renewacc#$id" ],
			['text' => '🔌تغییر لوکیشن', 'callback_data' => "switchserv#$id#$server_id#$leftgb#".$order['expire_date'] ],
		],
    ];
}
if($protocol == 'shadowsocks') {
    $keyboard = [
		[['text' => "🔄 تغییر لینک و قطع دسترسی دیگران", 'callback_data' => "unrqewlink#$id"]],
		[
            ['text' => "🧩 کیو آر کد", 'callback_data' => "qrcode#$id"],
			['text' => "⚡️ بروزرسانی لینک", 'callback_data' => "unewlink#$id"],
        ],
        [
            ['text' => " $leftgb حجم باقیمانده", 'callback_data' => "leftgb#$total#$up#$down"],
            ['text' => $netType. " نوع شبکه ", 'callback_data' => "trjntchange"],
        ],
        [
            ['text' => " انقضا ⏰ ". $expire_date, 'callback_data' => "n2othin43g"],
        ],
        [
            ['text' => "👇پروتکل📡", 'callback_data' => "not64hin3g"],
        ],
        [
            ['text' => '✅shadowsocks' ,'callback_data' => "sdjwo23odf"],
        ],
        [
            ['text' => '♻ تمدید سرویس', 'callback_data' => "renewacc#$id" ],
            ['text' => '🔌تغییر لوکیشن', 'callback_data' => "switchserv#$id#$server_id#$leftgb#".$order['expire_date'] ],
        ],
        
    ];
}
        $server_info = $telegram->db->query("select * from fl_server WHERE id=$server_id")->fetch(2);
        $extrakey = [];
        if($gateways['buy_gb'] == 1) $extrakey[] = ['text' => "📥افزایش حجم سرویس", 'callback_data' => "upmysrvice#$server_id#$inbound_id#$remark"];
        if($gateways['buy_day'] == 1) $extrakey[] = ['text' => "افزایش زمان سرویس✨", 'callback_data' => "relinsrvc#$server_id#$inbound_id#$remark"];
        if($order['amount'] != 0 ) $keyboard[] = $extrakey;
		
		if($gateways['refund_service'] == 1 and is_numeric($total)) $keyboard[] = [['text' => "💵عودت سرویس", 'callback_data' => "refundusrv#$id#$total#$leftgb#$orginal_days#$left_days"]];
        $keyboard[] = [['text' => "↪ برگشت", 'callback_data' => "backto"],['text' => "❌حذف سرویس", 'callback_data' => "dlusmysv#$id"]];
            
           $aa = bot('editmessageText', [
                'chat_id' => $userid,
                'message_id' => $cmsgid,
                'parse_mode' => "HTML",
                'text' => $msg,
                'reply_markup' => json_encode([
                    'inline_keyboard' => $keyboard
                ])
            ]);
        }
    
}
if(preg_match('/refundusrv/', $cdata)){
    $input = explode('#', $cdata);
    $id = $input[1];
    $total = $input[2] / 1073741824;
    $leftgb = str_replace(' GB', '', $input[3]);
    $orginal_days = $input[4];
    $left_days = $input[5];
    
	if($orginal_days == 0){
        bot('answercallbackquery', [
    		'callback_query_id' => $cid,
    		'text' => "⚠️امکان عودت برای این سرویس وجود ندارد",
    		'show_alert' => true
    	]);
    	exit;
    }
    if($total - $leftgb >= $refund_gb || $orginal_days - $left_days > $refund_day){
        bot('answercallbackquery', [
    		'callback_query_id' => $cid,
    		'text' => "⚠️امکان عودت سرویس تا $refund_day روز بعد خرید یا مصرف بیشتر از $refund_gb گیگ ممکن نیست",
    		'show_alert' => true
    	]);
    	exit;
    }
    $order = $telegram->db->query("SELECT * FROM `fl_order` WHERE id=$id")->fetch(2);
    $price = $order['amount'];
	//$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
	//if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
    $price = number_format($price);

    $keyboard = [[['text' => "☑انصراف", 'callback_data' => "ordetail#$id"],['text' => "✅تایید", 'callback_data' => "refundsrv#$id#$total#$leftgb#$orginal_days#$left_days"]]];
    
    bot('editmessageText', [
        'chat_id' => $userid,
        'message_id' => $cmsgid,
        'parse_mode' => "HTML",
        'text' => "⚠️بعد از انتخاب گزینه تایید, لینک بطور کامل قطع و مبلغ $price تومان به کیف پول شما عودت می شود",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]); 
}
if(preg_match('/refundsrv/', $cdata)){
    $input = explode('#', $cdata);
    $id = $input[1];
    $total = $input[2] / 1073741824;
    $leftgb = str_replace(' GB', '', $input[3]);
    $orginal_days = $input[4];
    $left_days = $input[5];
    
    if($total - $leftgb >= $refund_gb || $orginal_days - $left_days > $refund_day){
        bot('answercallbackquery', [
    		'callback_query_id' => $cid,
    		'text' => "⚠️امکان عودت سرویس تا $refund_day روز بعد خرید یا مصرف بیشتر از $refund_gb گیگ ممکن نیست",
    		'show_alert' => true
    	]);
    	exit;
    }
    $order = $telegram->db->query("SELECT * FROM `fl_order` WHERE id=$id")->fetch(2);
    $remark = $order['remark'];
    $userid = $order['userid'];
    $protocol = $order['protocol'];
    $server_id = $order['server_id'];
    $inbound_id = $order['inbound_id'];
    $amount = $order['amount'];
    //$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
	//if(!empty($seller)) $amount = $amount - (($amount) * ($seller['percent'] / 100));
    $price = number_format($amount). ' تومان ';
    
    require_once('vray.php');
    if($inbound_id > 0) {
       $response = remove_client($server_id, $inbound_id, $remark, 1);
    }else{
        $response = remove_inbound($server_id, $remark, 1);
    }
    $telegram->db->query("DELETE FROM `fl_order` WHERE id=$id");
    $telegram->db->query("update fl_user set wallet = wallet + $amount WHERE userid='$userid'");
   bot('editmessageText', [
        'chat_id' => $userid,
        'message_id' => $cmsgid,
        'parse_mode' => "HTML",
        'text' => "💵 سرویس $remark با موفقیت حذف و مبلغ $price به کیف پول شما اضافه شد",
    ]); 
    
    $userdetail = $telegram->db->query("SELECT * FROM `fl_user` WHERE id='$userid' ")->fetch(2);
    $name = $userdetail['name'];
$sndmsg = "
عودت سرویس $remark 
قیمت : $price
نام کاربر : $name
آیدی سرور : $server_id
";
    $telegram->sendMessage($sendchnl,$sndmsg);
}
if(preg_match('/leftgb/', $cdata)){
    $input = explode('#',$cdata);
    $total = $input[1];
    $up = $input[2];
    $down = $input[3];
    $leftgb = format_volume($total - $up - $down, 2);
    $totalvolume = format_volume($total);
    $up =  format_volume($up);
    $down = format_volume($down);
    bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "🔹 $leftgb حجم باقیمانده \n 🔺 $down دانلود \n 🔻 $up آپلود ",
            'show_alert' => true
        ]);
        exit;
}
if(preg_match('/qrcode/',$cdata)){
    $input = explode('#',$cdata);
    $oid = $input[1];
	$order = $telegram->db->query("SELECT * FROM `fl_order` WHERE id=$oid")->fetch(2);
	$acc_link = $order['link'];
	$remark = $order['link'];
	$inbound_id = $order['inbound_id'];
	$server_id = $order['server_id'];
	
	include_once 'phpqrcode/qrlib.php';
    $path = 'images/';
    $ecc = 'L';
    $pixel_Size = 10;
    $frame_Size = 5;
	
	if($gateways['sublink'] == 1){
		include_once 'vray.php';
    	$subid = getsubid($server_id, $inbound_id, $remark);
    	if($subid != '' and !is_null($subid) and $subid != '0'){
    		$server_detail = $telegram->db->query("SELECT * FROM server_info WHERE id=$server_id")->fetch(2);
    		$sublink = $server_detail['sublink']."/sub/$subid";
    	}
    }
    if(!is_null($sublink)) {
		$file = $path.$userid.rand(0,999999).time().".png";
		QRcode::png($sublink, $file, $ecc, $pixel_Size, $frame_Size);
	
		$telegram->sendPhoto($userid,'Sublink',$file);
	}
	
	$file = $path.$userid.rand(0,999999).time().".png";
    QRcode::png($acc_link, $file, $ecc, $pixel_Size, $frame_Size);
	$telegram->sendPhoto($userid,'QrCode',$file);
}
/* end here */
/* up my service */
if(preg_match('/upmysrvice/', $cdata)){
	if($gateways['buy_gb'] == 0){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻در حال حاضر امکان افزایش حجم نیست',
            'show_alert' => true
        ]);
        exit;
    }
    $input = explode('#',$cdata);
    $cdata = str_replace('upmysrvice#','',$cdata);
    $res = $telegram->db->query("select * from extra_plan")->fetchAll(2);
    if(empty($res)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "در حال حاضر هیچ پلن حجمی وجود ندارد",
            'show_alert' => false
        ]);
        exit;
    }
    $keyboard = [];
    foreach($res as $cat){
        $id = $cat['id'];
        $title = $cat['volume'];
		$price = $cat['price'];
		$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
		if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
	
        $price = number_format($price);
        $keyboard[] = ['text' => "$title گیگ $price تومان", 'callback_data' => "buuygbplan#$cdata#$id"];
    }
    $keyboard = array_chunk($keyboard,2);
    //$keyboard[] = [['text' => "↪ برگشت", 'callback_data' => "ordetail#$oid"]];
    bot('sendmessage', [ // editmessageText
        'chat_id' => $userid,
        //'message_id' => $cmsgid,
        'parse_mode' => "HTML",
        'text' => "لطفا یکی از پلن های حجمی را انتخاب کنید :",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}
if(preg_match('/buuygbplan/',$cdata)){
    $input = explode('#', $cdata);
    $cdata = str_replace('buuygbplan#','',$cdata);
    $pid = $input[4];
    $res = $telegram->db->query("select * from extra_plan where id=$pid")->fetch(2);
    $planprice = $res['price'];
    $plangb = $res['volume'];
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
	if(!empty($seller)) $planprice = $planprice - (($planprice) * ($seller['percent'] / 100));
    
    //$deldate = $time + $timewaitdel;
    //$telegram->db->query("insert into pay_messages values (null, '$cmsgid', '$userid', '$deldate')");

    $token = base64_encode($cdata."#$userid");
	
	
	if($userid == ADMIN or isAdmin()){
		$keyboard[] = [['text' => 'فعالسازی رایگان', 'callback_data' => "walvpay#$cdata"]];
	}else{
		if($gateways['zibal']) $keyboard[] = [['text' => "پرداخت آنلاین - $planprice تومان", 'url' => baseURI."zibal.php?type=volume&action=pay&token=$token"]];
		if($gateways['novino']) $keyboard[] = [['text' => "پرداخت آنلاین - $planprice تومان", 'url' => baseURI."nvpayment.php?type=volume&action=pay&token=$token"]];
		if($gateways['payping']) $keyboard[] = [['text' => "پرداخت آنلاین2 - $planprice تومان", 'url' => baseURI."payping.php?type=volume&token=$token"]];
		if($gateways['bahamta']) $keyboard[] = [['text' => "پرداخت آنلاین - $planprice تومان", 'url' => baseURI."bahamta.php?type=volume&action=pay&token=$token"]];
		if($gateways['zarin']) $keyboard[] = [['text' => "پرداخت زرین پال - $planprice تومان", 'url' => baseURI."/volume/pay.php?token=$token"]];
		//if($gateways['next']) $keyboard[] = [['text' => "پرداخت نکست پی - $price تومان", 'url' => baseURI."/volume/nextpay/pay.php?token=$token"]];
		if($gateways['wallet']) $keyboard[] = [['text' => '🏅 پرداخت با کیف پول', 'callback_data' => "walvpay#$cdata"]];
		if($gateways['card']) $keyboard[] = [['text' => "کارت به کارت - $planprice تومان",  'callback_data' => "offvpay#$cdata"]];
	}

    bot('editMessageText', [
        'chat_id' => $cuserid,
        'message_id' => $cmsgid,
        'parse_mode' => "HTML",
        'text' => "لطفا با یکی از روش های زیر پرداخت خود را تکمیل کنید :",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}
if(preg_match('/offvpay/',$cdata) and !preg_match('/offvpay/',$state)) {
    file_put_contents("state/$userid.txt",$cdata);
    $telegram->sendHTML($userid,"لطفا تصویر فیش واریزی یا شماره پیگیری -  ساعت پرداخت - نام پرداخت کننده را در یک پیام ارسال کنید
🔸$cardinfo",$cancelop);
    exit;
}
if(preg_match('/offvpay/',$state) and $text != '❌ انصراف' and !$cdata){
	bot('deleteMessage', ['chat_id' => $userid,'message_id' => $msgid -1]);
	if(!isset($result->message->photo)){
	    $telegram->sendMessage($userid, "⚠️لطفا فیش واریزی را فقط بصورت عکس ارسال کنید");exit;
	}
    file_put_contents("state/$userid.txt","");
    $input = explode('#',$state); 
    $server_id = $input[1];
    $inbound_id = $input[2];
    $remark = $input[3];
    $planid = $input[4]; //$telegram->sendMessage($userid,"se\");die;
    $res = $telegram->db->query("select * from extra_plan where id=$planid")->fetch(2); 
    $price = $res['price'];
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
	if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
	
    $volume = $res['volume'];
    $state = str_replace('offvpay#','',$state);
	
	$res = $telegram->db->query("select * from fl_user where userid=$userid")->fetch(2);
    $name = $res['name'];
    $username = $res['username'];
    $tel = $res['tel'];

    $fileurl = $telegram->FileURL($fileid);
    $infoc = strlen($text) > 1 ? $text : "$caption (فیش واریزی در بالای این پیام هست)";
    $msg = "
✅✅درخواست شما با موفقیت ارسال شد
بعد از بررسی و تایید فیش, سرویس شما شارژ می شود.
/start";
    $telegram->sendMessageCURL($userid,$msg,$finalop);
    // notify admin
    $msg = "#$remark
🏷 $volume گیگ حجم سرویس ($price تومان)
✖کد کاربری: $userid
👤نام و نام خانوادگی: $name
📧یوزرنیم: @$username
☎️شماره موبایل : $tel
📝اطلاعات پرداخت کارت به کارت: $infoc
 ";
    $keyboard = json_encode([
        'inline_keyboard' => [
            [
                ['text' => 'تایید پرداخت', 'callback_data' => "enaupble#$state#$userid"],
                ['text' => 'عدم تایید', 'callback_data' => "disable#$userid"]
            ]
        ]
    ]);
	$admins = file_get_contents('admins.php');
    $list = explode(PHP_EOL,$admins);
    foreach($list as $admid){
        if(strlen($admid) > 3){
			if($fileid) bot('sendphoto',['chat_id' => $admid, 'caption'=> '','photo' => $fileid]);
            bot('sendmessage',[
                'chat_id' => $admid,
                'text'=> $msg,
                'parse_mode' => 'HTML',
                'reply_markup' => $keyboard
            ]);
        }
    }
	if($fileid) bot('sendphoto',['chat_id' => ADMIN, 'caption'=> '','photo' => $fileid]);
    bot('sendmessage',[
        'chat_id' => ADMIN,
        'text'=> $msg,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}
if(preg_match('/enaupble/',$cdata) and $text != '❌ انصراف'){
    file_put_contents("state/{$userid}.txt","");
    $input = explode('#',$cdata); //$telegram->sendMessage($userid,$cdata);die;
    $server_id = $input[1];
    $inbound_id = $input[2];
    $remark = $input[3];
    $planid = $input[4];
    $uid = $input[5];
    $res = $telegram->db->query("select * from extra_plan where id=$planid")->fetch(2);
    $price = $res['price'];
    $volume = $res['volume'];
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$uid")->fetch(2);
	if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));

    $acctxt = '';
    
    
    require_once('vray.php');
    
    if($inbound_id > 0)
        $response = update_client_traffic($server_id, $inbound_id, $remark, $volume, 0);
    else
        $response = update_inbound_traffic($server_id, $remark, $volume, 0);
    
	if($response->success){
		$telegram->sendMessageCURL($userid,"حجم سرویس کاربر به مقدار $volume گیگ شارژ شد",$finalop);
		$telegram->db->query("update fl_order set notif=0 where remark='$remark'");
		// update button
		bot('editMessageReplyMarkup',[
			'chat_id' => $userid,
			'message_id' => $cmsgid,
			'reply_markup' => json_encode([
				'inline_keyboard' => [[['text' => '✅انجام شد', 'callback_data' => "dontsendanymore"]]],
			])
		]);
        $telegram->sendMessage($uid, "✅$volume گیگ به حجم سرویس شما اضافه شد");
		$telegram->db->query("INSERT INTO `fl_extra_order` VALUES (NULL, '$uid', '$server_id', '$inbound_id', '$remark', '$price', '$time');");
        $user_detail = $telegram->db->query("select * from fl_user WHERE userid=$uid")->fetch(2);
        $uname = $user_detail['name'];
        $user_name = $user_detail['username'];
        $tel = $user_detail['tel'];
        $admins = file_get_contents('admins.php');
        $list = explode(PHP_EOL,$admins);
        foreach($list as $admid){
            if(strlen($admid) > 3 and $admid != $userid){
               $telegram->sendMessage($admid,"✅سفارش کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$remark
🏷افزایش حجم سرویس $remark ($price تومان)
✖کد کاربری: $uid
👤نام و نام خانوادگی: $uname
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
");
        }
    }
    if(ADMIN != $userid) $telegram->sendMessage(ADMIN,"✅سفارش کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$remark
🏷افزایش حجم سرویس $remark ($price تومان)
✖کد کاربری: $uid
👤نام و نام خانوادگی: $uname
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
");
    }else {
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "مشکل فنی در ارتباط با سرور. لطفا سلامت سرور را بررسی کنید",
            'show_alert' => true
        ]);
        exit;
    }
}
if(preg_match('/walvpay/', $cdata)){
    $input = explode('#',$cdata);
    $server_id = $input[1];
    $inbound_id = $input[2];
    $remark = $input[3];
    $planid = $input[4];

    $res = $telegram->db->query("select * from extra_plan where id=$planid")->fetch(2);
    $price = $res['price'];
    $volume = $res['volume'];
	$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
	if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
    
    $userwallet = $telegram->db->query("select wallet from fl_user WHERE userid='$userid'")->fetch(2)['wallet'];
    
    if($userwallet < $price and !($userid == ADMIN or isAdmin())) {
        $needamount = $price - $userwallet;
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "💡موجودی کیف پول (".number_format($userwallet)." تومان) کافی نیست لطفا به مقدار ".number_format($needamount)." تومان شارژ کنید ",
            'show_alert' => true
        ]);
        exit;
    }

    

    require_once('vray.php');
    if($inbound_id > 0)
        $response = update_client_traffic($server_id, $inbound_id, $remark, $volume, 0);
    else
        $response = update_inbound_traffic($server_id, $remark, $volume, 0);
        
    if($response->success){
	    if(!($userid == ADMIN or isAdmin())) $telegram->db->query("update fl_user set wallet = wallet - $price WHERE userid='$userid'");
		$telegram->db->query("update fl_order set notif=0 where remark='$remark'");
		bot('editMessageReplyMarkup',[
			'chat_id' => $userid,
			'message_id' => $cmsgid,
			'reply_markup' => json_encode([
				'inline_keyboard' => [[['text' => '✅انجام شد', 'callback_data' => "dontsendanymore"]]],
			])
		]);
		$sndmsg = "
خرید $volume گیگ با کیف پول
قیمت : $price
آیدی کاربر : $userid
آیدی سرور : $server_id
ریمارک : $remark
";
		$telegram->sendMessage($sendchnl,$sndmsg);
        $telegram->sendMessage($userid, "✅$volume گیگ به حجم سرویس شما اضافه شد");exit;
    }else {
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "به دلیل مشکل فنی امکان افزایش حجم نیست. لطفا به مدیریت اطلاع بدید یا 5دقیقه دیگر دوباره تست کنید",
            'show_alert' => true
        ]);
        exit;
    }
   // $telegram->sendMessage($userid, json_encode($response));exit;
}
/* end up my service */

/* up day */
if(preg_match('/relinsrvc/', $cdata)){
	if($gateways['buy_day'] == 0){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻در حال حاضر امکان خرید روز اضافی نیست',
            'show_alert' => true
        ]);
        exit;
    }
    $input = explode('#',$cdata);
    $cdata = str_replace('relinsrvc#','',$cdata);
    $res = $telegram->db->query("select * from extra_day")->fetchAll(2);
    if(empty($res)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "در حال حاضر هیچ پلنی برای افزایش مدت زمان سرویس وجود ندارد",
            'show_alert' => false
        ]);
        exit;
    }
    $keyboard = [];
    foreach($res as $cat){
        $id = $cat['id'];
        $title = $cat['volume'];
		
		$price = $cat['price'];
		$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
		if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
			
        $price = number_format($price);
        $keyboard[] = ['text' => "$title روز $price تومان", 'callback_data' => "buuydayplan#$cdata#$id"];
    }
    $keyboard = array_chunk($keyboard,2);
    //$keyboard[] = [['text' => "↪ برگشت", 'callback_data' => "ordetail#$oid"]];
    bot('sendmessage', [ // editmessageText
        'chat_id' => $userid,
        //'message_id' => $cmsgid,
        'parse_mode' => "HTML",
        'text' => "لطفا یکی از پلن های افزایشی را انتخاب کنید :",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}
if(preg_match('/buuydayplan/',$cdata)){
    $input = explode('#', $cdata);
    $cdata = str_replace('buuydayplan#','',$cdata);
    $pid = $input[4];
    $res = $telegram->db->query("select * from extra_day where id=$pid")->fetch(2);
    $planprice = $res['price'];
	$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
	if(!empty($seller)) $planprice = $planprice - (($planprice) * ($seller['percent'] / 100));
    
    //$deldate = $time + $timewaitdel;
    //$telegram->db->query("insert into pay_messages values (null, '$cmsgid', '$userid', '$deldate')");

    $token = base64_encode($cdata."#$userid");
	
	
	if($userid == ADMIN or isAdmin()){
		$keyboard[] = [['text' => 'فعالسازی رایگان', 'callback_data' => "waldaypay#$cdata"]];
	}else{
		if($gateways['zibal']) $keyboard[] = [['text' => "پرداخت آنلاین - $planprice تومان", 'url' => baseURI."zibal.php?type=day&action=pay&token=$token"]];
		if($gateways['novino']) $keyboard[] = [['text' => "پرداخت آنلاین - $planprice تومان", 'url' => baseURI."nvpayment.php?type=day&action=pay&token=$token"]];
		if($gateways['payping']) $keyboard[] = [['text' => "پرداخت آنلاین2 - $planprice تومان", 'url' => baseURI."payping.php?type=day&token=$token"]];
		if($gateways['bahamta']) $keyboard[] = [['text' => "پرداخت آنلاین - $planprice تومان", 'url' => baseURI."bahamta.php?type=day&action=pay&token=$token"]];
		if($gateways['zarin']) $keyboard[] = [['text' => "پرداخت زرین پال - $planprice تومان", 'url' => baseURI."/day/pay.php?token=$token"]];
		//if($gateways['next']) $keyboard[] = [['text' => "پرداخت نکست پی - $price تومان", 'url' => baseURI."/day/nextpay/pay.php?token=$token"]];
		if($gateways['wallet']) $keyboard[] = [['text' => '🏅 پرداخت با کیف پول', 'callback_data' => "waldaypay#$cdata"]];
		if($gateways['card']) $keyboard[] = [['text' => "کارت به کارت - $planprice تومان",  'callback_data' => "offdaypay#$cdata"]];
	}

    bot('editMessageText', [
        'chat_id' => $cuserid,
        'message_id' => $cmsgid,
        'parse_mode' => "HTML",
        'text' => "لطفا با یکی از روش های زیر پرداخت خود را تکمیل کنید :",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}
if(preg_match('/offdaypay/',$cdata) and !preg_match('/offdaypay/',$state)) {
    file_put_contents("state/$userid.txt",$cdata);
    $telegram->sendHTML($userid,"لطفا تصویر فیش واریزی یا شماره پیگیری -  ساعت پرداخت - نام پرداخت کننده را در یک پیام ارسال کنید
🔸$cardinfo",$cancelop);
    exit;
}
if(preg_match('/offdaypay/',$state) and $text != '❌ انصراف' and !$cdata){
	bot('deleteMessage', ['chat_id' => $userid,'message_id' => $msgid -1]);
	if(!isset($result->message->photo)){
	    $telegram->sendMessage($userid, "⚠️لطفا فیش واریزی را فقط بصورت عکس ارسال کنید");exit;
	}
    file_put_contents("state/$userid.txt","");
    $input = explode('#',$state); 
    $server_id = $input[1];
    $inbound_id = $input[2];
    $remark = $input[3];
    $planid = $input[4]; //$telegram->sendMessage($userid,"se\");die;
    $res = $telegram->db->query("select * from extra_day where id=$planid")->fetch(2); 
    $price = $res['price'];
	$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
            if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
    $volume = $res['volume'];
    $state = str_replace('offdaypay#','',$state);

	$res = $telegram->db->query("select * from fl_user where userid=$userid")->fetch(2);
    $name = $res['name'];
    $username = $res['username'];
    $tel = $res['tel'];
    $fileurl = $telegram->FileURL($fileid);
    $infoc = strlen($text) > 1 ? $text : "$caption (فیش واریزی در بالای این پیام هست)";
    $msg = "
✅✅درخواست شما با موفقیت ارسال شد
بعد از بررسی و تایید فیش, از طریق ربات اطلاع رسانی می شود.
/start";
    $telegram->sendMessageCURL($userid,$msg,$finalop);
    // notify admin
    $msg = "#$remark
🏷 $volume روز افزایشی سرویس ($price تومان)
✖کد کاربری: $userid
👤نام و نام خانوادگی: $name
📧یوزرنیم: @$username
☎️شماره موبایل : $tel
📝اطلاعات پرداخت کارت به کارت: $infoc
 ";
    $keyboard = json_encode([
        'inline_keyboard' => [
            [
                ['text' => 'تایید پرداخت', 'callback_data' => "enadayble#$state#$userid"],
                ['text' => 'عدم تایید', 'callback_data' => "disable#$userid"]
            ]
        ]
    ]);
	$admins = file_get_contents('admins.php');
    $list = explode(PHP_EOL,$admins);
    foreach($list as $admid){
        if(strlen($admid) > 3){
			if($fileid) bot('sendphoto',['chat_id' => $admid, 'caption'=> '','photo' => $fileid]);
            bot('sendmessage',[
                'chat_id' => $admid,
                'text'=> $msg,
                'parse_mode' => 'HTML',
                'reply_markup' => $keyboard
            ]);
        }
    }
	if($fileid) bot('sendphoto',['chat_id' => ADMIN, 'caption'=> '','photo' => $fileid]);
    bot('sendmessage',[
        'chat_id' => ADMIN,
        'text'=> $msg,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}
if(preg_match('/enadayble/',$cdata) and $text != '❌ انصراف'){
    file_put_contents("state/{$userid}.txt","");
    $input = explode('#',$cdata); //$telegram->sendMessage($userid,$cdata);die;
    $server_id = $input[1];
    $inbound_id = $input[2];
    $remark = $input[3];
    $planid = $input[4];
    $uid = $input[5];
    $res = $telegram->db->query("select * from extra_day where id=$planid")->fetch(2);
    $price = $res['price'];
    $volume = $res['volume'];
	$seller = $telegram->db->query("select * from fl_sellers where userid=$uid")->fetch(2);
            if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));

    $acctxt = '';
    
    
    require_once('vray.php');
    if($inbound_id > 0)
        $response = update_client_traffic($server_id, $inbound_id, $remark, 0, $volume);
    else
        $response = update_inbound_traffic($server_id, $remark, 0, $volume);
    
	if($response->success){
		$telegram->sendMessageCURL($userid,"مدت زمان سرویس کاربر به مقدار $volume روز شارژ شد",$finalop);
        $telegram->db->query("update fl_order set notif=0 where remark='$remark'");
        $telegram->db->query("INSERT INTO `fl_extra_order` VALUES (NULL, '$uid', '$server_id', '$inbound_id', '$remark', '$price', '$time');");
		// update button
		bot('editMessageReplyMarkup',[
			'chat_id' => $userid,
			'message_id' => $cmsgid,
			'reply_markup' => json_encode([
				'inline_keyboard' => [[['text' => '✅انجام شد', 'callback_data' => "dontsendanymore"]]],
			])
		]);
        $telegram->sendMessage($uid, "✅$volume روز به مدت زمان سرویس شما اضافه شد");
		$user_detail = $telegram->db->query("select * from fl_user WHERE userid=$uid")->fetch(2);
        $uname = $user_detail['name'];
        $user_name = $user_detail['username'];
        $tel = $user_detail['tel'];
        $admins = file_get_contents('admins.php');
        $list = explode(PHP_EOL,$admins);
        foreach($list as $admid){
            if(strlen($admid) > 3 and $admid != $userid){
               $telegram->sendMessage($admid,"✅سفارش کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$remark
🏷افزایش روز سرویس $remark ($price تومان)
✖کد کاربری: $uid
👤نام و نام خانوادگی: $uname
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
");
        }
    }
    if(ADMIN != $userid) $telegram->sendMessage(ADMIN,"✅سفارش کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$remark
🏷 تمدید سرویس $remark ($price تومان)
✖کد کاربری: $uid
👤نام و نام خانوادگی: $uname
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
");
    }else {
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "مشکل فنی در ارتباط با سرور. لطفا سلامت سرور را بررسی کنید",
            'show_alert' => true
        ]);
        exit;
    }
}
if(preg_match('/waldaypay/', $cdata)){
    $input = explode('#',$cdata);
    $server_id = $input[1];
    $inbound_id = $input[2];
    $remark = $input[3];
    $planid = $input[4];


    $res = $telegram->db->query("select * from extra_day where id=$planid")->fetch(2);
    $price = $res['price'];
	$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
            if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
    $volume = $res['volume'];
    $userwallet = $telegram->db->query("select wallet from fl_user WHERE userid='$userid'")->fetch(2)['wallet'];
    
    if($userwallet < $price and !($userid == ADMIN or isAdmin())) {
        $needamount = $price - $userwallet;
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "💡موجودی کیف پول (".number_format($userwallet)." تومان) کافی نیست لطفا به مقدار ".number_format($needamount)." تومان شارژ کنید ",
            'show_alert' => true
        ]);
        exit;
    }

    

    require_once('vray.php');
    if($inbound_id > 0)
        $response = update_client_traffic($server_id, $inbound_id, $remark, 0, $volume);
    else
        $response = update_inbound_traffic($server_id, $remark, 0, $volume);
        
    if($response->success){
        $telegram->db->query("update fl_order set notif=0 where remark='$remark'");
        $telegram->db->query("INSERT INTO `fl_extra_order` VALUES (NULL, '$userid', '$server_id', '$inbound_id', '$remark', '$price', '$time');");
	    if(!($userid == ADMIN or isAdmin())) $telegram->db->query("update fl_user set wallet = wallet - $price WHERE userid='$userid'");
		bot('editMessageReplyMarkup',[
			'chat_id' => $userid,
			'message_id' => $cmsgid,
			'reply_markup' => json_encode([
				'inline_keyboard' => [[['text' => '✅انجام شد', 'callback_data' => "dontsendanymore"]]],
			])
		]);
		$sndmsg = "
خرید $volume روز با کیف پول
قیمت : $price
آیدی کاربر : $userid
آیدی سرور : $server_id
ریمارک : $remark
";
    $telegram->sendMessage($sendchnl,$sndmsg);
        $telegram->sendMessage($userid, "✅$volume روز به مدت زمان سرویس شما اضافه شد");exit;
    }else {
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "به دلیل مشکل فنی امکان افزایش حجم نیست. لطفا به مدیریت اطلاع بدید یا 5دقیقه دیگر دوباره تست کنید",
            'show_alert' => true
        ]);
        exit;
    }
   // $telegram->sendMessage($userid, json_encode($response));exit;
}
/* end up day */


if($cdata == 'trjntchange'){
    bot('answercallbackquery', [
        'callback_query_id' => $cid,
        'text' => "پروتکل تروجان فقط نوع شبکه TCP را دارد",
        'show_alert' => false
    ]);exit;
}
if(preg_match('/renewacc/',$cdata)){
	if($gateways['renew'] == 0){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻در حال حاضر تمدید غیرفعال است و بزودی فعال می کنیم',
            'show_alert' => true
        ]);
        exit;
    }
    $oid = str_replace('renewacc#','',$cdata);
    $order = $telegram->db->query("select * from fl_order where id=$oid")->fetch(2);
    $sid = $order['server_id'];
    
    $srvinfo = $telegram->db->query("select * from server_info where id='$sid'")->fetch(2);
    if($srvinfo['renew'] == 0){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '⚠️امکان تمدید سرویس نیست و این سرور تکمیل ظرفیت شده است. لطفا سرویس جدید تهیه بفرمایید',
            'show_alert' => true
        ]);
        exit;
    }
    
    $respd = $telegram->db->query("select * from fl_cat WHERE parent=0 and title Not Like '%تست%' order by id asc")->fetchAll(2);
    if(empty($respd)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "هیچ دسته بندی برای این سرویس وجود ندارد",
            'show_alert' => false
        ]);
    }else{
        $keyboard = [];
        foreach($respd as $cat){
            $id = $cat['id'];
            $name = $cat['title'];
            $rowcount = $telegram->db->query("select * from fl_file WHERE server_id='$sid' and price > 0 and catid=$id and (inbound_id > 0 and acount > 0 or inbound_id = 0) and active=1")->rowCount();
            if($rowcount) $keyboard[] = ['text' => "$name", 'callback_data' => "rene1wacc#$id#$oid"];
        }
        if(empty($keyboard)){
            bot('answercallbackquery', [
                'callback_query_id' => $cid,
                'text' => "پلن های سرویس تکمیل ظرفیت شد",
                'show_alert' => false
            ]);exit;
        }
        $keyboard[] = ['text' => '🔙 بازگشت', 'callback_data' => "ordetail#$oid"];
        $keyboard = array_chunk($keyboard,1);
        bot('editMessageText', [
            'chat_id' => $cuserid,
            'message_id' => $cmsgid,
            'text' => "🔰 یکی از موارد زیر را انتخاب کنید تا لیست سرویس ها نمایش داده شود👈",
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }
}
if(preg_match('/rene1wacc/',$cdata)){
	if($gateways['renew'] == 0){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻در حال حاضر تمدید غیرفعال است و بزودی فعال می کنیم',
            'show_alert' => true
        ]);
        exit;
    }
    $input = explode('#', $cdata);
    $catid = $input[1];
    $oid = $input[2];
    
    $order = $telegram->db->query("select * from fl_order where id='$oid'")->fetch(2);
    $sid = $order['server_id'];

    $respd = $telegram->db->query("select * from fl_file WHERE catid='$catid' and server_id='$sid' and price > 0 and active=1 order by id asc")->fetchAll(2);
    if(empty($respd)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "💡پلنی برای تمدید وجود ندارد ",
            'show_alert' => false
        ]);
    }else{
        $keyboard = [];
        foreach($respd as $file){
            $id = $file['id'];
            $name = $file['title'];
            $price = $file['price'];
			$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
			if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
            $price = number_format($price).' تومان ';
            $keyboard[] = ['text' => "$name - $price", 'callback_data' => "re2newacc#$id#$oid"];
        }
        $keyboard[] = ['text' => '🔙 بازگشت', 'callback_data' => "renewacc#$oid"];
        $keyboard = array_chunk($keyboard,1);
        bot('editMessageText', [
            'chat_id' => $cuserid,
            'message_id' => $cmsgid,
            'text' => "🔰 یکی از پلن ها را برای تمدید انتخاب کنید👈
⚠️ با تمدید اکانت حجم و زمان انقضای باقیمانده از اول محاسبه می شود و امکان جمع آن با سرویس تمدید نیست.
✔️اگر فقط حجم یا زمان سرویس به پایان رسیده می توانید از دکمه های افزایش زمان/حجم سرویس هر یک را جداگانه شارژ کنید
",
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }
}
if(preg_match('/re2newacc/',$cdata)){
    if($gateways['renew'] == 0){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻در حال حاضر تمدید غیرفعال است و بزودی فعال می کنیم',
            'show_alert' => true
        ]);
        exit;
    }
    $input = explode('#',$cdata);
    $fid = $input[1];
    $oid = $input[2];
    $respd = $telegram->db->query("select * from fl_file WHERE id='$fid' and active=1")->fetch(2);
    $price = $respd['price'];
	$catid = $respd['catid'];
	$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
	if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
	
	if($price == 0){
		bot('answercallbackquery', [
			'callback_query_id' => $cid,
			'text' => "امکان تمدید کانفیگ تست وجود ندارد",
			'show_alert' => false
		]);exit;
	}
    
    $telegram->db->query("update fl_order set fileid=$fid where id=$oid");

    $token = base64_encode("$userid#$fid#$oid");
	
	if($userid == ADMIN or isAdmin()){
		$keyboard[] = [['text' => 'فعالسازی رایگان', 'callback_data' => "walrnwpay#$fid#$oid"]];
	}else{
		if($gateways['zibal']) $keyboard[] = [['text' => "پرداخت آنلاین - $price تومان", 'url' => baseURI."zibal.php?type=renew&action=pay&token=$token"]];
		if($gateways['novino']) $keyboard[] = [['text' => "پرداخت آنلاین - $price تومان", 'url' => baseURI."nvpayment.php?type=renew&action=pay&token=$token"]];
		if($gateways['payping']) $keyboard[] = [['text' => "پرداخت آنلاین2 - $price تومان", 'url' => baseURI."payping.php?type=renew&token=$token"]];
		if($gateways['bahamta']) $keyboard[] = [['text' => "پرداخت آنلاین - $price تومان", 'url' => baseURI."bahamta.php?type=renew&action=pay&token=$token"]];
		if($gateways['zarin']) $keyboard[] = [['text' => "پرداخت زرین پال - $price تومان", 'url' => baseURI."/renew/pay.php?token=$token"]];
		if($gateways['next']) $keyboard[] = [['text' => "پرداخت نکست پی - $price تومان", 'url' => baseURI."/renew/nextpay/pay.php?token=$token"]];
		if($gateways['card']) $keyboard[] = [['text' => "کارت به کارت - $price تومان",  'callback_data' => "offrnwpay#$fid#$oid"]];
		if($gateways['wallet']) $keyboard[] = [['text' => '🏅 پرداخت با کیف پول', 'callback_data' => "walrnwpay#$fid#$oid"]];
		
		$dcount = $telegram->db->query("select * from fl_discount WHERE active=1 and count > 0 ")->rowCount();
		if($dcount > 0 and empty($seller)){
			$keyboard[] = [['text' => '🔸کد تخفیف دارید؟ بزنید ', 'callback_data' => "submitRNdiscount#$oid"]];
		}
	}
	
	
    $keyboard[] = [['text' => '🔙 بازگشت', 'callback_data' => "rene1wacc#$catid#$oid"]];


    bot('editMessageText', [
        'chat_id' => $cuserid,
        'message_id' => $cmsgid,
        'parse_mode' => "HTML",
        'text' => "لطفا با یکی از روش های زیر اکانت خود را تمدید کنید :",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}
if(preg_match('/offrnwpay/',$cdata) and !preg_match('/offrnwpay/',$state)) {
    file_put_contents("state/$userid.txt",$cdata);
    $telegram->sendHTML($userid,"لطفا تصویر فیش واریزی یا شماره پیگیری -  ساعت پرداخت - نام پرداخت کننده را در یک پیام ارسال کنید
🔸$cardinfo",$cancelop);
    exit;
}
if(preg_match('/offrnwpay/',$state) and $text != '❌ انصراف' and !$cdata){
	bot('deleteMessage', ['chat_id' => $userid,'message_id' => $msgid -1]);
	if(!isset($result->message->photo)){
	    $telegram->sendMessage($userid, "⚠️لطفا فیش واریزی را فقط بصورت عکس ارسال کنید");exit;
	}
    file_put_contents("state/$userid.txt","");
    $input = explode('#',$state);
    $fid = $input[1];
    $oid = $input[2];
    $order = $telegram->db->query("select * from fl_order where id=$oid")->fetch(2);
    $remark = $order['remark'];
    $uid = $order['userid'];
    $userinfo = $telegram->db->query("select * from fl_user WHERE userid='$uid'")->fetch(2);
    $userName = $userinfo['username'];
    $tel = $userinfo['tel'];
    $uname = $userinfo['name'];
    
    $respd = $telegram->db->query("select * from fl_file WHERE id='$fid' and active=1")->fetch(2);
    $price = $respd['price'];
	$ptitle = $respd['title'];
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
        if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
	
	if(isset($input[3])){
		$dcode = htmlspecialchars(strip_tags($input[3]));
		$dcount = $telegram->db->query("select * from fl_discount WHERE code='$dcode' and active=1 and count > 0 ");
        if($dcount->rowCount() > 0){
            $dres = $dcount->fetch(2);
            $amount = $dres['amount'];
            if($amount <= 100) {
                $price = $price * (100-$amount)/100;
            }else {
                $price = $price - $amount ;
            }
            if($dres['count'] != '') $telegram->db->query("update fl_discount set count= count - 1 WHERE code='$dcode'");
        }
	}

    $fileurl = $telegram->FileURL($fileid);
    $infoc = strlen($text) > 1 ? $text : "$caption (فیش واریزی در بالای این پیام هست)";
    $msg = "
✅✅درخواست شما با موفقیت ارسال شد
بعد بررسی و تایید فیش, سرویس شما تمدید و از طریق ربات اطلاع می دهیم.
/start";
    $telegram->sendMessageCURL($userid,$msg,$finalop);
    // notify admin
    $msg = "
🏷 تمدید سرویس $remark ($price تومان)
📌پلن: $ptitle
✖کد کاربری: $uid
👤نام و نام خانوادگی: $uname
📧یوزرنیم: @$userName
☎️شماره موبایل : $tel
📝اطلاعات پرداخت کارت به کارت: $infoc
 ";
    $keyboard = json_encode([
        'inline_keyboard' => [
            [
                ['text' => 'تایید پرداخت', 'callback_data' => (isset($input[3])) ? "enarenwble#$userid#$fid#$oid#".$input[3] : "enarenwble#$userid#$fid#$oid"],
                ['text' => 'عدم تایید', 'callback_data' => "disable#$uid"]
            ]
        ]
    ]);
	$admins = file_get_contents('admins.php');
    $list = explode(PHP_EOL,$admins);
    foreach($list as $admid){
        if(strlen($admid) > 3){
			if($fileid) bot('sendphoto',['chat_id' => $admid, 'caption'=> '','photo' => $fileid]);
            bot('sendmessage',[
                'chat_id' => $admid,
                'text'=> $msg,
                'parse_mode' => 'HTML',
                'reply_markup' => $keyboard
            ]);
        }
    }
	if($fileid) bot('sendphoto',['chat_id' => ADMIN, 'caption'=> '','photo' => $fileid]);
    bot('sendmessage',[
        'chat_id' => ADMIN,
        'text'=> $msg,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}
if(preg_match('/enarenwble/',$cdata) and $text != '❌ انصراف'){
    file_put_contents("state/{$userid}.txt","");
    $input = explode('#',$cdata); //$telegram->sendMessage($userid,$cdata);die;
    $uid = $input[1];
    $fid = $input[2];
    $oid = $input[3];
    $order = $telegram->db->query("select * from fl_order where id=$oid")->fetch(2);
    $remark = $order['remark'];
    $server_id = $order['server_id'];
    $inbound_id = $order['inbound_id'];
    $respd = $telegram->db->query("select * from fl_file WHERE id='$fid' and active=1")->fetch(2);
    $name = $respd['title'];
    $days = $respd['days'];
    $volume = $respd['volume'];
    $price = $respd['price'];
	$limitip = intval($respd['limitip']);
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$uid")->fetch(2);
        if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
	
	if(isset($input[4])){
		$dcode = htmlspecialchars(strip_tags($input[4]));
		$dcount = $telegram->db->query("select * from fl_discount WHERE code='$dcode' and active=1 and count > 0 ");
        if($dcount->rowCount() > 0){
            $dres = $dcount->fetch(2);
            $amount = $dres['amount'];
            if($amount <= 100) {
                $price = $price * (100-$amount)/100;
            }else {
                $price = $price - $amount ;
            }
            if($dres['count'] != '') $telegram->db->query("update fl_discount set count= count - 1 WHERE code='$dcode'");
        }
	}

    require_once('vray.php');
    if($inbound_id > 0)
        $response = renew_client($server_id, $inbound_id, $remark, $volume, $days, $limitip);
    else
        $response = renew_inbound($server_id, $remark, $volume, $days, $limitip);
    
	if(is_null($response)){
		bot('answercallbackquery', [
			'callback_query_id' => $cid,
			'text' => '🔻مشکل فنی در اتصال به سرور. لطفا به مدیریت اطلاع بدید',
			'show_alert' => true
		]);
		exit;
	}
	
	if($response->success){
        $telegram->db->query("update fl_order set notif=0 where id='$oid'");
        $telegram->db->query("INSERT INTO `fl_extra_order` VALUES (NULL, '$uid', '$server_id', '$inbound_id', '$remark', '$price', '$time');");
		$telegram->sendMessageCURL($userid,"سرویس $remark با موفقیت تمدید شد",$finalop);
		// update button
		bot('editMessageReplyMarkup',[
			'chat_id' => $userid,
			'message_id' => $cmsgid,
			'reply_markup' => json_encode([
				'inline_keyboard' => [[['text' => '✅انجام شد', 'callback_data' => "dontsendanymore"]]],
			])
		]);
        $telegram->sendMessage($uid, "✅سرویس $remark با موفقیت تمدید شد");
        $user_detail = $telegram->db->query("select * from fl_user WHERE userid=$uid")->fetch(2);
        $uname = $user_detail['name'];
        $user_name = $user_detail['username'];
        $tel = $user_detail['tel'];
        $admins = file_get_contents('admins.php');
        $list = explode(PHP_EOL,$admins);
        foreach($list as $admid){
            if(strlen($admid) > 3 and $admid != $userid){
               $telegram->sendMessage($admid,"✅سفارش کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$remark
🏷 تمدید سرویس $remark ($price تومان)
✖کد کاربری: $uid
👤نام و نام خانوادگی: $uname
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
");
        }
    }
    if(ADMIN != $userid) $telegram->sendMessage(ADMIN,"✅سفارش کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$remark
🏷 تمدید سرویس $remark ($price تومان)
✖کد کاربری: $uid
👤نام و نام خانوادگی: $uname
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
");
    }else {
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "مشکل فنی در ارتباط با سرور. لطفا سلامت سرور را بررسی کنید",
            'show_alert' => true
        ]);
        exit;
    }
}
if(preg_match('/walrnwpay/', $cdata)){
    $input = explode('#',$cdata);
    $fid = $input[1];
    $oid = $input[2];
    $order = $telegram->db->query("select * from fl_order where id=$oid")->fetch(2);
    $remark = $order['remark'];
    $server_id = $order['server_id'];
    $inbound_id = $order['inbound_id'];
    $respd = $telegram->db->query("select * from fl_file WHERE id='$fid' and active=1")->fetch(2);
    $name = $respd['title'];
    $days = $respd['days'];
    $volume = $respd['volume'];
    $price = $respd['price'];
	$limitip = intval($respd['limitip']);
	
	$seller = $telegram->db->query("select * from fl_sellers where userid=$userid")->fetch(2);
        if(!empty($seller)) $price = $price - (($price) * ($seller['percent'] / 100));
	
	if(isset($input[3])){
		$dcode = htmlspecialchars(strip_tags($input[3]));
		$dcount = $telegram->db->query("select * from fl_discount WHERE code='$dcode' and active=1 and count > 0 ");
        if($dcount->rowCount() > 0){
            $dres = $dcount->fetch(2);
            $amount = $dres['amount'];
            if($amount <= 100) {
                $price = $price * (100-$amount)/100;
            }else {
                $price = $price - $amount ;
            }
            if($dres['count'] != '') $telegram->db->query("update fl_discount set count= count - 1 WHERE code='$dcode'");
        }
	}
 
    $userwallet = $telegram->db->query("select wallet from fl_user WHERE userid='$userid'")->fetch(2)['wallet'];
    
    if($userwallet < $price and !($userid == ADMIN or isAdmin())) {
        $needamount = $price - $userwallet;
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "💡موجودی کیف پول (".number_format($userwallet)." تومان) کافی نیست لطفا به مقدار ".number_format($needamount)." تومان شارژ کنید ",
            'show_alert' => true
        ]);
        exit;
    }

    require_once('vray.php');
    if($inbound_id > 0)
        $response = renew_client($server_id, $inbound_id, $remark, $volume, $days, $limitip);
    else
        $response = renew_inbound($server_id, $remark, $volume, $days, $limitip);

	if(is_null($response)){
		bot('answercallbackquery', [
			'callback_query_id' => $cid,
			'text' => '🔻مشکل فنی در اتصال به سرور. لطفا به مدیریت اطلاع بدید',
			'show_alert' => true
		]);
		exit;
	}
	if($response->success){
		$telegram->db->query("update fl_order set notif=0 where id='$oid'");
		$telegram->db->query("INSERT INTO `fl_extra_order` VALUES (NULL, '$userid', '$server_id', '$inbound_id', '$remark', '$price', '$time');");
		if(!($userid == ADMIN or isAdmin())) $telegram->db->query("update fl_user set wallet = wallet - $price WHERE userid='$userid'");
		$sndmsg = "
تمدید سرویس $remark
قیمت : $price
آیدی کاربر : $userid
آیدی سرور : $server_id
تعداد روز  $days
تعداد گیگ $volume
";
		$telegram->sendMessage($sendchnl,$sndmsg);
		// update button
		bot('editMessageReplyMarkup',[
			'chat_id' => $userid,
			'message_id' => $cmsgid,
			'reply_markup' => json_encode([
				'inline_keyboard' => [[['text' => '✅تمدید شد', 'callback_data' => "dontsendanymore"]]],
			])
		]);
		$telegram->sendMessage($userid, "✅سرویس $remark با موفقیت تمدید شد");exit;
	}else{
		
	}
    
   // $telegram->sendMessage($userid, json_encode($response));exit;
}

if($text=='موجودی کاربران' and ($userid==ADMIN or isAdmin() )){
    $users = $telegram->db->query("SELECT * FROM `fl_user` where wallet > 0 order by wallet DESC")->fetchAll(2);
    if(empty($users)){
        $msg = "موردی یافت نشد";
    }else {
        $msg = '';
        foreach ($users as $cty) {
            $id = $cty['id'];
            $usid = $cty['userid'];
            $usname = $cty['username'];
            $uname = $cty['name'];
            $wallet = number_format($cty['wallet']);
            $msg .= "
UserID: $usid
Username: @$usname
Name: $uname
💰 $wallet 
📝 /waladd$id
====";
			if(strlen($msg) > 3950){
                $telegram->sendMessage($userid,$msg);
                $msg = '';
            }
        }
    }
    $telegram->sendMessage($userid,$msg);
}
if(preg_match('/waladd/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"لطفا افزایش/کاهش موجودی جدید را با اعداد لاتین و به تومان بصورت زیر وارد کنید:
برای افزایش علامت + و برای کاهش علامت - بزنید

مثلا
+1000

برای تغییر کلی موجودی عدد ثابت بدون + یا - وارد کنید مثلا 5000
", $cancelop);
	exit;
}
if(preg_match('/waladd/',$state) and $text != '❌ انصراف') {
    $id=str_ireplace('/waladd','',$state);
    
    $str = 0;
    if(preg_match('/\+|-/', $text)){
        $str = " wallet $text";
    }else{
        $str = "$text";
    }
    
    
	$telegram->db->query("update fl_user set wallet= $str where id={$id}");
	$telegram->sendMessageCURL($userid,"✅موجودی کاربر به مقدار $text تومان تغییر کرد", $adminop);
	file_put_contents("state/$userid.txt",'');
}
if($text=='مدیریت دسته بندی ها' and ($userid==ADMIN or isAdmin() )){
    $cats = $telegram->db->query("SELECT * FROM `fl_cat` where active=1 and parent=0")->fetchAll(2);
    if(empty($cats)){
        $msg = "موردی یافت نشد";
    }else {
        $msg = '';
        foreach ($cats as $cty) {
            $id = $cty['id'];
            $cname = $cty['title'];
            $msg .= "
✅نام : $cname
♻️ویرایش : /editc$id
❌حذف : /delcat$id
====";
			if(strlen($msg) > 3950){
                $telegram->sendMessage($userid,$msg);
                $msg = '';
            }
        }
    }
    $telegram->sendMessage($userid,$msg);
}
if($text=='افزودن دسته بندی' and ($userid == ADMIN or isAdmin() )){
    $state = file_put_contents('state/'.$userid.'.txt','addnewcat');
    $telegram->db->query("delete from fl_cat WHERE active=0");
    $sql = "INSERT INTO `fl_cat` VALUES (NULL, 0, '', 0,2,0);";
    $telegram->db->query($sql);
    $msg = '◀️ لطفا عنوان دسته بندی را وارد کنید';
    $telegram->sendMessageCURL($userid,$msg,$cancelop);
    exit;
}
// add category
if(preg_match('/addnewcat/',$state) and $text!='❌ انصراف'){
    $step = $telegram->checkStep('fl_cat');
    if($step==2 and $text!='❌ انصراف' ){
        
        $telegram->db->query("update fl_cat set title='$text',step=4,active=1 where active=0");
        $msg = '✅دسته بندی جدید با موفقیت ثبت شد';
        $telegram->sendMessageCURL($userid,$msg,$adminop);
    }
}
// end add category
if(preg_match('/delcat/',$text) and ($userid==ADMIN or isAdmin() )){
    $pid=str_ireplace('/delcat','',$text);
    $telegram->db->query("delete from fl_cat where id={$pid}");
    $telegram->sendMessage($userid,"دسته بندی موردنظر با موفقیت حذف شد");
}
if(preg_match('/editc/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessage($userid,"نام جدید دسته بندی را وارد کنید:");exit;
}
if(preg_match('/editc/',$state)){
    $pid=str_ireplace('/editc','',$state);
    $telegram->db->query("update fl_cat set title='$text' where id={$pid}");
    $telegram->sendMessage($userid,"✅عملیات با موفقیت انجام شد");
    file_put_contents("state/$userid.txt",'');
}

if($text=='افزودن همکار جدید' and ($userid == ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",'addhamkar');
    $telegram->sendMessageCURL($userid,"لطفا ایدی عددی و درصد همکاری را وارد کنید:
مثال
2355434-10

مقدار اول 23555434 ایدی عددی
مقدار دوم درصد بین 0 تا 100

توجه کنید اعداد بصورت لاتین باشند",$cancelop);exit;
}
if(preg_match('/addhamkar/',$state) and $text != '❌ انصراف') {
    $input = explode('-',$text); 
	if(count($input) !=2) {$telegram->sendMessage($userid,'فرمت ارسال صحیح نیست');exit;}
    $uid = intval($input[0]); 
    if($uid == '0'){$telegram->sendMessage($userid,'فرمت ارسال صحیح نیست');exit;}
    $percent = intval($input[1]);
    if($percent > 100) {$telegram->sendMessage($userid,'فرمت ارسال صحیح نیست');exit;}
	
	$seller = $telegram->db->query("select * from fl_sellers where userid='$uid'")->fetch(2);
	if(!empty($seller)){
		$telegram->sendMessage($userid,'این همکار از قبل وجود دارد');
		exit;
	}
	
    $telegram->db->query("insert into fl_sellers VALUES (NULL,'$uid',$percent)");
    $telegram->sendMessageCURL($userid,"✅همکار جدید با موفقیت اضافه شد",$adminop);
    file_put_contents("state/$userid.txt",'');
}

if($text=='همکارها' and ($userid==ADMIN or isAdmin() )){
    $cats = $telegram->db->query("SELECT * FROM `fl_sellers`")->fetchAll(2);
    if(empty($cats)){
        $msg = "موردی یافت نشد";
    }else {
        $msg = '';
        foreach ($cats as $cty) {
            $id = $cty['id'];
            $uid = $cty['userid'];
            $uname = $telegram->db->query("SELECT * FROM `fl_user` where userid= '$uid'")->fetch(2)['name'];
            $percent = $cty['percent'];
            $msg .= "
#⃣  $uname ($uid)
♻ همکاری {$percent}٪ /edithmkr$id
❌ حذف /delhmkr$id
===============";
			if(strlen($msg) > 3950){
                $telegram->sendMessage($userid,$msg);
                $msg = '';
            }
        }
    }
    $telegram->sendMessage($userid,$msg);
}
if(preg_match('/edithmkr/',$text) and ($userid==ADMIN or isAdmin() )){ 
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"درصد جدید همکاری را بصورت اعداد لاتین و بین 0 تا 100 وارد کنید:", $cancelop);exit;
}
if(preg_match('/edithmkr/',$state) and $text != '❌ انصراف') {
    $pid=str_ireplace('/edithmkr','',$state);
    if(intval($text) > 100) {
        $telegram->sendMessage($userid,'لطفا عدد لاتین بین 0 تا 100 وارد کنید. خود 0 قابل قبول نیست');
        exit;
    }
    $telegram->db->query("update fl_sellers set percent='$text' where id={$pid}");
    $telegram->sendMessageCURL($userid,"✅عملیات با موفقیت انجام شد", $adminop);
    file_put_contents("state/$userid.txt",'');
}

if(preg_match('/delhmkr/',$text) and ($userid==ADMIN or isAdmin() )){
    $pid=str_ireplace('/delhmkr','',$text);
	$uid = $telegram->db->query("SELECT * FROM `fl_sellers` where id= '$pid'")->fetch(2)['userid'];
    $telegram->db->query("delete from fl_sellers where id='$pid'");
    $telegram->db->query("delete from fl_remark where userid='$uid'");
    $telegram->sendMessage($userid,"همکار مورد نظر با موفقیت حذف شد");
}

if($text=='مدیریت سرورها' and ($userid==ADMIN or isAdmin() )){
    $cats = $telegram->db->query("SELECT * FROM `fl_server` where active=1")->fetchAll(2);
    if(empty($cats)){
        $msg = "موردی یافت نشد";
    }else {
        $msg = '';
        foreach ($cats as $cty) {
            $id = $cty['id'];
            $cname = $cty['title']." ".$cty['flag']." (".$cty['remark'].")";
            $ucount = $cty['ucount'];
            $msg .= "
#⃣آیدی : $id
✅نام : $cname 
➕تعداد : $ucount /chslmt$id
©کپی: /copysvpl$id
♻️ویرایش : /editsrv$id
❌حذف : /delsrv$id
===============";
			if(strlen($msg) > 3950){
                $telegram->sendMessage($userid,$msg);
                $msg = '';
            }
        }
    }
    $telegram->sendMessage($userid,$msg);
}
if(preg_match('/chslmt/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"ظرفیت جدید را وارد کنید(عدد لاتین): اگر 0 بزارید سرور از لیست :خرید کانفیگ: مخفی می شود",$cancelop);exit;
}
if(preg_match('/chslmt/',$state) and $text != '❌ انصراف') {
    $pid=str_ireplace('/chslmt','',$state);
    if(is_numeric($text)){
        $telegram->db->query("update fl_server set ucount='$text' where id={$pid}");
        $telegram->sendMessageCURL($userid,"✅عملیات با موفقیت انجام شد",$adminop);
        file_put_contents("state/$userid.txt",'');
    }else{
        $telegram->sendMessage($userid,"یک مقدار عددی و صحیح وارد کنید");
    }
}
if(preg_match('/copysvpl/',$text) and ($userid==ADMIN or isAdmin() )){
    $sid = str_replace('/copysvpl', '', $text);
    $srvs = $telegram->db->query("SELECT * FROM `fl_server` WHERE id != $sid")->fetchAll(2);
    if(empty($srvs)) {
        $telegram->sendMessage($userid,'سرور دیگری برای کپی ندارید. لطفا ابتدا یک سرور بسازید و بعد پلن ها رو کپی کنید');
        exit;
    }

    file_put_contents("state/$userid.txt",$text);
    $srvkey = [];
    foreach($srvs as $srv){
        $id = $srv['id'];
        $title = $telegram->db->query("SELECT * FROM `fl_server` where id=$id")->fetch(2)['title'];
        $srvkey[] = ['text' => $title, 'callback_data' => "copysvpl#$id"];
    }
    $srvkey = array_chunk($srvkey,1);
    bot('sendmessage', [
        'chat_id' => $userid,
        'text' => "برای کپی همه پلن ها, سرور مقصد را انتخاب کنید :",
        'reply_markup' => json_encode(['inline_keyboard' => $srvkey])
    ]);
}
if(preg_match('/copysvpl/',$cdata) and preg_match('/copysvpl/',$state)){
    $sid_from = str_ireplace("/copysvpl",'', $state);
    $sid_to = str_ireplace('copysvpl#','',$cdata);
    $files = $telegram->db->query("select * from fl_file where server_id=$sid_from and active=1 order by id asc")->fetchAll(2);
    foreach ($files as $file){
        $fid = $file['id'];
        $catid = $file['catid'];
        $server_id = $file['server_id'];
        $inbound_id = $file['inbound_id'];
        $acount = $file['acount'];
        $limitip = $file['limitip'];
        $title = $file['title'];
        $protocol = $file['protocol'];
        $days = $file['days'];
        $volume = $file['volume'];
        $type = $file['type'];
        $price = $file['price'];
        $descr = $file['descr'];
        $pic = $file['pic'];
        $active = $file['active'];
        $step = $file['step'];
		$telegram->db->query('INSERT INTO `fl_file` VALUES (NULL, "", "'.$catid.'","'.$sid_to.'","'.$inbound_id.'","'.$acount.'", "'.$limitip.'", "'.$title.'", "'.$protocol.'", "'.$days.'", "'.$volume.'", "'.$type.'", "'.$price.'", "'.$descr.'", "'.$pic.'","'.$active.'","'.$step.'", "'.$time.'");');
    }
    bot('editmessageText', [
        'chat_id' => $userid,
        'message_id' => $cmsgid,
        'text' => "✅همه پلن های سرور با موفقیت کپی شدند",
    ]);
    file_put_contents("state/$userid.txt",'');
}
if($text=='افزودن سرور' and ($userid == ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",'addserver');
    $telegram->sendMessageCURL($userid,"نام سرور, ظرفیت آن, ریمارک و پرچم را هر کدام در یک خط جداگانه وارد کنید:
مثال :
سرور المان
250
srvDE
🇩🇪

توجه کنید که ریمارک باید بصورت انگلیسی و بدون فاصله باشد",$cancelop);exit;
}
if(preg_match('/addserver/',$state) and $text != '❌ انصراف') {
    $input = explode(PHP_EOL,$text); 
	if(count($input) !=4) {$telegram->sendMessage($userid,'فرمت ارسال صحیح نیست. لطفا خط اول اسم نمایشی, خط دوم ظرفیت, خط سوم ریمارک, خط چهارم پرچم را به اعداد لاتین بفرستید');exit;}
    $title = $input[0];
    $ucount = intval($input[1]);
    $remark = $input[2];
	if(!preg_match('/^[\w]+$/', $remark)){
        $telegram->sendMessage($userid,'لطفا فقط حروف انگلیسی و اعداد لاتین بفرستید');die;
    }
    $flag = $input[3];
    $telegram->db->query("insert into fl_server VALUES (NULL,'$title',$ucount,'$remark','$flag',1)");
    $telegram->sendMessageCURL($userid,"✅سرور جدید با موفقیت اضافه شد",$adminop);
    file_put_contents("state/$userid.txt",'');
}
if(preg_match('/delsrv/',$text) and ($userid==ADMIN or isAdmin() )){
    $pid=str_ireplace('/delsrv','',$text);
    $telegram->db->query("delete from fl_server where id={$pid}");
    $telegram->sendMessage($userid,"سرور موردنظر با موفقیت حذف شد");
}
if(preg_match('/editsrv/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"نام سرور و ریمارک را هر کدام در یک خط جداگانه وارد کنید:
مثال :
سرور المان
srvDE

توجه کنید که ریمارک باید بصورت انگلیسی و بدون فاصله باشد",$cancelop);exit;

}
if(preg_match('/editsrv/',$state) and $text != '❌ انصراف') {
    $id = str_ireplace("/editsrv",'', $state); 
    $input = explode(PHP_EOL,$text);
	if(count($input) !=2) {$telegram->sendMessage($userid,'فرمت ارسالی صحیح نیست. لطفا خط اول اسم نمایشی, خط دوم ریمارک را بفرستید');exit;}
	$title = $input[0];
    $remark = $input[1];
	if(!preg_match('/^[\w]+$/', $remark)){
        $telegram->sendMessage($userid,'لطفا فقط حروف انگلیسی و اعداد لاتین بفرستید');die;
    }
    $telegram->db->query("update fl_server set title='$title',remark='$remark' where id=$id");
    $telegram->sendMessageCURL($userid,"✅عملیات با موفقیت انجام شد",$adminop);
    file_put_contents("state/$userid.txt",'');
}

if ($text == '🗒 پیام همگانی' and ($userid == ADMIN or isAdmin() )){
    $state = file_put_contents('state/' . $userid . '.txt', 's2a');
    $msg = "لطفا پیام خود ارسال کنید. ";
    $telegram->sendAction($userid, 'typing');
    $telegram->sendHTML($userid, $msg, $cancelop);
    exit;
}
if ($state == 's2a' and $text != '❌ انصراف') {
    
    file_put_contents('state/' . $userid . '.txt', $text);
    $respd = $telegram->db->query("select * from fl_server ORDER BY id ASC")->fetchAll(2);
    $keyboard = [];
    foreach($respd as $cat){
        $id = $cat['id'];
        $name = $cat['title'];
        $flag = $cat['flag'];
        $keyboard[] = ['text' => "$flag $name", 'callback_data' => "sendpm#$id"];
    }
    $keyboard[] = ['text' => "همه کاربران ربات", 'callback_data' => "sendpm#all"];
	$keyboard[] = ['text' => "فقط مشتریان", 'callback_data' => "sendpm#customers"];
    $keyboard = array_chunk($keyboard,1);
    bot('sendmessage',[
        'chat_id' => $userid,
        'text'=> ' 📍 لطفا یکی از سرورها را برای ارسال پیام به کاربران آن, انتخاب کنید👇',
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}

if ($text == '📈آمار' and  ($userid == ADMIN or isAdmin() ) ) {
    file_put_contents('state/' . $userid . '.txt', '');
    $users = $telegram->db->query("select * from fl_user")->rowCount();
    $product = $telegram->db->query("select * from fl_file WHERE active=1")->rowCount();
    $fault = $telegram->db->query("select * from fl_order where status=0")->rowCount();
    $success = $telegram->db->query("select * from fl_order where status=1")->rowCount();
    $income = $telegram->db->query("select sum(amount) as amount from fl_order where status=1")->fetch(2)['amount'];
    $todaydate = strtotime(date('Y-m-d 00:00'));
    $todaydate2 = strtotime('+1 day',$todaydate); 
    $income_day = $telegram->db->query("select sum(amount) as amount FROM `fl_order` WHERE (date BETWEEN $todaydate and $todaydate2) and status=1")->fetch(2)['amount'];
    $income_day = is_null($income_day) ? 0 : $income_day;
    $fault_day = $telegram->db->query("select * from fl_order where (date BETWEEN $todaydate and $todaydate2) and status=0")->rowCount();
    $success_day = $telegram->db->query("select * from fl_order where (date BETWEEN $todaydate and $todaydate2) and status=1")->rowCount();
    $income_month = $telegram->db->query("select sum(amount) as amount FROM `fl_order` WHERE date >= $time - 86400*30 and status=1")->fetch(2)['amount'];
    $fault_month = $telegram->db->query("select * from fl_order where date >= $time - 86400*30 and status=0")->rowCount();
    $success_month = $telegram->db->query("select * from fl_order where date >= $time - 86400*30 and status=1")->rowCount();

	$todaydate3 = strtotime('-1 day',$todaydate); 
    $income_yesterday = $telegram->db->query("select sum(amount) as amount FROM `fl_order` WHERE (date BETWEEN $todaydate3 and $todaydate) and status=1")->fetch(2)['amount'];
    $income_yesterday = is_null($income_yesterday) ? 0 : $income_yesterday;
    $fault_yesterday = $telegram->db->query("select * from fl_order where (date BETWEEN $todaydate3 and $todaydate) and status=0")->rowCount();
    $success_yesterday = $telegram->db->query("select * from fl_order where (date BETWEEN $todaydate3 and $todaydate) and status=1")->rowCount();
	
    $renew_income = $telegram->db->query("select sum(amount) as amount from fl_extra_order")->fetch(2)['amount'];

    $income_total = number_format($income + $renew_income);
    $income = number_format($income);
    $renew_income = number_format($renew_income);
	
	$royals = "================================= \n 🥇مشتریان وفادار 30روز گذشته: \n";
    $royal_customers = $telegram->db->query("SELECT userid, SUM(amount) AS totalamount FROM fl_order WHERE status=1 and date >= $time - 86400*30 GROUP BY userid ORDER BY SUM(amount) DESC limit 5")->fetchAll(2);
    if(empty($royal_customers)) $royals = '';
    foreach($royal_customers as $royal){
        $uid = $royal['userid'];
        $user = $telegram->db->query("select * from fl_user where userid='$uid'")->fetch(2);
        $amount = number_format($royal['totalamount']);
        $royals .= "➖id : <code>".$user['userid']."</code>
➖name : <b>".$user['name']."</b>
➖username : <code>".$user['username']."</code>
➖tel : <b>".$user['tel']."</b>
💵Amount: $amount Toman
=================================
";
    }
	
    $msg = "
✅تعداد کل کاربران ربات :$users 

✅تعداد کل محصولات :$product 

⏩تعداد تراکنش های ناموفق :$fault 

✅تعداد تراکنش های موفق :$success

=============================
✅درآمد کل خریدها  : $income تومان

✅درآمد کل تمدیدها  : $renew_income تومان

✅درآمد کل : $income_total تومان
=============================

✅درآمد امروز  :".number_format($income_day)." تومان

⏩تعداد تراکنش های ناموفق امروز :$fault_day

✅تعداد تراکنش های موفق امروز :$success_day
======================
✅درآمد دیروز  :".number_format($income_yesterday)." تومان

⏩تعداد تراکنش های ناموفق دیروز :$fault_yesterday

✅تعداد تراکنش های موفق دیروز :$success_yesterday

======================
✅درآمد یک ماه اخیر (30 روز گذشته) :".number_format($income_month)." تومان

⏩تعداد تراکنش های ناموفق یک ماه اخیر (30 روز گذشته) :$fault_month

✅تعداد تراکنش های موفق یک ماه اخیر (30 روز گذشته) :$success_month

$royals
.";
    $telegram->sendHTML($userid, $msg, $adminop);
}

if(($text == '⚙️ مدیریت'  or $text == '↪️بازگشت' ) and ($userid == ADMIN or isAdmin() )){
    file_put_contents('state/' . $userid . '.txt', '');
    $msg = 'مدیریت عزیز خوش آمدید';
    $telegram->sendHTML($userid, $msg, $adminop);
}


if ($text == '💡راهنما' or $text == '💡راهنمای اتصال' or $cdata == 'backhelp' or $text =='help') {
    $state = file_put_contents('state/' . $userid . '.txt', '');
    $keyboard =[
        [
            ['text' => "🤖android", 'callback_data' => "helpcenter#android"],
            ['text' => "📱ios", 'callback_data' => "helpcenter#ios"],
        ],
        [
            ['text' => "🖥mac", 'callback_data' => "helpcenter#mac"],
            ['text' => "💻windows", 'callback_data' => "helpcenter#windows"],
        ],
    ];
    $msg = "لطفا یکی از گزینه ها را انتخاب کنید";
    if(!is_null($cdata)){
        bot('editMessageText', [
            'chat_id' => $userid,
            'message_id' => $cmsgid,
            'text'=> $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }else{
        bot('sendmessage', [
            'chat_id' => $userid,
            'text' => $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }
    
    exit;
}
if(preg_match('/helpcenter/',$cdata)){
    $platform = explode('#',$cdata)[1];
    bot('editMessageText', [
        'chat_id' => $userid,
        'message_id' => $cmsgid,
        'text'=> $helpmsg_arr[$platform],
        'reply_markup' => json_encode([
            'inline_keyboard' => [[['text' => "↪️بازگشت", 'callback_data' => "backhelp"]]]
        ])
    ]);
}
if ($text == '👤ارتباط با ما' or $text =='/support') {
    $state = file_put_contents('state/' . $userid . '.txt', 'support');
    $msg = '
با سلام خدمت شما کاربر گرامی 
پشتیبانی ۲۴ ساعته با  آی دی زیر 👇
'.$supportus.'
یا پیام خود را اینجا بفرستید. سعی ما بر این است که هر چه سریعتر با آن پاسخ دهیم:';
    $telegram->sendMessageCURL($userid, $msg, $cancelop);exit;
}
if($text!='❌ انصراف' and $state=='support'){
    if(strlen($text) < 3) {
        $telegram->sendMessage($userid,'لطفا متن پیام صحیح را با طول کاراکتر حداقل 3 وارد کنید');
        exit;
    }
    $user = $telegram->db->query("select * from fl_user where userid='$userid'")->fetch(2);
    if(!$user){
        $telegram->sendMessage($userid,'اطلاعات شما در سیستم یافت نشد. لطفا مجدد /start بزنید');
        exit;
    }
	$status = $user['status'] ? '✅' : '☑';
	$orders_count = $telegram->db->query("select * from fl_order where userid='".$user['userid']."' and status=1")->rowcount();
    file_put_contents('state/'.$userid.'.txt','');
    $telegram->sendMessageCURL($userid,'❇️پیام شما با موفقیت برای پشتیبانی ارسال شد. پیام شما بزودی بررسی و از طریق همین ربات اطلاع رسانی می شود',$finalop);
    $msg = "
➖id : <code>".$user['userid']."</code>
➖name : <b>".$user['name']."</b>
➖username : <code>".$user['username']."</code>
➖tel : <b>".$user['tel']."</b>
➖Subs : $list_count /guslst".$user['userid']."
➖status : $status /banusr".$user['id']."
➖orders : <b>$orders_count</b> /getuord".$user['userid']."
➖wallet : <b>".number_format($user['wallet'])."</b> /waladd".$user['id']."
✍ Message : <b>$text</b>
";
    $admins = file_get_contents('admins.php');
    $list = explode(PHP_EOL,$admins);
    foreach($list as $admid){
        if(strlen($admid) > 3){
            //$telegram->forwardmessage($admid,$userid,$msgid);
            bot('sendmessage', [
                'chat_id' => $admid,
                'parse_mode' => "HTML",
                'text' => $msg,
                'reply_markup' => json_encode([
                    'inline_keyboard' => [[ ['text' => "ارسال پاسخ", 'callback_data' =>"replyusr#".$user['userid'] ] ]]
                ])
            ]);
        }
    }
    file_put_contents('state/' . $userid . '.txt', '');
    //$telegram->forwardmessage(ADMIN,$userid,$msgid);
    bot('sendmessage', [
        'chat_id' => ADMIN,
        'parse_mode' => "HTML",
        'text' => $msg,
        'reply_markup' => json_encode([
            'inline_keyboard' => [[ ['text' => "ارسال پاسخ", 'callback_data' =>"replyusr#".$user['userid'] ] ]]
        ])
    ]);
    
}
if(preg_match('/replyusr/',$cdata) and ($userid == ADMIN or isAdmin() ) ){
    file_put_contents('state/'.$userid.'.txt',$cdata);
    $msg = "متن پیام خود را وارد کنید";
    $telegram->sendMessageCURL($userid,$msg,$cancelop);exit;
}

if(preg_match('/replyusr/',$state) and ($userid == ADMIN or isAdmin() ) and $text!='❌ انصراف'){
    $uid = str_replace('replyusr#','',$state);
    file_put_contents('state/'.$userid.'.txt','');
    
    $telegram->sendMessage($uid,$text);
    $telegram->sendMessageCURL($userid,'پیام شما با موفقیت به کاربر ارسال شد.',$adminop);exit;
}
if($text == '🔐ادمین ها' and ($userid==ADMIN or isAdmin() )){
    $admins = file_get_contents('admins.php');
    $list = explode('\n',$admins);
    file_put_contents('state/' . $userid . '.txt', 'admin');
    $telegram->sendHTML($userid, "📝 لیست کاربران مدیر به صورت زیر است:
<b>$admins</b>
⚠️اگر قصد عزل یکی از کاربران این لیست را دارید
❇️یا اضافه کردن یک کاربر به عنوان ادمین را دارید, کافیست که آی دی عددی را همین جا ارسال کنید", [['↪️بازگشت']]);

    exit;
}
if ($state == 'admin' and $text != '↪️بازگشت' ) {
    if(is_numeric($text) and strlen($text)>4){
        file_put_contents('state/' . $userid . '.txt', '');
        $admins = file_get_contents('admins.php');
        if(!preg_match("/$text/",$admins)) {
            file_put_contents('admins.php',"\n".$text,FILE_APPEND);
            $msg = 'کاربر به دسترسی مدیریت ارتقا یافت';
        } else{
            $str = str_replace($text,'',$admins);
            //$str=str_replace("\n","",$str);
            file_put_contents('admins.php',$str);
            $msg = 'کاربر از لیست مدیران ربات حذف شد';
        };
        $telegram->sendHTML($userid,$msg,$adminop);
    }else{
        $telegram->sendMessage($userid, 'لطفا یک آی دی عددی و صحیح ارسال کنید');
    }
}
if($text == '💎دریافت نرم افزار یا اپلیکیشن' or $text == '/download') {
    $respd = $telegram->db->query("select * from fl_software WHERE status=1")->fetchAll(2);
    $keyboard = [];
    foreach($respd as $file){
        $link = $file['link'];
        $title = $file['title'];
        $keyboard[] = ['text' => "$title", 'url' => $link];
    }
    $keyboard = array_chunk($keyboard,1);
    bot('sendmessage', [
        'chat_id' => $userid,
        'text' => "
🔰لیست نرم افزار ها به شرح زیر است لطفا یکی از موارد را انتخاب کنید

🔸می توانید به راحتی همه فایل ها را (به صورت رایگان) دریافت کنید
.",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}
if($text == '📥 لینک دعوت' or $text == '/referer_link'){
    $code = $telegram->db->query("select * from fl_user where userid=$userid")->fetch(2)['refcode'];
    $count = $telegram->db->query("select * from fl_subuser where refcode='$code'")->rowCount();
    $msg = "
	
تعداد زیرمجموعه ها : $count
لیست زیرمجموعه ها : /getsblst

لینک زیر را با دوستان خود به اشتراک بزارید و به ازای هر خرید %$pursant از مبلغ خرید به کیف پول شما اضافه خواهد شد تا بتوانید محصولات داخل فروشگاه را بدون پرداخت هزینه دریافت کنید

https://t.me/".botid."?start=$code
";

    $telegram->sendAction($userid,'typing');
    $telegram->sendHTML($userid,$msg,$finalop);
}
if($text == '/getsblst'){
    $list = $telegram->db->query("select * from fl_subuser where  toplevel_userid=$userid")->fetchAll(2);
    if(empty($list)){
        $telegram->sendMessage($userid, 'لیست خالی است');exit;
    }else{
        $count = 0;
        foreach ($list as $sb) {
            $uname = $sb['fname'];
            $msg .= "$count - $uname \n";
            $count++;
        }
        $telegram->sendMessage($userid, $msg);
    }
}
if($text=='💰کیف پول' or $text == '/wallet'){
    
$wallet = $telegram->db->query("SELECT * from `fl_user` WHERE userid=$userid")->fetch(2)['wallet'];
$ttl = 0;
$product = '';
$ttl += $wallet;
$product .= "
  💸 موجودی کل : ".number_format($ttl)." تومان ";

if($ttl == 0) $product= '🔻موجودی کیف پول شما صفر است ';

$telegram->sendAction($userid,'typing');

    $keyboard[] = [['text' => "افزایش موجودی", 'callback_data' => "addwalet"]];
    bot('sendmessage',[
        'chat_id' => $userid,
        'text'=> $product,
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}
if($cdata=='addwalet'){
    $state = file_put_contents('state/'.$userid.'.txt','addwalet');
    $msg = '🔻لطفا مبلغی که قصد شارژ حساب خود دارید را به تومان و اعداد لاتین وارد کنید.'; 
    $telegram->sendMessageCURL($userid,$msg,[['❌ انصراف']]);
}

if($state == 'addwalet' and $text != '❌ انصراف'){
    if(intval($text) and intval($text) > $min_wallet_charge){
        $state = file_put_contents('state/'.$userid.'.txt','');
        $amount = number_format(intval($text));
        $telegram->sendMessageCURL($userid,'برای پرداخت روی دکمه پایین بزنید :',$finalop);
		if($gateways['zibal']) $keyboard[] = [['text' => "پرداخت آنلاین - $amount تومان", 'url' => baseURI."zibal.php?type=wallet&action=pay&amount=$text&userid=$userid"]];
		if($gateways['novino']) $keyboard[] = [['text' => "پرداخت آنلاین - $amount تومان", 'url' => baseURI."nvpayment.php?type=wallet&action=pay&amount=$text&userid=$userid"]];
		if($gateways['payping']) $keyboard[] = [['text' => "پرداخت آنلاین2 - $amount تومان", 'url' => baseURI."payping.php?type=wallet&userid=$userid&amount=$text"]];
        if($gateways['bahamta']) $keyboard[] = [['text' => "پرداخت آنلاین - $amount تومان", 'url' => baseURI."bahamta.php?action=pay&type=wallet&userid=$userid&amount=$text"]];
        if($gateways['zarin']) $keyboard[] = [['text' => "درگاه زرین پال", 'url' => baseURI."/wallet/pay.php?userid=$userid&amount=$text"]];
        if($gateways['next']) $keyboard[] = [['text' => "درگاه نکست پی", 'url' => baseURI."/wallet/next/pay.php?userid=$userid&amount=$text"]];
        if($gateways['card']) $keyboard[] = [['text' => "کارت به کارت",  'callback_data' => "crdwll#$text"]];
        
        $aa = bot('sendmessage',[
            'chat_id' => $userid,
            'text'=> "لینک پرداخت آنلاین برای شارژ حساب به مبلغ $amount تومان ایجاد شد :",
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
       // $telegram->sendMessage($userid,json_encode($aa));
        
    }else {
        $telegram->sendMessage($userid,"لطفا مبلغ را به تومان و بیشتر از $min_wallet_charge تومان وارد کنید");exit;
    }
    exit;
}
if(preg_match('/crdwll/',$cdata) and !preg_match('/crdwll/',$state)) {
    file_put_contents("state/$userid.txt",$cdata);
    $telegram->sendHTML($userid,"لطفا تصویر فیش واریزی یا شماره پیگیری -  ساعت پرداخت - نام پرداخت کننده را در یک پیام ارسال کنید
🔸$cardinfo",$cancelop);
    exit;
}
if(preg_match('/crdwll/',$state) and $text != '❌ انصراف' and !$cdata){
	bot('deleteMessage', ['chat_id' => $userid,'message_id' => $msgid -1]);
	if(!isset($result->message->photo)){
	    $telegram->sendMessage($userid, "⚠️لطفا فیش واریزی را فقط بصورت عکس ارسال کنید");exit;
	}
    $input = explode('#',$state);
    $amount = $input[1];
    file_put_contents("state/$userid.txt",'');
    $res = $telegram->db->query("select * from fl_user where userid=$userid")->fetch(2);
    $uid = $res['userid'];
    $name = $res['name'];
    $tel = $res['tel'];
    $username = $res['username'];
    
    $price = number_format($amount);

    $fileurl = $telegram->FileURL($fileid);
    $infoc = strlen($text) > 1 ? $text : "$caption (فیش واریزی در بالای این پیام هست)";
    $msg = "
✅✅درخواست افزایش موجودی شما با موفقیت ارسال شد
بعد از بررسی و تایید فیش، موجودی شما به مبلغ $price تومان شارژ و از طریق ربات اطلاع رسانی می شود.
/start";
    $telegram->sendMessageCURL($userid,$msg,$finalop);
    // notify admin
    $msg = "
🏷افزایش موجودی کاربر $name
✖کد کاربری: $userid
📧یوزرنیم: @$username
☎️شماره موبایل : $tel
مبلغ درخواستی: $price تومان
📝اطلاعات پرداخت کارت به کارت: $infoc
 ";
    $keyboard = json_encode([
        'inline_keyboard' => [
            [
                ['text' => 'تایید پرداخت', 'callback_data' => "aducash#$uid#$amount"],
				['text' => 'عدم تایید', 'callback_data' => "disable#$uid#wallet$amount"]
            ],
            [
                ['text' => 'مبلغ دلخواه', 'callback_data' => "cuscash#$uid"],
            ]
        ]
    ]);
    $admins = file_get_contents('admins.php');
    $list = explode(PHP_EOL,$admins);
    foreach($list as $admid){
        if(strlen($admid) > 3){
			if($fileid) bot('sendphoto',['chat_id' => $admid, 'caption'=> '','photo' => $fileid]);
            bot('sendmessage',[
                'chat_id' => $admid,
                'text'=> $msg,
                'parse_mode' => 'HTML',
                'reply_markup' => $keyboard
            ]);
        }
    }
	if($fileid) bot('sendphoto',['chat_id' => ADMIN, 'caption'=> '','photo' => $fileid]);
    bot('sendmessage',[
        'chat_id' => ADMIN,
        'text'=> $msg,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}

if(preg_match('/cuscash/',$cdata) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/{$userid}.txt","$cdata#$cmsgid");
    $telegram->sendHTML($userid,"لطفا مبلغ دلخواه برای شارژ کیف پول کاربر را بصورت اعداد لاتین وارد کنید مثلا 25000",$cancelop);
}
if(preg_match('/cuscash/',$state) and $text != '❌ انصراف'){
    
    if(!is_numeric($text)) {
        $telegram->sendMessage($userid, 'لطفا یک مقدار عددی صحیح وارد کنید');die;
    }
    
    $input = explode('#',$state);
    $uid = $input[1];
    if(isset($input[2])) $cmsgid = $input[2];
    $amount = $text;
    $price = number_format($amount);
    $telegram->sendMessageCURL($userid,"موجودی کاربر به مقدار $price تومان شارژ شد",$finalop);
    // update button
	bot('editMessageReplyMarkup',[
		'chat_id' => $userid,
		'message_id' => $cmsgid,
		'reply_markup' => json_encode([
			'inline_keyboard' => [[['text' => '✅انجام شد', 'callback_data' => "dontsendanymore"]]],
		])
	]);
    $telegram->db->query("update fl_user set wallet = wallet + $amount WHERE userid=$uid");
	$telegram->sendHTML($uid,"💹کاربر گرامی موجودی شما به مقدار $price تومان شارژ شد",$finalop);
	file_put_contents("state/{$userid}.txt","");
	
    $user_detail = $telegram->db->query("select * from fl_user WHERE userid=$uid")->fetch(2);
    $uname = $user_detail['name'];
    $user_name = $user_detail['username'];
    $admins = file_get_contents('admins.php');
    $list = explode(PHP_EOL,$admins);
    foreach($list as $admid){
        if(strlen($admid) > 3 and $admid != $userid){
           $telegram->sendMessage($admid,"✅سفارش افزایش موجودی با کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$price_$uid        
🏷افزایش موجودی کاربر $uname
✖کد کاربری: $uid
📧یوزرنیم: @$user_name
مبلغ درخواستی: $amount تومان
");
        }
    }
    if(ADMIN != $userid) $telegram->sendMessage(ADMIN,"✅سفارش افزایش موجودی با کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$price_$uid 
🏷افزایش موجودی کاربر $uname
✖کد کاربری: $uid
📧یوزرنیم: @$user_name
مبلغ درخواستی: $amount تومان
");
}

if(preg_match('/aducash/',$cdata) and $text != '❌ انصراف'){
    file_put_contents("state/{$userid}.txt","");
    $input = explode('#',$cdata);
    $uid = $input[1];
    $amount = $input[2];
    $price = number_format($amount);
    $telegram->sendMessageCURL($userid,"موجودی کاربر به مقدار $price تومان شارژ شد",$finalop);
    // update button
	bot('editMessageReplyMarkup',[
		'chat_id' => $userid,
		'message_id' => $cmsgid,
		'reply_markup' => json_encode([
			'inline_keyboard' => [[['text' => '✅انجام شد', 'callback_data' => "dontsendanymore"]]],
		])
	]);
    $telegram->db->query("update fl_user set wallet = wallet + $amount WHERE userid=$uid");
	$telegram->sendHTML($uid,"💹کاربر گرامی موجودی شما به مقدار $price تومان شارژ شد",$finalop);
	
    $user_detail = $telegram->db->query("select * from fl_user WHERE userid=$uid")->fetch(2);
    $uname = $user_detail['name'];
    $user_name = $user_detail['username'];
    $tel = $user_detail['tel'];
    $admins = file_get_contents('admins.php');
    $list = explode(PHP_EOL,$admins);
    foreach($list as $admid){
        if(strlen($admid) > 3 and $admid != $userid){
           $telegram->sendMessage($admid,"✅سفارش افزایش موجودی با کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$price_$uid        
🏷افزایش موجودی کاربر $uname
✖کد کاربری: $uid
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
مبلغ درخواستی: $amount تومان
");
        }
    }
    if(ADMIN != $userid) $telegram->sendMessage(ADMIN,"✅سفارش افزایش موجودی با کارت به کارت زیر توسط یکی از همکاران رسیدگی شد. لطفا از تایید یا رد آن خودداری کنید
#$price_$uid 
🏷افزایش موجودی کاربر $uname
✖کد کاربری: $uid
📧یوزرنیم: @$user_name
☎️شماره موبایل : $tel
مبلغ درخواستی: $amount تومان
");
}
if($text == 'کد تخفیف'  and ($userid==ADMIN or isAdmin() )){
    $res = $telegram->db->query("SELECT * FROM fl_discount WHERE active = 1");
    if($res->rowCount() == 0) {$telegram->sendMessage($userid,"لیست کد ها خالی است \n ========== \n افزودن کد جدید /addcode"); exit;}
    $msg = '';
    foreach ($res->fetchAll(2) as $code) {
        $id = $code['id'];
        $dcode = $code['code'];
        $min = number_format($code['min']);
        $max = number_format($code['max']);
        $count = $code['count'];
        $amount = $code['amount'];
        $owner = $code['userid'] == '' ? "<b>همه</b>" : "<code>{$code['userid']}</code>";
        $expire_date = $code['expire_date'] == 0 ? "<b>نامحدود</b>" : "<code>".date("Y-m-d",$code['expire_date'])."</code>";
        if($amount <= 100) {
            $amount = "$amount %";
        }else {
            $amount = number_format($amount)." تومان ";
        }
        $msg .= "
کد <code>$dcode</code>
تخفیف <b>$amount</b>
حداقل <b>$min</b>
حداکثر <b>$max</b>
تعداد <b>$count</b>
انقضا <b>$expire_date</b>
برای $owner /dcd$id
حذف /delcode$id
=============
";
        if(strlen($msg) > 3950){
            $telegram->sendHTML($userid,$msg,$adminop);
            $msg = '';
        }
    }
    $telegram->sendHTML($userid,$msg."افزودن کد جدید /addcode",$adminop);
}
if(preg_match('/dcd/',$text)){
    file_put_contents('state/'.$userid.'.txt',$text);
    $msg = "اگر می خواهید این کد را به کاربر خاصی اختصاص بدید, لطفا آی دی کاربر را وارد کنید در غیر اینصورت برای عمومی کردن آن عدد 0 لاتین را وارد کنید";
    $telegram->sendMessageCURL($userid,$msg,$cancelop);
}
if(preg_match('/dcd/',$state) and ($userid==ADMIN or isAdmin() ) and $text!='❌ انصراف'){
    $did = str_replace('/dcd','', $state);
    $owner = $text == '0' ? '' : $text;
    if($owner !=''){
        $user = $telegram->db->query("select * from fl_user where userid='$text'")->fetch(2);
        if(!$user){
            $telegram->sendMessage($userid,'کاربر مورد نظر یافت نشد');
            exit;
        }
    }

    file_put_contents('state/'.$userid.'.txt','');
    $telegram->db->query("update fl_discount set userid = '$owner' where id=$did");
    $telegram->sendMessageCURL($userid,"مالکیت کد تخفیف با موفقیت تغییر کرد",$adminop);
}
if(preg_match('/delcode/',$text) and ($userid==ADMIN or isAdmin() )){
    $id=str_ireplace('/delcode','',$text);
    $telegram->db->query("delete from fl_discount where id={$id}");
    $telegram->sendMessage($userid,"کد تخفیف با موفقیت حذف شد");
}

if(preg_match('/addcode/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"کد تخفیف را بصورت لاتین و مقدار تخفیف را با جداکننده - وارد کنید:
مثال:
mycode-25-1000-2000-10-0-30

مقدار اول (mycode) کد تخفیف
مقدار دوم (25) مقدار تخفیف
مقدار سوم (1000) حداقل
مقدار چهارم (2000) حداکثر
مقدار پنجم (10) تعدادمصرف
مقدار ششم (0) مالکیت کد (آیدی عددی کاربر یا برای عمومی شدن 0)
مقدار هفتم (30) تعداد روز انقضا و برای نامحدود 0 بزنید

اگر مقدار تخفیف را تا عدد 100 وارد کنید تخفیف بصورت درصدی محاسبه می شود و اگر از 100 بالاتر باشد مقدار تومانی از خرید کاربر کسر می شود
در صورتی که میخواید هر یک از مقادیر حداکثر و حداقل اعمال نشود آن را 0 قرار بدید
",$cancelop);exit;
}
if(preg_match('/addcode/',$state) and $text != '❌ انصراف'){
    $id = str_ireplace("/addcode",'', $state);
    $input = explode('-',$text);
    if(count($input) != 7) {$telegram->sendMessage($userid,"لطفا متن بالا را با دقت بخونید و فرمت درست را بفرستید ");exit; }
    $code = strtolower($input[0]);
    $amount = $input[1];
    $min = $input[2];
    $max = $input[3];
    $count = $input[4] == '0' ? '' : $input[4];
    $owner = $input[5] == '0' ? '' : $input[5];
    $days = $input[6];
    $expire = $days == 0 ? '0' : strtotime("+$days days");
    $telegram->db->query("INSERT INTO `fl_discount` VALUES (NULL, '$code', '$amount',$min, $max, '$count', '$owner', $expire, '1')");
    $telegram->sendMessageCURL($userid,"✅کد تخفیف با موفقیت اضافه شد", $adminop);
    file_put_contents("state/$userid.txt",'');
}
/* start extra */
if($text=='پلن زمانی' or $cdata == 'backday' and ($userid==ADMIN or isAdmin() )){
    $res = $telegram->db->query("select * from extra_day")->fetchAll(2);
    if(empty($res)){
       bot('sendmessage', [
            'chat_id' => $userid,
            'parse_mode' => "HTML",
            'text' => 'لیست پلن های زمانی خالی است ',
            'reply_markup' => json_encode([
                'inline_keyboard' => [[['text' => "افزودن پلن زمانی جدید", 'callback_data' =>"adddayplan"],]]
            ])
        ]);
        exit;
    }
    $keyboard = [];
    foreach($res as $cat){
        $id = $cat['id'];
        $title = $cat['volume'];
        $keyboard[] = ['text' => "$title", 'callback_data' => "daydetail#$id"];
    }
    $keyboard = array_chunk($keyboard,2);
    $keyboard[] = [['text' => "افزودن پلن زمانی جدید", 'callback_data' =>"adddayplan"]];
    $msg = ' 📍 برای دیدن جزییات پلن زمانی روی آن بزنید👇';
    
    if(!is_null($cdata) and $cdata=='backday') {
        bot('editMessageText', [
            'chat_id' => $userid,
            'message_id' => $cmsgid,
            'text'=> $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }else { $telegram->sendAction($userid, 'typing');
        bot('sendmessage',[
            'chat_id' => $userid,
            'text'=> $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }
    
    
    exit;
}
if($cdata=='adddayplan' and ($userid == ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",'adddayplan');
    $telegram->sendMessageCURL($userid,"تعداد روز و قیمت آن را بصورت زیر وارد کنید :
10-30000

مقدار اول مدت زمان (10) روز
مقدار دوم قیمت (30000) تومان
 ",$cancelop);exit;
}
if(preg_match('/adddayplan/',$state) and $text != '❌ انصراف') {
    $input = explode('-',$text); 
	if(count($input) != 2) {$telegram->sendmessage($userid, 'فرمت ارسالی صحیح نیست. لطفا متن بالا را مجدد بخوانید');exit;}
    $volume = intval($input[0]);
    $price = intval($input[1]);
    $telegram->db->query("insert into extra_day VALUES (NULL,$volume,$price)");
    $telegram->sendMessageCURL($userid,"پلن زمانی جدید با موفقیت اضافه شد",$adminop);
    file_put_contents("state/$userid.txt",'');
}
if(preg_match('/daydetail/', $cdata)){
    $id = str_replace('daydetail#','', $cdata);
    $pd = $telegram->db->query("SELECT * FROM `extra_day` WHERE id=$id")->fetch(2);
    if(empty($pd)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "موردی یافت نشد",
            'show_alert' => false
        ]);exit;
    }else {
        $id=$pd['id'];
        $volume=$pd['volume'];
        $price=$pd['price'];
        $acount =$pd['acount'];
        $msg = "
▪️#$id
📡$volume روز /chpdaydy$id
💶قیمت $price تومان /chpddyp$id
❌حذف: /delddyp$id
";
       $keyboard = [[['text' => "↪ برگشت", 'callback_data' =>"backday"],]];
       $aa = bot('editmessageText', [
            'chat_id' => $userid,
            'message_id' => $cmsgid,
            'parse_mode' => "HTML",
            'text' => $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
        }
    
}
if(preg_match('/delddyp/',$text) and ($userid==ADMIN or isAdmin() )){
    $fid=str_ireplace('/delddyp','',$text);
    $telegram->db->query("delete from extra_day where id={$fid}");
    $telegram->sendMessage($userid,"پلن موردنظر با موفقیت حذف شد");
}
if(preg_match('/chpddyp/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"قیمت جدید را وارد کنید:", $cancelop);exit;
}
if(preg_match('/chpddyp/',$state) and $text != '❌ انصراف') {
    $pid=str_ireplace('/chpddyp','',$state);
    if(is_numeric($text)){
        $telegram->db->query("update extra_day set price='$text' where id={$pid}");
        $telegram->sendMessageCURL($userid,"✅عملیات با موفقیت انجام شد", $adminop);
        file_put_contents("state/$userid.txt",'');
    }else{
        $telegram->sendMessage($userid,"یک مقدار عددی و صحیح وارد کنید");
    }
}
if(preg_match('/chpdaydy/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"روز جدید را وارد کنید:", $cancelop);exit;
}
if(preg_match('/chpdaydy/',$state) and $text != '❌ انصراف') {
    $pid=str_ireplace('/chpdaydy','',$state);
    $telegram->db->query("update extra_day set volume=$text where id={$pid}");
    $telegram->sendMessageCURL($userid,"✅عملیات با موفقیت انجام شد", $adminop);
    file_put_contents("state/$userid.txt",'');
}
/******* end */
if($text=='پلن حجمی' or $cdata == 'backvol' and ($userid==ADMIN or isAdmin() )){
    $res = $telegram->db->query("select * from extra_plan")->fetchAll(2);
    if(empty($res)){
       bot('sendmessage', [
            'chat_id' => $userid,
            'parse_mode' => "HTML",
            'text' => 'لیست پلن های حجمی خالی است ',
            'reply_markup' => json_encode([
                'inline_keyboard' => [[['text' => "افزودن پلن حجمی جدید", 'callback_data' =>"addvolumeplan"],]]
            ])
        ]);
        exit;
    }
    $keyboard = [];
    foreach($res as $cat){
        $id = $cat['id'];
        $title = $cat['volume'];
        $keyboard[] = ['text' => "$title", 'callback_data' => "voldetail#$id"];
    }
    $keyboard = array_chunk($keyboard,2);
    $keyboard[] = [['text' => "افزودن پلن حجمی جدید", 'callback_data' =>"addvolumeplan"]];
    $msg = ' 📍 برای دیدن جزییات پلن حجمی روی آن بزنید👇';
    
    if(!is_null($cdata) and $cdata=='backvol') {
        bot('editMessageText', [
            'chat_id' => $userid,
            'message_id' => $cmsgid,
            'text'=> $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }else { $telegram->sendAction($userid, 'typing');
        bot('sendmessage',[
            'chat_id' => $userid,
            'text'=> $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }
    
    
    exit;
}
if($cdata=='addvolumeplan' and ($userid == ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",'addvolplan');
    $telegram->sendMessageCURL($userid,"حجم و قیمت آن را بصورت زیر وارد کنید :
10-30000

مقدار اول حجم (10) گیگابایت
مقدار دوم قیمت (30000) تومان
 ",$cancelop);exit;
}
if(preg_match('/addvolplan/',$state) and $text != '❌ انصراف') {
    $input = explode('-',$text); 
	if(count($input) != 2) {$telegram->sendmessage($userid, 'فرمت ارسالی صحیح نیست. لطفا متن بالا را مجدد بخوانید');exit;}
    $volume = intval($input[0]);
    $price = intval($input[1]);
    $telegram->db->query("insert into extra_plan VALUES (NULL,$volume,$price)"); 
    $telegram->sendMessageCURL($userid,"پلن حجمی جدید با موفقیت اضافه شد",$adminop);
    file_put_contents("state/$userid.txt",'');
}
if(preg_match('/voldetail/', $cdata)){
    $id = str_replace('voldetail#','', $cdata);
    $pd = $telegram->db->query("SELECT * FROM `extra_plan` WHERE id=$id")->fetch(2);
    if(empty($pd)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "موردی یافت نشد",
            'show_alert' => false
        ]);exit;
    }else {
        $id=$pd['id'];
        $volume=$pd['volume'];
        $price=$pd['price'];
        $acount =$pd['acount'];
        $msg = "
▪️#$id
📡حجم $volume گیگ /chpvvl$id
💶قیمت $price تومان /chpvlp$id
❌حذف: /delvl$id
";
       $keyboard = [[['text' => "↪ برگشت", 'callback_data' =>"backvol"],]];
       $aa = bot('editmessageText', [
            'chat_id' => $userid,
            'message_id' => $cmsgid,
            'parse_mode' => "HTML",
            'text' => $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
        }
    
}
if(preg_match('/delvl/',$text) and ($userid==ADMIN or isAdmin() )){
    $fid=str_ireplace('/delvl','',$text);
    $telegram->db->query("delete from extra_plan where id={$fid}");
    $telegram->sendMessage($userid,"پلن موردنظر با موفقیت حذف شد");
}
if(preg_match('/chpvlp/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"قیمت جدید را وارد کنید:", $cancelop);exit;
}
if(preg_match('/chpvlp/',$state) and $text != '❌ انصراف') {
    $pid=str_ireplace('/chpvlp','',$state);
    if(is_numeric($text)){
        $telegram->db->query("update extra_plan set price='$text' where id={$pid}");
        $telegram->sendMessageCURL($userid,"✅عملیات با موفقیت انجام شد", $adminop);
        file_put_contents("state/$userid.txt",'');
    }else{
        $telegram->sendMessage($userid,"یک مقدار عددی و صحیح وارد کنید");
    }
}
if(preg_match('/chpvvl/',$text) and ($userid==ADMIN or isAdmin() )){
    file_put_contents("state/$userid.txt",$text);
    $telegram->sendMessageCURL($userid,"حجم جدید را وارد کنید:", $cancelop);exit;
}
if(preg_match('/chpvvl/',$state) and $text != '❌ انصراف') {
    $pid=str_ireplace('/chpvvl','',$state);
    $telegram->db->query("update extra_plan set volume=$text where id={$pid}");
    $telegram->sendMessageCURL($userid,"✅عملیات با موفقیت انجام شد", $adminop);
    file_put_contents("state/$userid.txt",'');
}
/*end extra */
if($text=='👤 پیگیری افراد' and ($userid == ADMIN or isAdmin() )){
    file_put_contents('state/'.$userid.'.txt','uinfo');
    $msg = "لطفا آی دی عددی یا نام کاربر را وارد کنید";
    $telegram->sendMessageCURL($userid,$msg,$cancelop);
}
if($state=='uinfo' and ($userid == ADMIN or isAdmin() ) and $text!='❌ انصراف'){
	if(strlen($text) < 3) {
        $telegram->sendMessage($userid,'لطفا کاراکتر صحیح با حداقل 3  وارد کنید');
        exit;
    }
    $users = $telegram->db->query("select * from fl_user where userid='$text' OR name LIKE '%$text%'")->fetchAll(2);
    if(empty($users)){
        $telegram->sendMessage($userid,'کاربری یافت نشد');
        exit;
    }
    $msg = '';
    foreach ($users as $user){
		$status = $user['status'] ? '✅' : '☑';
        $orders = $telegram->db->query("select * from fl_order where userid='".$user['userid']."' and status=1")->fetchAll(2);
        $orders_count = count($orders);
		
		$list = $telegram->db->query("select * from fl_subuser where  toplevel_userid=".$user['userid'])->fetchAll(2);
        $list_count = count($list);
		
        file_put_contents('state/'.$userid.'.txt','');
        $msg .= "
➖id : <code>".$user['userid']."</code>
➖name : <b>".$user['name']."</b>
➖username : <code>".$user['username']."</code>
➖tel : <b>".$user['tel']."</b>
➖Subs : $list_count /guslst".$user['userid']."
➖status : $status /banusr".$user['id']."
➖orders : <b>$orders_count</b> /getuord".$user['userid']."
➖wallet : <b>".number_format($user['wallet'])."</b> /waladd".$user['id'].PHP_EOL;

        if(strlen($msg) > 3950){
            $telegram->sendHTML($userid,$msg,$adminop);
            $msg = '';
        }
    }
    $aa = $telegram->sendHTML($userid,$msg,$adminop);
    //$telegram->sendHTML($userid,json_encode($aa));

}
if(preg_match('/guslst/', $text) and ($userid==ADMIN or isAdmin() ) )  {
    $uid = str_replace('/guslst','', $text);
    $list = $telegram->db->query("select * from fl_subuser where  toplevel_userid=$uid")->fetchAll(2);
    if(empty($list)){
        $telegram->sendMessage($userid, 'لیست خالی است');exit;
    }else{
        $count = 0;
        foreach ($list as $sb) {
            $uname = $sb['fname'];
            $msg .= "$count - $uname \n";
            $count++;
        }
        $telegram->sendMessage($userid, $msg);
    }
}
if($text == "🔎جستجو سفارش" and ($userid==ADMIN or isAdmin() ) )  {
    file_put_contents('state/' . $userid . '.txt', 'srchrmrk');
    $telegram->sendMessageCURL($userid, "⏪ ریمارک کانفیگ را ارسال کنید مثلا srv-50",$cancelop);exit;
}
if($state == 'srchrmrk' and $text != '❌ انصراف'){
    $remark = $text;
    if(preg_match('/^vmess:\/\//',$text)){
        $link_info = json_decode(base64_decode(str_replace('vmess://','',$text)));
        $remark = $link_info->ps;
    }elseif(preg_match('/^ss:\/\//',$text)){
	    $link_info = str_replace("ss://",'',$text);
	    $link_info = explode("#",$link_info);
	    $remark = $link_info[1];
	}elseif(preg_match('/^vless:\/\//',$text)){
		$link = urldecode($text);
        $link_info = parse_url($link);
        $remark = $link_info['fragment'];
    }
    $result = $telegram->db->query("select * from fl_order where remark LIKE '%$remark%' and status=1")->fetch(2);
    if(empty($result)){
        $telegram->sendMessage($userid,"موردی یافت نشد");exit;
    }else{
        $id = $result['id'];
        $remark = $result['remark'];
        $uid = $result['userid'];
        $server_id = $result['server_id'];
        $inbound_id = $result['inbound_id'];
        $telegram->sendMessageCURL($userid, "سفارش $remark یافت شد :",$adminop);
        $keyboard = [[['text' => "$remark", 'callback_data' =>  "svcdetadm#$id#$uid#0"]]];
        $msg = ' 📍 برای دیدن مشخصات سرویس روی آن بزنید👇';
        bot('sendmessage',[
            'chat_id' => $userid,
            'text'=> $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
        file_put_contents('state/' . $userid . '.txt', '');
        exit;
    }
}
if( (preg_match('/getuord/',$text) or preg_match('/ordADMINpaginate|getuord/',$cdata)) and ($userid==ADMIN or isAdmin() )){
    if(preg_match('/ordADMINpaginate/',$cdata)){
        $input = explode('#',$cdata);
        $newpage = $input[1];
        $uid = $input[2];
    }elseif(preg_match('/getuord/',$cdata)){
        $input = explode('#',$cdata);
        $uid = $input[1];
    }else $uid = str_ireplace('/getuord','', $text);
    
    $orders = $telegram->db->query("select * from fl_order where userid='$uid' and status=1")->fetchAll();
    if(empty($orders)){
        $telegram->sendMessage($userid,"لیست سفارش های کاربر خالی است");exit;
    }else{
        $results_per_page = 30;
        $number_of_result = $telegram->db->query("SELECT * FROM `fl_order` WHERE userid=$uid and status=1")->rowCount();
        $number_of_page = ceil ($number_of_result / $results_per_page);
        $page = (preg_match('/ordADMINpaginate/',$cdata)) ? $newpage : 1;
        $page_first_result = ($page-1) * $results_per_page;

        $orders = $telegram->db->query("SELECT * FROM `fl_order` WHERE userid=$uid and status=1 order by id DESC limit $page_first_result, $results_per_page")->fetchAll();
        if(empty($orders)){
            $telegram->sendMessage($userid, 'لیست سفارش ها خالی است.');
            exit;
        }
        $keyboard = [];
        foreach($orders as $order){
            $id = $order['id'];
            $remark = $order['remark'];
            $server_id = $order['server_id'];
            $inbound_id = $order['inbound_id'];
            $sres = $telegram->db->query("select * from fl_server WHERE id=$server_id")->fetch(2);
            $stitle = $sres['title'];
            $flag = $sres['flag'];

            $keyboard[] =
                ['text' => "$remark", 'callback_data' => "svcdetadm#$id#$uid#$page"];
            // ['text' => "#$server_id $stitle $flag", 'callback_data' => "not223hing"],

        }
        $keyboard = array_chunk($keyboard,2);

        /* Setup page vars for display. */
        $prev = $page - 1;      //previous page is page - 1
        $next = $page + 1;      //next page is page + 1
        $lastpage = ceil($number_of_page/$results_per_page);      //lastpage is = total pages / items per page, rounded up.
        $lpm1 = $lastpage - 1;                      //last page minus 1
        //$telegram->sendMessage($userid,"prev $prev next $next lastpage $lastpage page_first_result $page_first_result page $page number_of_page $number_of_page number_of_result $number_of_result");

        $buttons = [];
        //previous button
        if ($prev > 0) $buttons[] = ['text' => "◀", 'callback_data' => "ordADMINpaginate#$prev#$uid"];

        //next button
        if ($next > 0 and $page != $number_of_page) $buttons[] = ['text' => "▶", 'callback_data' => "ordADMINpaginate#$next#$uid"]; $keyboard[] = $buttons;

        $msg = ' 📍 برای نمایش اطلاعات سرویس روی آن بزنید👇';

        if(!is_null($cdata)) {
            bot('editMessageText', [
                'chat_id' => $userid,
                'message_id' => $cmsgid,
                'text'=> $msg,
                'reply_markup' => json_encode([
                    'inline_keyboard' => $keyboard
                ])
            ]);
        }else { $telegram->sendAction($userid, 'typing');
            bot('sendmessage',[
                'chat_id' => $userid,
                'text'=> $msg,
                'reply_markup' => json_encode([
                    'inline_keyboard' => $keyboard
                ])
            ]);
        }
        exit;
    }
}
if(preg_match('/endisclient/', $cdata)){
    $input = explode('#', $cdata);
    $oid = $input[1];
    $uid = $input[2];
    $page = $input[3];
    $order = $telegram->db->query("SELECT * FROM `fl_order` WHERE id='$oid' ")->fetch(2);
    $remark = $order['remark'];
    $inbound_id = $order['inbound_id'];
    $server_id = $order['server_id'];
  
    include_once('vray.php');
    $response = endis_client($server_id, $inbound_id, $remark);
    //$telegram->sendMessage($userid, json_encode($response));die;
    if(is_null($response)){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻اتصال به سرور برقرار نیست. لطفا به مدیریت اطلاع بدید',
            'show_alert' => true
        ]);
        exit;
    }
	if(!$response->success){
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => '🔻خطا در تغییر وضعیت. لطفا به مدیریت اطلاع بدید',
            'show_alert' => true
        ]);$telegram->sendMessage(ADMIN,$response->msg);
        exit;
    }
    $cdata = "svcdetadm#$oid#$uid#$page";
}
if(preg_match('/svcdetadm/', $cdata)){
    $input = explode('#', $cdata);
    $id = $input[1];
    $uid = $input[2];
    $order = $telegram->db->query("SELECT * FROM `fl_order` WHERE id=$id")->fetch(2);
    $sid = $order['server_id'];
    $remark = $order['remark'];
    //$inbound_id = $order['inbound_id'];
    $page = $input[3];
	
    $order = $telegram->db->query("SELECT * FROM `fl_order` WHERE id=$id")->fetch(2);
    if(empty($order)){
        $telegram->sendMessage($userid,"موردی یافت نشد");exit;
    }else {
        $fid = $order['fileid'];
        $name = $order['remark'];

        $date = jdate("Y-m-d H:i",$order['date']);
        $expire_date = jdate(" H:i d-m-Y",$order['expire_date']);
        $remark = $order['remark'];
        $acc_link = $order['link'];
        $protocol = $order['protocol'];
        $server_id = $order['server_id'];
        $inbound_id = $order['inbound_id'];

        include_once('vray.php');
        $response = getList($server_id)->obj;
        if($inbound_id == 0) {
            foreach($response as $row){
                if($row->remark == $remark) {
                    $enable = $row->enable;
                    $total = $row->total;
                    $up = $row->up;
                    $down = $row->down;
                    $netType = json_decode($row->streamSettings)->network;
					
					$expire_date = jdate(" H:i d-m-Y",substr_replace($row->expiryTime, "", -3));
                    break;
                }
            }
        }else {
            foreach($response as $row){
                $settings = json_decode($row->settings, true);
                if($row->id == $inbound_id) {
                    $netType = json_decode($row->streamSettings)->network;
                    $clients = $row->clientStats;
                    foreach($clients as $client) {
                        if($client->email == $remark) {
                            $enable = $client->enable;
                            $total = $client->total;
                            $up = $client->up;
                            $down = $client->down;
                            // $expire_date = jdate("H:i Y-m-d",$client->expiryTime);
							$expire_date = jdate(" H:i d-m-Y",substr_replace($client->expiryTime, "", -3));
                            break;
                        }
                    }
                    $clients = $settings['clients']; 
                    foreach($clients as $key => $client) {
                        if($client['email'] == $remark) {
                            if(is_null($total)) $total = $client['totalGB'];
                            $enable = $client['enable'];
                            break;
                        }
                    }
                    break;
                }
            }
        }

        $sres = $telegram->db->query("select * from fl_server WHERE id=$server_id")->fetch(2);
        $stitle = $sres['title'];
        $flag = $sres['flag'];

        $leftgb = round( ($total - $up - $down) / 1073741824, 2) . " GB";
        $msg = "#$name \n UserID: $uid \n 🌐$stitle $flag\n📝 $date \n🔗<code>$acc_link</code>";
        $status_label = $enable ? '✅فعال' : '☑️غیرفعال';
        $keyboard = [
            [

                ['text' => " $leftgb حجم باقیمانده", 'callback_data' => "updttlrmrk#$server_id#$remark#$inbound_id"],
                ['text' => $netType. " نوع شبکه ", 'callback_data' => "4no4thi5ng"],
            ],
            [
                ['text' => " انقضا ⏰ ". $expire_date, 'callback_data' => "updexprmrk#$server_id#$remark#$inbound_id"],
            ],
            [
                ['text' => " $protocol پروتکل📡", 'callback_data' => "nrod1th6ing"],
				['text' => "❌حذف سرویس", 'callback_data' => "dlmysv#$id"]
            ],
			[['text' => $enable ? '✅فعال' : '☑️غیرفعال', 'callback_data' => "endisclient#$id#$uid#$page"]],
        ];
        //if($page != 0) $keyboard[] = [['text' => "↪ برگشت", 'callback_data' => "ordADMINpaginate#$page#$uid"]];
		$keyboard[] = [['text' => "↪ برگشت", 'callback_data' => "getuord#$uid"]];

        bot('editmessageText', [
            'chat_id' => $userid,
            'message_id' => $cmsgid,
            'parse_mode' => "HTML",
            'text' => $msg,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ]);
    }

}
if(preg_match('/updexprmrk/', $cdata)){
    file_put_contents('state/' . $userid . '.txt', $cdata);
    $telegram->sendMessageCURL($userid,"تعداد روز را وارد کنید:",$cancelop);
    
}
if(preg_match('/updexprmrk/', $state) and $text != '❌ انصراف'){
    $input = explode('#',$state);
    $server_id = $input[1];
    $remark = $input[2];
    $inbound_id = $input[3];

    $days = intval($text);
    if($days == 0){
        $telegram->sendMessage($userid, "مقدار نمی تواند صفر باشد. همچنین اعداد باید بصورت لاتین وارد کنید");
        exit;
    }
    
    require_once('vray.php');
    if($inbound_id > 0)
        $response = update_client_traffic($server_id, $inbound_id, $remark, 0, $days);
    else
        $response = update_inbound_traffic($server_id, $remark, 0, $days);
    if($response->success){
		$telegram->db->query("update fl_order set notif=0 where remark='$remark'");
    }else {
        $telegram->sendMessage($userid, "مشکل فنی در ارتباط با سرور. لطفا سلامت سرور را بررسی کنید");
        exit;
    }
    file_put_contents('state/' . $userid . '.txt', '');
    
    if($days > 0) $days = "+$days";
    $telegram->sendMessageCURL($userid,"$days روز از زمان سرویس تغییر کرد",$adminop);
}
if(preg_match('/updttlrmrk/', $cdata)){
    file_put_contents('state/' . $userid . '.txt', $cdata);
    $telegram->sendMessageCURL($userid,"مقدار گیگ جدید را وارد کنید:",$cancelop);
    
}
if(preg_match('/updttlrmrk/', $state) and $text != '❌ انصراف'){
    $input = explode('#',$state);
    $server_id = $input[1];
    $remark = $input[2];
    $inbound_id = $input[3];

    $volume = intval($text);
    if($volume == 0){
        $telegram->sendMessage($userid, "مقدار نمی تواند صفر باشد. همچنین اعداد باید بصورت لاتین وارد کنید");
        exit;
    }

    require_once('vray.php');
    if($inbound_id > 0)
        $response = update_client_traffic($server_id, $inbound_id, $remark, $volume, 0);
    else
        $response = update_inbound_traffic($server_id, $remark, $volume, 0);
    if($response->success){
		$telegram->db->query("update fl_order set notif=0 where remark='$remark'");
    }else {
        $telegram->sendMessage($userid, "مشکل فنی در ارتباط با سرور. لطفا سلامت سرور را بررسی کنید");
        exit;
    }
    file_put_contents('state/' . $userid . '.txt', '');
    
    if($volume > 0) $volume = "+$volume";
    $telegram->sendMessageCURL($userid,"$volume گیگ از حجم سرویس تغییر کرد",$adminop);
}
if(preg_match('/dlusmysv/', $cdata)){
    if($gateways['delete_service'] == 0 and !is_null($gateways['delete_service'])) {
        bot('answercallbackquery', [
            'callback_query_id' => $cid,
            'text' => "در حال حاضر امکان حذف سرویس نیست",
            'show_alert' => false
        ]);
        exit;
    }
    
    $id = str_replace('dlusmysv#','', $cdata);
    $keyboard = [[['text' => "☑️خیر", 'callback_data' => "ordetail#$id"],['text' => "✅بله", 'callback_data' => "dlmysv#$id"]]];
            
    bot('editmessageText', [
        'chat_id' => $userid,
        'message_id' => $cmsgid,
        'parse_mode' => "HTML",
        'text' => '⚠️بعد از حذف سرویس مبلغی به حساب کاربری شما عودت داده نمیشود',
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]); 
}
if(preg_match('/dlmysv/', $cdata)){
    $id = str_replace('dlmysv#','', $cdata);
    $order = $telegram->db->query("SELECT * FROM `fl_order` WHERE id=$id")->fetch(2);
    $remark = $order['remark'];
    $protocol = $order['protocol'];
    $server_id = $order['server_id'];
    $inbound_id = $order['inbound_id'];
    
    require_once('vray.php');
    if($inbound_id > 0) {
       $response = remove_client($server_id, $inbound_id, $remark, 1);
        
    }else{
        $response = remove_inbound($server_id, $remark, 1);
    }
    $telegram->db->query("DELETE FROM `fl_order` WHERE remark='$remark'");
    
   bot('editmessageText', [
        'chat_id' => $userid,
        'message_id' => $cmsgid,
        'parse_mode' => "HTML",
        'text' => "سرویس $remark با موفقیت حذف شد",
    ]); 
}
if ($text == '📨 فوروارد همگانی' and ($userid == ADMIN or isAdmin() )){
    $cronjob = file_get_contents('fwjob.txt');
    $msg = file_get_contents('fwid.txt');
    if(strlen($msg) > 1 and $cronjob != 0) {
        $users = $telegram->db->query("select * from fl_user")->rowCount();
        $leftm = $cronjob == 1 ? $users - $cronjob +1 : $users - $cronjob;
        $cronjob = $cronjob == 1 ? $cronjob-1 : $cronjob;
		//$leftm = $users - $cronjob;
        $telegram->sendMessage($userid, "📨یک فروارد همگانی در حال ارسال می باشد و باید تا زمان اتمام آن منتظر بمانید
👤جمع کل کاربران : $users
✅تعداد ارسال شده : $cronjob
♻️تعداد باقی مانده : $leftm
.");exit;
    }
    $state = file_put_contents('state/' . $userid . '.txt', 'f2a');
    $msg = "لطفا پیام خود ارسال کنید. ";
    $telegram->sendAction($userid, 'typing');
    $telegram->sendHTML($userid, $msg, $cancelop);
    exit;
}
if($state=='f2a' and $text!='❌ انصراف'){
    file_put_contents('state/'.$userid.'.txt','');
    file_put_contents('fwjob.txt', 1);
    $pmvalue = json_encode(['userid'=>$userid,'msgid'=>$msgid]);
    file_put_contents('fwid.txt', $pmvalue);
    $telegram->sendMessageCURL($userid, '👍🏻✅ پیام شما در صف ارسال به تمام کاربران ربات قرار گرفت ... ', $adminop);
}
if($text=='📮 پیام به کاربر' and ($userid == ADMIN or isAdmin() )){
    file_put_contents('state/'.$userid.'.txt','msg');
    $msg = "لطفا آی دی کاربر دریافت کننده پیام را وارد کنید";
    $telegram->sendMessageCURL($userid,$msg,$cancelop);
}
if($state=='msg' and ($userid == ADMIN or isAdmin() ) and $text!='❌ انصراف'){
    $user = $telegram->db->query("select * from fl_user where userid='$text' ")->rowCount();
    if(!$user){
        $telegram->sendMessage($userid,'کاربر مورد نظر یافت نشد');
        exit;
    }
    file_put_contents('state/'.$userid.'.txt','sendmsg'.$text);
    $msg = "حالا پیام خود را وارد کنید";
    $telegram->sendMessageCURL($userid,$msg,$cancelop);
}
if(preg_match('/sendmsg/',$state) and ($userid == ADMIN or isAdmin() ) and $text!='❌ انصراف'){
    $uid = str_replace('sendmsg','',$state);
    $user = $telegram->db->query("select * from fl_user where userid=$uid ")->fetch(2);
    if(!$user){
        $telegram->sendMessage($userid,'کاربر مورد نظر یافت نشد');
        exit;
    }
    $uid = $user['userid'];
    file_put_contents('state/'.$userid.'.txt','');
    
    $telegram->sendMessage($uid,$text);
    $telegram->sendMessageCURL($userid,'پیام شما با موفقیت به کاربر ارسال شد.',$adminop);exit;
}
if($text == '/id' or $text == '🆔 آیدی من'){
    file_put_contents('state/' . $userid . '.txt', '');
    $telegram->sendHTML($userid, "آیدی عددی : <code>$userid</code>", $finalop);
    exit;
}
if(preg_match('/banusr/',$text) and ($userid==ADMIN or isAdmin() )){
    $id = str_replace('/banusr','', $text);
    $user = $telegram->db->query("select * from fl_user where id=$id")->fetch(2);
    if(!$user){
        $telegram->sendMessage($userid,'کاربر مورد نظر یافت نشد');
        exit;
    }
    $telegram->db->query("update fl_user set status = !status where id=$id");
    $telegram->sendMessage($userid,"وضعیت کاربر تغییر کرد");
}

if($text=='⚙️ تنظیمات' and ($userid==ADMIN or isAdmin() ) ){
    $keyboard =[
        [
            ['text' => ($botstatus == '' ? '✅' : '') ."On Bot", 'callback_data' => "onbot"],
            ['text' => ($botstatus == '' ? '' : '✅') ."Off Bot", 'callback_data' => "offbot"],
        ],
    ];
    bot('sendmessage',[
        'chat_id' => $userid,
        'text'=> "لطفا یکی از گزینه ها را انتخاب کنید",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}
if(preg_match('/onbot|offbot/',$cdata) and ($userid==ADMIN or isAdmin() )){
    $botstatus = ($cdata == "onbot") ? '' : 'close';
    file_put_contents('botstatus',$botstatus);
    bot('answercallbackquery', [
        'callback_query_id' => $cid,
        'text' => "تغییرات اعمال شد",
        'show_alert' => false
    ]);
    $keyboard =[
        [
            ['text' => ($botstatus == '' ? '✅' : '') ."On Bot", 'callback_data' => "onbot"],
            ['text' => ($botstatus == '' ? '' : '✅') ."Off Bot", 'callback_data' => "offbot"],
        ],
    ];
    bot('editMessageText', [
        'chat_id' => $userid,
        'message_id' => $cmsgid,
        'text'=> "لطفا یکی از گزینه ها را انتخاب کنید",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}
if($text=='🤖درگاه و امکانات‌' and ($userid==ADMIN or isAdmin() ) ){
    $gtw = $telegram->db->query("select * from gateway where id=1")->fetch(2);
    $keyboard =[
        [
            ['text' => ($gtw['zarin'] == 1 ? '✅' : '') ."زرین", 'callback_data' => "gtwa#zarin"],
            ['text' => ($gtw['next'] == 1 ? '✅' : '') ."نکست", 'callback_data' => "gtwa#next"],
			['text' => ($gtw['payping'] == 1 ? '✅' : '') ."payping", 'callback_data' => "gtwa#payping"],
        ],
        [
            ['text' => ($gtw['card'] == 1 ? '✅' : '') ."کارت", 'callback_data' => "gtwa#card"],
            ['text' => ($gtw['wallet'] == 1 ? '✅' : '') ."کیف پول", 'callback_data' => "gtwa#wallet"],
			['text' => ($gtw['novino'] == 1 ? '✅' : '') ."novino", 'callback_data' => "gtwa#novino"],
        ],
        [
            ['text' => ($gtw['buy'] == 1 ? '✅' : '') ."خرید", 'callback_data' => "gtwa#buy"],
			['text' => ($gtw['bahamta'] == 1 ? '✅' : '') ."باهمتا", 'callback_data' => "gtwa#bahamta"],
			['text' => ($gtw['zibal'] == 1 ? '✅' : '') ."زیبال", 'callback_data' => "gtwa#zibal"],
        ],
        [
            ['text' => ($gtw['change_location'] == 1 ? '✅' : '') ."تغییر لوکیشن", 'callback_data' => "gtwa#change_location"],
            ['text' => ($gtw['change_protocol'] == 1 ? '✅' : '') ."تغییر پروتکل", 'callback_data' => "gtwa#change_protocol"],
        ],
        [
            ['text' => ($gtw['buy_gb'] == 1 ? '✅' : '') ."خرید حجم", 'callback_data' => "gtwa#buy_gb"],
            ['text' => ($gtw['buy_day'] == 1 ? '✅' : '') ."خرید روز", 'callback_data' => "gtwa#buy_day"],
        ],
        [
            ['text' => ($gtw['renew'] == 1 ? '✅' : '') ."تمدید", 'callback_data' => "gtwa#renew"],
            ['text' => ($gtw['change_nettype'] == 1 ? '✅' : '') ."تغییر نوع شبکه", 'callback_data' => "gtwa#change_nettype"],
        ],
		[
            ['text' => ($gtw['delete_service'] == 1 ? '✅' : '') ."حذف سرویس", 'callback_data' => "gtwa#delete_service"],
			['text' => ($gtw['refund_service'] == 1 ? '✅' : '') ."عودت سرویس", 'callback_data' => "gtwa#refund_service"],
			['text' => ($gtw['sublink'] == 1 ? '✅' : '') ."ساب لینک", 'callback_data' => "gtwa#sublink"],
        ],
        
    ];
    bot('sendmessage',[
        'chat_id' => $userid,
        'text'=> "با کلیک روی هر یک از گزینه ها میتوانید آن را فعال یا غیرفعال کنید",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}
if(preg_match('/gtwa/',$cdata) and ($userid==ADMIN or isAdmin() )){
    $column = str_replace('gtwa#','',$cdata);
    $telegram->db->query("update gateway set $column = ! $column where id=1");
    $gtw = $telegram->db->query("select * from gateway where id=1 ")->fetch(2);
    bot('answercallbackquery', [
        'callback_query_id' => $cid,
        'text' => "تغییرات اعمال شد",
        'show_alert' => false
    ]);
    $keyboard =[
        [
            ['text' => ($gtw['zarin'] == 1 ? '✅' : '') ."زرین", 'callback_data' => "gtwa#zarin"],
            ['text' => ($gtw['next'] == 1 ? '✅' : '') ."نکست", 'callback_data' => "gtwa#next"],
            ['text' => ($gtw['payping'] == 1 ? '✅' : '') ."payping", 'callback_data' => "gtwa#payping"],
        ],
        [
            ['text' => ($gtw['card'] == 1 ? '✅' : '') ."کارت", 'callback_data' => "gtwa#card"],
            ['text' => ($gtw['wallet'] == 1 ? '✅' : '') ."کیف پول", 'callback_data' => "gtwa#wallet"],
            ['text' => ($gtw['novino'] == 1 ? '✅' : '') ."novino", 'callback_data' => "gtwa#novino"],
        ],
        [
            ['text' => ($gtw['buy'] == 1 ? '✅' : '') ."خرید", 'callback_data' => "gtwa#buy"],
            ['text' => ($gtw['bahamta'] == 1 ? '✅' : '') ."باهمتا", 'callback_data' => "gtwa#bahamta"],
            ['text' => ($gtw['zibal'] == 1 ? '✅' : '') ."زیبال", 'callback_data' => "gtwa#zibal"],
        ],
        [
            ['text' => ($gtw['change_location'] == 1 ? '✅' : '') ."تغییر لوکیشن", 'callback_data' => "gtwa#change_location"],
            ['text' => ($gtw['change_protocol'] == 1 ? '✅' : '') ."تغییر پروتکل", 'callback_data' => "gtwa#change_protocol"],
        ],
        [
            ['text' => ($gtw['buy_gb'] == 1 ? '✅' : '') ."خرید حجم", 'callback_data' => "gtwa#buy_gb"],
            ['text' => ($gtw['buy_day'] == 1 ? '✅' : '') ."خرید روز", 'callback_data' => "gtwa#buy_day"],
        ],
        [
            ['text' => ($gtw['renew'] == 1 ? '✅' : '') ."تمدید", 'callback_data' => "gtwa#renew"],
            ['text' => ($gtw['change_nettype'] == 1 ? '✅' : '') ."تغییر نوع شبکه", 'callback_data' => "gtwa#change_nettype"],
        ],
		[
            ['text' => ($gtw['delete_service'] == 1 ? '✅' : '') ."حذف سرویس", 'callback_data' => "gtwa#delete_service"],
            ['text' => ($gtw['refund_service'] == 1 ? '✅' : '') ."عودت سرویس", 'callback_data' => "gtwa#refund_service"],
			['text' => ($gtw['sublink'] == 1 ? '✅' : '') ."ساب لینک", 'callback_data' => "gtwa#sublink"],
        ],
        
    ];
    bot('editMessageText', [
        'chat_id' => $userid,
        'message_id' => $cmsgid,
        'text'=> "با کلیک روی هر یک از گزینه ها میتوانید آن را فعال یا غیرفعال کنید",
        'reply_markup' => json_encode([
            'inline_keyboard' => $keyboard
        ])
    ]);
}
if ($text == '❌ انصراف') {
    file_put_contents('state/' . $userid . '.txt', '');
    $telegram->db->query("delete from fl_file where active=0");
    $telegram->sendHTML($userid, '‼️‼️عملیات مورد نظر لغو شد', $finalop);
}